/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.function.Function;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.Identifier;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.slf4j.Logger;

public abstract class TemplateStructurePiece
extends StructurePiece {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected final String templateName;
    protected StructureTemplate template;
    protected StructurePlaceSettings placeSettings;
    protected BlockPos templatePosition;

    public TemplateStructurePiece(StructurePieceType var0, int var1, StructureTemplateManager var2, Identifier var3, String var4, StructurePlaceSettings var5, BlockPos var6) {
        super(var0, var1, var2.getOrCreate(var3).getBoundingBox(var5, var6));
        this.setOrientation(Direction.NORTH);
        this.templateName = var4;
        this.templatePosition = var6;
        this.template = var2.getOrCreate(var3);
        this.placeSettings = var5;
    }

    public TemplateStructurePiece(StructurePieceType var0, CompoundTag var1, StructureTemplateManager var2, Function<Identifier, StructurePlaceSettings> var3) {
        super(var0, var1);
        this.setOrientation(Direction.NORTH);
        this.templateName = var1.getStringOr("Template", "");
        this.templatePosition = new BlockPos(var1.getIntOr("TPX", 0), var1.getIntOr("TPY", 0), var1.getIntOr("TPZ", 0));
        Identifier var4 = this.makeTemplateLocation();
        this.template = var2.getOrCreate(var4);
        this.placeSettings = var3.apply(var4);
        this.boundingBox = this.template.getBoundingBox(this.placeSettings, this.templatePosition);
    }

    protected Identifier makeTemplateLocation() {
        return Identifier.parse(this.templateName);
    }

    @Override
    protected void addAdditionalSaveData(StructurePieceSerializationContext var0, CompoundTag var1) {
        var1.putInt("TPX", this.templatePosition.getX());
        var1.putInt("TPY", this.templatePosition.getY());
        var1.putInt("TPZ", this.templatePosition.getZ());
        var1.putString("Template", this.templateName);
    }

    @Override
    public void postProcess(WorldGenLevel var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, BoundingBox var4, ChunkPos var5, BlockPos var6) {
        this.placeSettings.setBoundingBox(var4);
        this.boundingBox = this.template.getBoundingBox(this.placeSettings, this.templatePosition);
        if (this.template.placeInWorld(var0, this.templatePosition, var6, this.placeSettings, var3, 2)) {
            List<StructureTemplate.StructureBlockInfo> var7 = this.template.filterBlocks(this.templatePosition, this.placeSettings, Blocks.STRUCTURE_BLOCK);
            for (StructureTemplate.StructureBlockInfo var9 : var7) {
                StructureMode structureMode;
                if (var9.nbt() == null || (structureMode = var9.nbt().read("mode", StructureMode.LEGACY_CODEC).orElseThrow()) != StructureMode.DATA) continue;
                this.handleDataMarker(var9.nbt().getStringOr("metadata", ""), var9.pos(), var0, var3, var4);
            }
            List<StructureTemplate.StructureBlockInfo> var8 = this.template.filterBlocks(this.templatePosition, this.placeSettings, Blocks.JIGSAW);
            for (StructureTemplate.StructureBlockInfo structureBlockInfo : var8) {
                if (structureBlockInfo.nbt() == null) continue;
                String var11 = structureBlockInfo.nbt().getStringOr("final_state", "minecraft:air");
                BlockState var12 = Blocks.AIR.defaultBlockState();
                try {
                    var12 = BlockStateParser.parseForBlock(var0.holderLookup(Registries.BLOCK), var11, true).blockState();
                }
                catch (CommandSyntaxException var13) {
                    LOGGER.error("Error while parsing blockstate {} in jigsaw block @ {}", (Object)var11, (Object)structureBlockInfo.pos());
                }
                var0.setBlock(structureBlockInfo.pos(), var12, 3);
            }
        }
    }

    protected abstract void handleDataMarker(String var1, BlockPos var2, ServerLevelAccessor var3, RandomSource var4, BoundingBox var5);

    @Override
    @Deprecated
    public void move(int var0, int var1, int var2) {
        super.move(var0, var1, var2);
        this.templatePosition = this.templatePosition.offset(var0, var1, var2);
    }

    @Override
    public Rotation getRotation() {
        return this.placeSettings.getRotation();
    }

    public StructureTemplate template() {
        return this.template;
    }

    public BlockPos templatePosition() {
        return this.templatePosition;
    }

    public StructurePlaceSettings placeSettings() {
        return this.placeSettings;
    }
}

