/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.Identifier;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class IglooPieces {
    public static final int GENERATION_HEIGHT = 90;
    static final Identifier STRUCTURE_LOCATION_IGLOO = Identifier.withDefaultNamespace("igloo/top");
    private static final Identifier STRUCTURE_LOCATION_LADDER = Identifier.withDefaultNamespace("igloo/middle");
    private static final Identifier STRUCTURE_LOCATION_LABORATORY = Identifier.withDefaultNamespace("igloo/bottom");
    static final Map<Identifier, BlockPos> PIVOTS = ImmutableMap.of((Object)STRUCTURE_LOCATION_IGLOO, (Object)new BlockPos(3, 5, 5), (Object)STRUCTURE_LOCATION_LADDER, (Object)new BlockPos(1, 3, 1), (Object)STRUCTURE_LOCATION_LABORATORY, (Object)new BlockPos(3, 6, 7));
    static final Map<Identifier, BlockPos> OFFSETS = ImmutableMap.of((Object)STRUCTURE_LOCATION_IGLOO, (Object)BlockPos.ZERO, (Object)STRUCTURE_LOCATION_LADDER, (Object)new BlockPos(2, -3, 4), (Object)STRUCTURE_LOCATION_LABORATORY, (Object)new BlockPos(0, -3, -2));

    public static void addPieces(StructureTemplateManager structuretemplatemanager, BlockPos blockposition, Rotation enumblockrotation, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
        if (randomsource.nextDouble() < 0.5) {
            int i = randomsource.nextInt(8) + 4;
            structurepieceaccessor.addPiece(new IglooPiece(structuretemplatemanager, STRUCTURE_LOCATION_LABORATORY, blockposition, enumblockrotation, i * 3));
            for (int j = 0; j < i - 1; ++j) {
                structurepieceaccessor.addPiece(new IglooPiece(structuretemplatemanager, STRUCTURE_LOCATION_LADDER, blockposition, enumblockrotation, j * 3));
            }
        }
        structurepieceaccessor.addPiece(new IglooPiece(structuretemplatemanager, STRUCTURE_LOCATION_IGLOO, blockposition, enumblockrotation, 0));
    }

    public static class IglooPiece
    extends TemplateStructurePiece {
        public IglooPiece(StructureTemplateManager structuretemplatemanager, Identifier minecraftkey, BlockPos blockposition, Rotation enumblockrotation, int i) {
            super(StructurePieceType.IGLOO, 0, structuretemplatemanager, minecraftkey, minecraftkey.toString(), IglooPiece.makeSettings(enumblockrotation, minecraftkey), IglooPiece.makePosition(minecraftkey, blockposition, i));
        }

        public IglooPiece(StructureTemplateManager structuretemplatemanager, CompoundTag nbttagcompound) {
            super(StructurePieceType.IGLOO, nbttagcompound, structuretemplatemanager, minecraftkey -> IglooPiece.makeSettings(nbttagcompound.read("Rot", Rotation.LEGACY_CODEC).orElseThrow(), minecraftkey));
        }

        private static StructurePlaceSettings makeSettings(Rotation enumblockrotation, Identifier minecraftkey) {
            return new StructurePlaceSettings().setRotation(enumblockrotation).setMirror(Mirror.NONE).setRotationPivot(PIVOTS.get(minecraftkey)).addProcessor(BlockIgnoreProcessor.STRUCTURE_BLOCK).setLiquidSettings(LiquidSettings.IGNORE_WATERLOGGING);
        }

        private static BlockPos makePosition(Identifier minecraftkey, BlockPos blockposition, int i) {
            return blockposition.offset(OFFSETS.get(minecraftkey)).below(i);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext structurepieceserializationcontext, CompoundTag nbttagcompound) {
            super.addAdditionalSaveData(structurepieceserializationcontext, nbttagcompound);
            nbttagcompound.store("Rot", Rotation.LEGACY_CODEC, this.placeSettings.getRotation());
        }

        @Override
        protected void handleDataMarker(String s, BlockPos blockposition, ServerLevelAccessor worldaccess, RandomSource randomsource, BoundingBox structureboundingbox) {
            if ("chest".equals(s)) {
                worldaccess.setBlock(blockposition, Blocks.AIR.defaultBlockState(), 3);
                this.setCraftLootTable(worldaccess, blockposition.below(), randomsource, BuiltInLootTables.IGLOO_CHEST);
            }
        }

        @Override
        public void postProcess(WorldGenLevel generatoraccessseed, StructureManager structuremanager, ChunkGenerator chunkgenerator, RandomSource randomsource, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair, BlockPos blockposition) {
            BlockPos blockposition4;
            BlockState iblockdata;
            Identifier minecraftkey = Identifier.parse(this.templateName);
            StructurePlaceSettings definedstructureinfo = IglooPiece.makeSettings(this.placeSettings.getRotation(), minecraftkey);
            BlockPos blockposition1 = OFFSETS.get(minecraftkey);
            BlockPos blockposition2 = this.templatePosition.offset(StructureTemplate.calculateRelativePosition(definedstructureinfo, new BlockPos(3 - blockposition1.getX(), 0, -blockposition1.getZ())));
            int i = generatoraccessseed.getHeight(Heightmap.Types.WORLD_SURFACE_WG, blockposition2.getX(), blockposition2.getZ());
            BlockPos blockposition3 = this.templatePosition;
            this.templatePosition = this.templatePosition.offset(0, i - 90 - 1, 0);
            super.postProcess(generatoraccessseed, structuremanager, chunkgenerator, randomsource, structureboundingbox, chunkcoordintpair, blockposition);
            if (minecraftkey.equals(STRUCTURE_LOCATION_IGLOO) && !(iblockdata = generatoraccessseed.getBlockState((blockposition4 = this.templatePosition.offset(StructureTemplate.calculateRelativePosition(definedstructureinfo, new BlockPos(3, 0, 5)))).below())).isAir() && !iblockdata.is(Blocks.LADDER)) {
                generatoraccessseed.setBlock(blockposition4, Blocks.SNOW_BLOCK.defaultBlockState(), 3);
            }
            this.templatePosition = blockposition3;
        }
    }
}

