/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.structures.NetherFortressPieces;

public class NetherFortressStructure
extends Structure {
    public static final WeightedList<MobSpawnSettings.SpawnerData> FORTRESS_ENEMIES = WeightedList.builder().add(new MobSpawnSettings.SpawnerData(EntityType.BLAZE, 2, 3), 10).add(new MobSpawnSettings.SpawnerData(EntityType.ZOMBIFIED_PIGLIN, 4, 4), 5).add(new MobSpawnSettings.SpawnerData(EntityType.WITHER_SKELETON, 5, 5), 8).add(new MobSpawnSettings.SpawnerData(EntityType.SKELETON, 5, 5), 2).add(new MobSpawnSettings.SpawnerData(EntityType.MAGMA_CUBE, 4, 4), 3).build();
    public static final MapCodec<NetherFortressStructure> CODEC = NetherFortressStructure.simpleCodec(NetherFortressStructure::new);

    public NetherFortressStructure(Structure.StructureSettings var0) {
        super(var0);
    }

    @Override
    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext var0) {
        ChunkPos var12 = var0.chunkPos();
        BlockPos var2 = new BlockPos(var12.getMinBlockX(), 64, var12.getMinBlockZ());
        return Optional.of(new Structure.GenerationStub(var2, var1 -> NetherFortressStructure.generatePieces(var1, var0)));
    }

    private static void generatePieces(StructurePiecesBuilder var0, Structure.GenerationContext var1) {
        NetherFortressPieces.StartPiece var2 = new NetherFortressPieces.StartPiece(var1.random(), var1.chunkPos().getBlockX(2), var1.chunkPos().getBlockZ(2));
        var0.addPiece(var2);
        var2.addChildren(var2, var0, var1.random());
        List<StructurePiece> var3 = var2.pendingChildren;
        while (!var3.isEmpty()) {
            int var4 = var1.random().nextInt(var3.size());
            StructurePiece var5 = var3.remove(var4);
            var5.addChildren(var2, var0, var1.random());
        }
        var0.moveInsideHeights(var1.random(), 48, 70);
    }

    @Override
    public StructureType<?> type() {
        return StructureType.FORTRESS;
    }
}

