/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.Identifier;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class NetherFossilPieces {
    private static final Identifier[] FOSSILS = new Identifier[]{Identifier.withDefaultNamespace("nether_fossils/fossil_1"), Identifier.withDefaultNamespace("nether_fossils/fossil_2"), Identifier.withDefaultNamespace("nether_fossils/fossil_3"), Identifier.withDefaultNamespace("nether_fossils/fossil_4"), Identifier.withDefaultNamespace("nether_fossils/fossil_5"), Identifier.withDefaultNamespace("nether_fossils/fossil_6"), Identifier.withDefaultNamespace("nether_fossils/fossil_7"), Identifier.withDefaultNamespace("nether_fossils/fossil_8"), Identifier.withDefaultNamespace("nether_fossils/fossil_9"), Identifier.withDefaultNamespace("nether_fossils/fossil_10"), Identifier.withDefaultNamespace("nether_fossils/fossil_11"), Identifier.withDefaultNamespace("nether_fossils/fossil_12"), Identifier.withDefaultNamespace("nether_fossils/fossil_13"), Identifier.withDefaultNamespace("nether_fossils/fossil_14")};

    public static void addPieces(StructureTemplateManager var0, StructurePieceAccessor var1, RandomSource var2, BlockPos var3) {
        Rotation var4 = Rotation.getRandom(var2);
        var1.addPiece(new NetherFossilPiece(var0, Util.getRandom(FOSSILS, var2), var3, var4));
    }

    public static class NetherFossilPiece
    extends TemplateStructurePiece {
        public NetherFossilPiece(StructureTemplateManager var0, Identifier var1, BlockPos var2, Rotation var3) {
            super(StructurePieceType.NETHER_FOSSIL, 0, var0, var1, var1.toString(), NetherFossilPiece.makeSettings(var3), var2);
        }

        public NetherFossilPiece(StructureTemplateManager var0, CompoundTag var12) {
            super(StructurePieceType.NETHER_FOSSIL, var12, var0, (Identifier var1) -> NetherFossilPiece.makeSettings(var12.read("Rot", Rotation.LEGACY_CODEC).orElseThrow()));
        }

        private static StructurePlaceSettings makeSettings(Rotation var0) {
            return new StructurePlaceSettings().setRotation(var0).setMirror(Mirror.NONE).addProcessor(BlockIgnoreProcessor.STRUCTURE_AND_AIR);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext var0, CompoundTag var1) {
            super.addAdditionalSaveData(var0, var1);
            var1.store("Rot", Rotation.LEGACY_CODEC, this.placeSettings.getRotation());
        }

        @Override
        protected void handleDataMarker(String var0, BlockPos var1, ServerLevelAccessor var2, RandomSource var3, BoundingBox var4) {
        }

        @Override
        public void postProcess(WorldGenLevel var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, BoundingBox var4, ChunkPos var5, BlockPos var6) {
            BoundingBox var7 = this.template.getBoundingBox(this.placeSettings, this.templatePosition);
            var4.encapsulate(var7);
            super.postProcess(var0, var1, var2, var3, var4, var5, var6);
            this.placeDriedGhast(var0, var3, var7, var4);
        }

        private void placeDriedGhast(WorldGenLevel var0, RandomSource var1, BoundingBox var2, BoundingBox var3) {
            int var7;
            int var6;
            int var5;
            BlockPos var8;
            RandomSource var4 = RandomSource.create(var0.getSeed()).forkPositional().at(var2.getCenter());
            if (var4.nextFloat() < 0.5f && var0.getBlockState(var8 = new BlockPos(var5 = var2.minX() + var4.nextInt(var2.getXSpan()), var6 = var2.minY(), var7 = var2.minZ() + var4.nextInt(var2.getZSpan()))).isAir() && var3.isInside(var8)) {
                var0.setBlock(var8, Blocks.DRIED_GHAST.defaultBlockState().rotate(Rotation.getRandom(var4)), 2);
            }
        }
    }
}

