/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public class OceanMonumentPieces {
    private OceanMonumentPieces() {
    }

    static class FitDoubleYZRoom
    implements MonumentRoomFitter {
        FitDoubleYZRoom() {
        }

        @Override
        public boolean fits(RoomDefinition var0) {
            if (var0.hasOpening[Direction.NORTH.get3DDataValue()] && !var0.connections[Direction.NORTH.get3DDataValue()].claimed && var0.hasOpening[Direction.UP.get3DDataValue()] && !var0.connections[Direction.UP.get3DDataValue()].claimed) {
                RoomDefinition var1 = var0.connections[Direction.NORTH.get3DDataValue()];
                return var1.hasOpening[Direction.UP.get3DDataValue()] && !var1.connections[Direction.UP.get3DDataValue()].claimed;
            }
            return false;
        }

        @Override
        public OceanMonumentPiece create(Direction var0, RoomDefinition var1, RandomSource var2) {
            var1.claimed = true;
            var1.connections[Direction.NORTH.get3DDataValue()].claimed = true;
            var1.connections[Direction.UP.get3DDataValue()].claimed = true;
            var1.connections[Direction.NORTH.get3DDataValue()].connections[Direction.UP.get3DDataValue()].claimed = true;
            return new OceanMonumentDoubleYZRoom(var0, var1);
        }
    }

    static class FitDoubleXYRoom
    implements MonumentRoomFitter {
        FitDoubleXYRoom() {
        }

        @Override
        public boolean fits(RoomDefinition var0) {
            if (var0.hasOpening[Direction.EAST.get3DDataValue()] && !var0.connections[Direction.EAST.get3DDataValue()].claimed && var0.hasOpening[Direction.UP.get3DDataValue()] && !var0.connections[Direction.UP.get3DDataValue()].claimed) {
                RoomDefinition var1 = var0.connections[Direction.EAST.get3DDataValue()];
                return var1.hasOpening[Direction.UP.get3DDataValue()] && !var1.connections[Direction.UP.get3DDataValue()].claimed;
            }
            return false;
        }

        @Override
        public OceanMonumentPiece create(Direction var0, RoomDefinition var1, RandomSource var2) {
            var1.claimed = true;
            var1.connections[Direction.EAST.get3DDataValue()].claimed = true;
            var1.connections[Direction.UP.get3DDataValue()].claimed = true;
            var1.connections[Direction.EAST.get3DDataValue()].connections[Direction.UP.get3DDataValue()].claimed = true;
            return new OceanMonumentDoubleXYRoom(var0, var1);
        }
    }

    static class FitDoubleZRoom
    implements MonumentRoomFitter {
        FitDoubleZRoom() {
        }

        @Override
        public boolean fits(RoomDefinition var0) {
            return var0.hasOpening[Direction.NORTH.get3DDataValue()] && !var0.connections[Direction.NORTH.get3DDataValue()].claimed;
        }

        @Override
        public OceanMonumentPiece create(Direction var0, RoomDefinition var1, RandomSource var2) {
            RoomDefinition var3 = var1;
            if (!var1.hasOpening[Direction.NORTH.get3DDataValue()] || var1.connections[Direction.NORTH.get3DDataValue()].claimed) {
                var3 = var1.connections[Direction.SOUTH.get3DDataValue()];
            }
            var3.claimed = true;
            var3.connections[Direction.NORTH.get3DDataValue()].claimed = true;
            return new OceanMonumentDoubleZRoom(var0, var3);
        }
    }

    static class FitDoubleXRoom
    implements MonumentRoomFitter {
        FitDoubleXRoom() {
        }

        @Override
        public boolean fits(RoomDefinition var0) {
            return var0.hasOpening[Direction.EAST.get3DDataValue()] && !var0.connections[Direction.EAST.get3DDataValue()].claimed;
        }

        @Override
        public OceanMonumentPiece create(Direction var0, RoomDefinition var1, RandomSource var2) {
            var1.claimed = true;
            var1.connections[Direction.EAST.get3DDataValue()].claimed = true;
            return new OceanMonumentDoubleXRoom(var0, var1);
        }
    }

    static class FitDoubleYRoom
    implements MonumentRoomFitter {
        FitDoubleYRoom() {
        }

        @Override
        public boolean fits(RoomDefinition var0) {
            return var0.hasOpening[Direction.UP.get3DDataValue()] && !var0.connections[Direction.UP.get3DDataValue()].claimed;
        }

        @Override
        public OceanMonumentPiece create(Direction var0, RoomDefinition var1, RandomSource var2) {
            var1.claimed = true;
            var1.connections[Direction.UP.get3DDataValue()].claimed = true;
            return new OceanMonumentDoubleYRoom(var0, var1);
        }
    }

    static class FitSimpleTopRoom
    implements MonumentRoomFitter {
        FitSimpleTopRoom() {
        }

        @Override
        public boolean fits(RoomDefinition var0) {
            return !var0.hasOpening[Direction.WEST.get3DDataValue()] && !var0.hasOpening[Direction.EAST.get3DDataValue()] && !var0.hasOpening[Direction.NORTH.get3DDataValue()] && !var0.hasOpening[Direction.SOUTH.get3DDataValue()] && !var0.hasOpening[Direction.UP.get3DDataValue()];
        }

        @Override
        public OceanMonumentPiece create(Direction var0, RoomDefinition var1, RandomSource var2) {
            var1.claimed = true;
            return new OceanMonumentSimpleTopRoom(var0, var1);
        }
    }

    static class FitSimpleRoom
    implements MonumentRoomFitter {
        FitSimpleRoom() {
        }

        @Override
        public boolean fits(RoomDefinition var0) {
            return true;
        }

        @Override
        public OceanMonumentPiece create(Direction var0, RoomDefinition var1, RandomSource var2) {
            var1.claimed = true;
            return new OceanMonumentSimpleRoom(var0, var1, var2);
        }
    }

    static interface MonumentRoomFitter {
        public boolean fits(RoomDefinition var1);

        public OceanMonumentPiece create(Direction var1, RoomDefinition var2, RandomSource var3);
    }

    static class RoomDefinition {
        final int index;
        final RoomDefinition[] connections = new RoomDefinition[6];
        final boolean[] hasOpening = new boolean[6];
        boolean claimed;
        boolean isSource;
        private int scanIndex;

        public RoomDefinition(int var0) {
            this.index = var0;
        }

        public void setConnection(Direction var0, RoomDefinition var1) {
            this.connections[var0.get3DDataValue()] = var1;
            var1.connections[var0.getOpposite().get3DDataValue()] = this;
        }

        public void updateOpenings() {
            for (int var0 = 0; var0 < 6; ++var0) {
                this.hasOpening[var0] = this.connections[var0] != null;
            }
        }

        public boolean findSource(int var0) {
            if (this.isSource) {
                return true;
            }
            this.scanIndex = var0;
            for (int var1 = 0; var1 < 6; ++var1) {
                if (this.connections[var1] == null || !this.hasOpening[var1] || this.connections[var1].scanIndex == var0 || !this.connections[var1].findSource(var0)) continue;
                return true;
            }
            return false;
        }

        public boolean isSpecial() {
            return this.index >= 75;
        }

        public int countOpenings() {
            int var0 = 0;
            for (int var1 = 0; var1 < 6; ++var1) {
                if (!this.hasOpening[var1]) continue;
                ++var0;
            }
            return var0;
        }
    }

    public static class OceanMonumentPenthouse
    extends OceanMonumentPiece {
        public OceanMonumentPenthouse(Direction var0, BoundingBox var1) {
            super(StructurePieceType.OCEAN_MONUMENT_PENTHOUSE, var0, 1, var1);
        }

        public OceanMonumentPenthouse(CompoundTag var0) {
            super(StructurePieceType.OCEAN_MONUMENT_PENTHOUSE, var0);
        }

        @Override
        public void postProcess(WorldGenLevel var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, BoundingBox var4, ChunkPos var5, BlockPos var6) {
            int var7;
            this.generateBox(var0, var4, 2, -1, 2, 11, -1, 11, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 0, -1, 0, 1, -1, 11, BASE_GRAY, BASE_GRAY, false);
            this.generateBox(var0, var4, 12, -1, 0, 13, -1, 11, BASE_GRAY, BASE_GRAY, false);
            this.generateBox(var0, var4, 2, -1, 0, 11, -1, 1, BASE_GRAY, BASE_GRAY, false);
            this.generateBox(var0, var4, 2, -1, 12, 11, -1, 13, BASE_GRAY, BASE_GRAY, false);
            this.generateBox(var0, var4, 0, 0, 0, 0, 0, 13, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 13, 0, 0, 13, 0, 13, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 1, 0, 0, 12, 0, 0, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 1, 0, 13, 12, 0, 13, BASE_LIGHT, BASE_LIGHT, false);
            for (var7 = 2; var7 <= 11; var7 += 3) {
                this.placeBlock(var0, LAMP_BLOCK, 0, 0, var7, var4);
                this.placeBlock(var0, LAMP_BLOCK, 13, 0, var7, var4);
                this.placeBlock(var0, LAMP_BLOCK, var7, 0, 0, var4);
            }
            this.generateBox(var0, var4, 2, 0, 3, 4, 0, 9, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 9, 0, 3, 11, 0, 9, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 4, 0, 9, 9, 0, 11, BASE_LIGHT, BASE_LIGHT, false);
            this.placeBlock(var0, BASE_LIGHT, 5, 0, 8, var4);
            this.placeBlock(var0, BASE_LIGHT, 8, 0, 8, var4);
            this.placeBlock(var0, BASE_LIGHT, 10, 0, 10, var4);
            this.placeBlock(var0, BASE_LIGHT, 3, 0, 10, var4);
            this.generateBox(var0, var4, 3, 0, 3, 3, 0, 7, BASE_BLACK, BASE_BLACK, false);
            this.generateBox(var0, var4, 10, 0, 3, 10, 0, 7, BASE_BLACK, BASE_BLACK, false);
            this.generateBox(var0, var4, 6, 0, 10, 7, 0, 10, BASE_BLACK, BASE_BLACK, false);
            var7 = 3;
            for (int var8 = 0; var8 < 2; ++var8) {
                for (int var9 = 2; var9 <= 8; var9 += 3) {
                    this.generateBox(var0, var4, var7, 0, var9, var7, 2, var9, BASE_LIGHT, BASE_LIGHT, false);
                }
                var7 = 10;
            }
            this.generateBox(var0, var4, 5, 0, 10, 5, 2, 10, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 8, 0, 10, 8, 2, 10, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 6, -1, 7, 7, -1, 8, BASE_BLACK, BASE_BLACK, false);
            this.generateWaterBox(var0, var4, 6, -1, 3, 7, -1, 4);
            this.spawnElder(var0, var4, 6, 1, 6);
        }
    }

    public static class OceanMonumentWingRoom
    extends OceanMonumentPiece {
        private int mainDesign;

        public OceanMonumentWingRoom(Direction var0, BoundingBox var1, int var2) {
            super(StructurePieceType.OCEAN_MONUMENT_WING_ROOM, var0, 1, var1);
            this.mainDesign = var2 & 1;
        }

        public OceanMonumentWingRoom(CompoundTag var0) {
            super(StructurePieceType.OCEAN_MONUMENT_WING_ROOM, var0);
        }

        @Override
        public void postProcess(WorldGenLevel var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, BoundingBox var4, ChunkPos var5, BlockPos var6) {
            if (this.mainDesign == 0) {
                int var7;
                for (var7 = 0; var7 < 4; ++var7) {
                    this.generateBox(var0, var4, 10 - var7, 3 - var7, 20 - var7, 12 + var7, 3 - var7, 20, BASE_LIGHT, BASE_LIGHT, false);
                }
                this.generateBox(var0, var4, 7, 0, 6, 15, 0, 16, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 6, 0, 6, 6, 3, 20, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 16, 0, 6, 16, 3, 20, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 7, 1, 7, 7, 1, 20, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 15, 1, 7, 15, 1, 20, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 7, 1, 6, 9, 3, 6, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 13, 1, 6, 15, 3, 6, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 8, 1, 7, 9, 1, 7, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 13, 1, 7, 14, 1, 7, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 9, 0, 5, 13, 0, 5, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 10, 0, 7, 12, 0, 7, BASE_BLACK, BASE_BLACK, false);
                this.generateBox(var0, var4, 8, 0, 10, 8, 0, 12, BASE_BLACK, BASE_BLACK, false);
                this.generateBox(var0, var4, 14, 0, 10, 14, 0, 12, BASE_BLACK, BASE_BLACK, false);
                for (var7 = 18; var7 >= 7; var7 -= 3) {
                    this.placeBlock(var0, LAMP_BLOCK, 6, 3, var7, var4);
                    this.placeBlock(var0, LAMP_BLOCK, 16, 3, var7, var4);
                }
                this.placeBlock(var0, LAMP_BLOCK, 10, 0, 10, var4);
                this.placeBlock(var0, LAMP_BLOCK, 12, 0, 10, var4);
                this.placeBlock(var0, LAMP_BLOCK, 10, 0, 12, var4);
                this.placeBlock(var0, LAMP_BLOCK, 12, 0, 12, var4);
                this.placeBlock(var0, LAMP_BLOCK, 8, 3, 6, var4);
                this.placeBlock(var0, LAMP_BLOCK, 14, 3, 6, var4);
                this.placeBlock(var0, BASE_LIGHT, 4, 2, 4, var4);
                this.placeBlock(var0, LAMP_BLOCK, 4, 1, 4, var4);
                this.placeBlock(var0, BASE_LIGHT, 4, 0, 4, var4);
                this.placeBlock(var0, BASE_LIGHT, 18, 2, 4, var4);
                this.placeBlock(var0, LAMP_BLOCK, 18, 1, 4, var4);
                this.placeBlock(var0, BASE_LIGHT, 18, 0, 4, var4);
                this.placeBlock(var0, BASE_LIGHT, 4, 2, 18, var4);
                this.placeBlock(var0, LAMP_BLOCK, 4, 1, 18, var4);
                this.placeBlock(var0, BASE_LIGHT, 4, 0, 18, var4);
                this.placeBlock(var0, BASE_LIGHT, 18, 2, 18, var4);
                this.placeBlock(var0, LAMP_BLOCK, 18, 1, 18, var4);
                this.placeBlock(var0, BASE_LIGHT, 18, 0, 18, var4);
                this.placeBlock(var0, BASE_LIGHT, 9, 7, 20, var4);
                this.placeBlock(var0, BASE_LIGHT, 13, 7, 20, var4);
                this.generateBox(var0, var4, 6, 0, 21, 7, 4, 21, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 15, 0, 21, 16, 4, 21, BASE_LIGHT, BASE_LIGHT, false);
                this.spawnElder(var0, var4, 11, 2, 16);
            } else if (this.mainDesign == 1) {
                int var10;
                this.generateBox(var0, var4, 9, 3, 18, 13, 3, 20, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 9, 0, 18, 9, 2, 18, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 13, 0, 18, 13, 2, 18, BASE_LIGHT, BASE_LIGHT, false);
                int var7 = 9;
                int var8 = 20;
                int var9 = 5;
                for (var10 = 0; var10 < 2; ++var10) {
                    this.placeBlock(var0, BASE_LIGHT, var7, 6, 20, var4);
                    this.placeBlock(var0, LAMP_BLOCK, var7, 5, 20, var4);
                    this.placeBlock(var0, BASE_LIGHT, var7, 4, 20, var4);
                    var7 = 13;
                }
                this.generateBox(var0, var4, 7, 3, 7, 15, 3, 14, BASE_LIGHT, BASE_LIGHT, false);
                var7 = 10;
                for (var10 = 0; var10 < 2; ++var10) {
                    this.generateBox(var0, var4, var7, 0, 10, var7, 6, 10, BASE_LIGHT, BASE_LIGHT, false);
                    this.generateBox(var0, var4, var7, 0, 12, var7, 6, 12, BASE_LIGHT, BASE_LIGHT, false);
                    this.placeBlock(var0, LAMP_BLOCK, var7, 0, 10, var4);
                    this.placeBlock(var0, LAMP_BLOCK, var7, 0, 12, var4);
                    this.placeBlock(var0, LAMP_BLOCK, var7, 4, 10, var4);
                    this.placeBlock(var0, LAMP_BLOCK, var7, 4, 12, var4);
                    var7 = 12;
                }
                var7 = 8;
                for (var10 = 0; var10 < 2; ++var10) {
                    this.generateBox(var0, var4, var7, 0, 7, var7, 2, 7, BASE_LIGHT, BASE_LIGHT, false);
                    this.generateBox(var0, var4, var7, 0, 14, var7, 2, 14, BASE_LIGHT, BASE_LIGHT, false);
                    var7 = 14;
                }
                this.generateBox(var0, var4, 8, 3, 8, 8, 3, 13, BASE_BLACK, BASE_BLACK, false);
                this.generateBox(var0, var4, 14, 3, 8, 14, 3, 13, BASE_BLACK, BASE_BLACK, false);
                this.spawnElder(var0, var4, 11, 5, 13);
            }
        }
    }

    public static class OceanMonumentCoreRoom
    extends OceanMonumentPiece {
        public OceanMonumentCoreRoom(Direction var0, RoomDefinition var1) {
            super(StructurePieceType.OCEAN_MONUMENT_CORE_ROOM, 1, var0, var1, 2, 2, 2);
        }

        public OceanMonumentCoreRoom(CompoundTag var0) {
            super(StructurePieceType.OCEAN_MONUMENT_CORE_ROOM, var0);
        }

        @Override
        public void postProcess(WorldGenLevel var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, BoundingBox var4, ChunkPos var5, BlockPos var6) {
            this.generateBoxOnFillOnly(var0, var4, 1, 8, 0, 14, 8, 14, BASE_GRAY);
            int var7 = 7;
            BlockState var8 = BASE_LIGHT;
            this.generateBox(var0, var4, 0, 7, 0, 0, 7, 15, var8, var8, false);
            this.generateBox(var0, var4, 15, 7, 0, 15, 7, 15, var8, var8, false);
            this.generateBox(var0, var4, 1, 7, 0, 15, 7, 0, var8, var8, false);
            this.generateBox(var0, var4, 1, 7, 15, 14, 7, 15, var8, var8, false);
            for (var7 = 1; var7 <= 6; ++var7) {
                var8 = BASE_LIGHT;
                if (var7 == 2 || var7 == 6) {
                    var8 = BASE_GRAY;
                }
                for (int var9 = 0; var9 <= 15; var9 += 15) {
                    this.generateBox(var0, var4, var9, var7, 0, var9, var7, 1, var8, var8, false);
                    this.generateBox(var0, var4, var9, var7, 6, var9, var7, 9, var8, var8, false);
                    this.generateBox(var0, var4, var9, var7, 14, var9, var7, 15, var8, var8, false);
                }
                this.generateBox(var0, var4, 1, var7, 0, 1, var7, 0, var8, var8, false);
                this.generateBox(var0, var4, 6, var7, 0, 9, var7, 0, var8, var8, false);
                this.generateBox(var0, var4, 14, var7, 0, 14, var7, 0, var8, var8, false);
                this.generateBox(var0, var4, 1, var7, 15, 14, var7, 15, var8, var8, false);
            }
            this.generateBox(var0, var4, 6, 3, 6, 9, 6, 9, BASE_BLACK, BASE_BLACK, false);
            this.generateBox(var0, var4, 7, 4, 7, 8, 5, 8, Blocks.GOLD_BLOCK.defaultBlockState(), Blocks.GOLD_BLOCK.defaultBlockState(), false);
            for (var7 = 3; var7 <= 6; var7 += 3) {
                for (int var82 = 6; var82 <= 9; var82 += 3) {
                    this.placeBlock(var0, LAMP_BLOCK, var82, var7, 6, var4);
                    this.placeBlock(var0, LAMP_BLOCK, var82, var7, 9, var4);
                }
            }
            this.generateBox(var0, var4, 5, 1, 6, 5, 2, 6, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 5, 1, 9, 5, 2, 9, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 10, 1, 6, 10, 2, 6, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 10, 1, 9, 10, 2, 9, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 6, 1, 5, 6, 2, 5, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 9, 1, 5, 9, 2, 5, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 6, 1, 10, 6, 2, 10, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 9, 1, 10, 9, 2, 10, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 5, 2, 5, 5, 6, 5, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 5, 2, 10, 5, 6, 10, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 10, 2, 5, 10, 6, 5, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 10, 2, 10, 10, 6, 10, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 5, 7, 1, 5, 7, 6, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 10, 7, 1, 10, 7, 6, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 5, 7, 9, 5, 7, 14, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 10, 7, 9, 10, 7, 14, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 1, 7, 5, 6, 7, 5, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 1, 7, 10, 6, 7, 10, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 9, 7, 5, 14, 7, 5, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 9, 7, 10, 14, 7, 10, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 2, 1, 2, 2, 1, 3, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 3, 1, 2, 3, 1, 2, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 13, 1, 2, 13, 1, 3, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 12, 1, 2, 12, 1, 2, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 2, 1, 12, 2, 1, 13, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 3, 1, 13, 3, 1, 13, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 13, 1, 12, 13, 1, 13, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 12, 1, 13, 12, 1, 13, BASE_LIGHT, BASE_LIGHT, false);
        }
    }

    public static class OceanMonumentDoubleYZRoom
    extends OceanMonumentPiece {
        public OceanMonumentDoubleYZRoom(Direction var0, RoomDefinition var1) {
            super(StructurePieceType.OCEAN_MONUMENT_DOUBLE_YZ_ROOM, 1, var0, var1, 1, 2, 2);
        }

        public OceanMonumentDoubleYZRoom(CompoundTag var0) {
            super(StructurePieceType.OCEAN_MONUMENT_DOUBLE_YZ_ROOM, var0);
        }

        @Override
        public void postProcess(WorldGenLevel var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, BoundingBox var4, ChunkPos var5, BlockPos var6) {
            BlockState var12;
            int var11;
            RoomDefinition var7 = this.roomDefinition.connections[Direction.NORTH.get3DDataValue()];
            RoomDefinition var8 = this.roomDefinition;
            RoomDefinition var9 = var7.connections[Direction.UP.get3DDataValue()];
            RoomDefinition var10 = var8.connections[Direction.UP.get3DDataValue()];
            if (this.roomDefinition.index / 25 > 0) {
                this.generateDefaultFloor(var0, var4, 0, 8, var7.hasOpening[Direction.DOWN.get3DDataValue()]);
                this.generateDefaultFloor(var0, var4, 0, 0, var8.hasOpening[Direction.DOWN.get3DDataValue()]);
            }
            if (var10.connections[Direction.UP.get3DDataValue()] == null) {
                this.generateBoxOnFillOnly(var0, var4, 1, 8, 1, 6, 8, 7, BASE_GRAY);
            }
            if (var9.connections[Direction.UP.get3DDataValue()] == null) {
                this.generateBoxOnFillOnly(var0, var4, 1, 8, 8, 6, 8, 14, BASE_GRAY);
            }
            for (var11 = 1; var11 <= 7; ++var11) {
                var12 = BASE_LIGHT;
                if (var11 == 2 || var11 == 6) {
                    var12 = BASE_GRAY;
                }
                this.generateBox(var0, var4, 0, var11, 0, 0, var11, 15, var12, var12, false);
                this.generateBox(var0, var4, 7, var11, 0, 7, var11, 15, var12, var12, false);
                this.generateBox(var0, var4, 1, var11, 0, 6, var11, 0, var12, var12, false);
                this.generateBox(var0, var4, 1, var11, 15, 6, var11, 15, var12, var12, false);
            }
            for (var11 = 1; var11 <= 7; ++var11) {
                var12 = BASE_BLACK;
                if (var11 == 2 || var11 == 6) {
                    var12 = LAMP_BLOCK;
                }
                this.generateBox(var0, var4, 3, var11, 7, 4, var11, 8, var12, var12, false);
            }
            if (var8.hasOpening[Direction.SOUTH.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 3, 1, 0, 4, 2, 0);
            }
            if (var8.hasOpening[Direction.EAST.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 7, 1, 3, 7, 2, 4);
            }
            if (var8.hasOpening[Direction.WEST.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 0, 1, 3, 0, 2, 4);
            }
            if (var7.hasOpening[Direction.NORTH.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 3, 1, 15, 4, 2, 15);
            }
            if (var7.hasOpening[Direction.WEST.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 0, 1, 11, 0, 2, 12);
            }
            if (var7.hasOpening[Direction.EAST.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 7, 1, 11, 7, 2, 12);
            }
            if (var10.hasOpening[Direction.SOUTH.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 3, 5, 0, 4, 6, 0);
            }
            if (var10.hasOpening[Direction.EAST.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 7, 5, 3, 7, 6, 4);
                this.generateBox(var0, var4, 5, 4, 2, 6, 4, 5, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 6, 1, 2, 6, 3, 2, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 6, 1, 5, 6, 3, 5, BASE_LIGHT, BASE_LIGHT, false);
            }
            if (var10.hasOpening[Direction.WEST.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 0, 5, 3, 0, 6, 4);
                this.generateBox(var0, var4, 1, 4, 2, 2, 4, 5, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 1, 1, 2, 1, 3, 2, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 1, 1, 5, 1, 3, 5, BASE_LIGHT, BASE_LIGHT, false);
            }
            if (var9.hasOpening[Direction.NORTH.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 3, 5, 15, 4, 6, 15);
            }
            if (var9.hasOpening[Direction.WEST.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 0, 5, 11, 0, 6, 12);
                this.generateBox(var0, var4, 1, 4, 10, 2, 4, 13, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 1, 1, 10, 1, 3, 10, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 1, 1, 13, 1, 3, 13, BASE_LIGHT, BASE_LIGHT, false);
            }
            if (var9.hasOpening[Direction.EAST.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 7, 5, 11, 7, 6, 12);
                this.generateBox(var0, var4, 5, 4, 10, 6, 4, 13, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 6, 1, 10, 6, 3, 10, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 6, 1, 13, 6, 3, 13, BASE_LIGHT, BASE_LIGHT, false);
            }
        }
    }

    public static class OceanMonumentDoubleXYRoom
    extends OceanMonumentPiece {
        public OceanMonumentDoubleXYRoom(Direction var0, RoomDefinition var1) {
            super(StructurePieceType.OCEAN_MONUMENT_DOUBLE_XY_ROOM, 1, var0, var1, 2, 2, 1);
        }

        public OceanMonumentDoubleXYRoom(CompoundTag var0) {
            super(StructurePieceType.OCEAN_MONUMENT_DOUBLE_XY_ROOM, var0);
        }

        @Override
        public void postProcess(WorldGenLevel var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, BoundingBox var4, ChunkPos var5, BlockPos var6) {
            RoomDefinition var7 = this.roomDefinition.connections[Direction.EAST.get3DDataValue()];
            RoomDefinition var8 = this.roomDefinition;
            RoomDefinition var9 = var8.connections[Direction.UP.get3DDataValue()];
            RoomDefinition var10 = var7.connections[Direction.UP.get3DDataValue()];
            if (this.roomDefinition.index / 25 > 0) {
                this.generateDefaultFloor(var0, var4, 8, 0, var7.hasOpening[Direction.DOWN.get3DDataValue()]);
                this.generateDefaultFloor(var0, var4, 0, 0, var8.hasOpening[Direction.DOWN.get3DDataValue()]);
            }
            if (var9.connections[Direction.UP.get3DDataValue()] == null) {
                this.generateBoxOnFillOnly(var0, var4, 1, 8, 1, 7, 8, 6, BASE_GRAY);
            }
            if (var10.connections[Direction.UP.get3DDataValue()] == null) {
                this.generateBoxOnFillOnly(var0, var4, 8, 8, 1, 14, 8, 6, BASE_GRAY);
            }
            for (int var11 = 1; var11 <= 7; ++var11) {
                BlockState var12 = BASE_LIGHT;
                if (var11 == 2 || var11 == 6) {
                    var12 = BASE_GRAY;
                }
                this.generateBox(var0, var4, 0, var11, 0, 0, var11, 7, var12, var12, false);
                this.generateBox(var0, var4, 15, var11, 0, 15, var11, 7, var12, var12, false);
                this.generateBox(var0, var4, 1, var11, 0, 15, var11, 0, var12, var12, false);
                this.generateBox(var0, var4, 1, var11, 7, 14, var11, 7, var12, var12, false);
            }
            this.generateBox(var0, var4, 2, 1, 3, 2, 7, 4, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 3, 1, 2, 4, 7, 2, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 3, 1, 5, 4, 7, 5, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 13, 1, 3, 13, 7, 4, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 11, 1, 2, 12, 7, 2, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 11, 1, 5, 12, 7, 5, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 5, 1, 3, 5, 3, 4, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 10, 1, 3, 10, 3, 4, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 5, 7, 2, 10, 7, 5, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 5, 5, 2, 5, 7, 2, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 10, 5, 2, 10, 7, 2, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 5, 5, 5, 5, 7, 5, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 10, 5, 5, 10, 7, 5, BASE_LIGHT, BASE_LIGHT, false);
            this.placeBlock(var0, BASE_LIGHT, 6, 6, 2, var4);
            this.placeBlock(var0, BASE_LIGHT, 9, 6, 2, var4);
            this.placeBlock(var0, BASE_LIGHT, 6, 6, 5, var4);
            this.placeBlock(var0, BASE_LIGHT, 9, 6, 5, var4);
            this.generateBox(var0, var4, 5, 4, 3, 6, 4, 4, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 9, 4, 3, 10, 4, 4, BASE_LIGHT, BASE_LIGHT, false);
            this.placeBlock(var0, LAMP_BLOCK, 5, 4, 2, var4);
            this.placeBlock(var0, LAMP_BLOCK, 5, 4, 5, var4);
            this.placeBlock(var0, LAMP_BLOCK, 10, 4, 2, var4);
            this.placeBlock(var0, LAMP_BLOCK, 10, 4, 5, var4);
            if (var8.hasOpening[Direction.SOUTH.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 3, 1, 0, 4, 2, 0);
            }
            if (var8.hasOpening[Direction.NORTH.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 3, 1, 7, 4, 2, 7);
            }
            if (var8.hasOpening[Direction.WEST.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 0, 1, 3, 0, 2, 4);
            }
            if (var7.hasOpening[Direction.SOUTH.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 11, 1, 0, 12, 2, 0);
            }
            if (var7.hasOpening[Direction.NORTH.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 11, 1, 7, 12, 2, 7);
            }
            if (var7.hasOpening[Direction.EAST.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 15, 1, 3, 15, 2, 4);
            }
            if (var9.hasOpening[Direction.SOUTH.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 3, 5, 0, 4, 6, 0);
            }
            if (var9.hasOpening[Direction.NORTH.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 3, 5, 7, 4, 6, 7);
            }
            if (var9.hasOpening[Direction.WEST.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 0, 5, 3, 0, 6, 4);
            }
            if (var10.hasOpening[Direction.SOUTH.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 11, 5, 0, 12, 6, 0);
            }
            if (var10.hasOpening[Direction.NORTH.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 11, 5, 7, 12, 6, 7);
            }
            if (var10.hasOpening[Direction.EAST.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 15, 5, 3, 15, 6, 4);
            }
        }
    }

    public static class OceanMonumentDoubleZRoom
    extends OceanMonumentPiece {
        public OceanMonumentDoubleZRoom(Direction var0, RoomDefinition var1) {
            super(StructurePieceType.OCEAN_MONUMENT_DOUBLE_Z_ROOM, 1, var0, var1, 1, 1, 2);
        }

        public OceanMonumentDoubleZRoom(CompoundTag var0) {
            super(StructurePieceType.OCEAN_MONUMENT_DOUBLE_Z_ROOM, var0);
        }

        @Override
        public void postProcess(WorldGenLevel var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, BoundingBox var4, ChunkPos var5, BlockPos var6) {
            RoomDefinition var7 = this.roomDefinition.connections[Direction.NORTH.get3DDataValue()];
            RoomDefinition var8 = this.roomDefinition;
            if (this.roomDefinition.index / 25 > 0) {
                this.generateDefaultFloor(var0, var4, 0, 8, var7.hasOpening[Direction.DOWN.get3DDataValue()]);
                this.generateDefaultFloor(var0, var4, 0, 0, var8.hasOpening[Direction.DOWN.get3DDataValue()]);
            }
            if (var8.connections[Direction.UP.get3DDataValue()] == null) {
                this.generateBoxOnFillOnly(var0, var4, 1, 4, 1, 6, 4, 7, BASE_GRAY);
            }
            if (var7.connections[Direction.UP.get3DDataValue()] == null) {
                this.generateBoxOnFillOnly(var0, var4, 1, 4, 8, 6, 4, 14, BASE_GRAY);
            }
            this.generateBox(var0, var4, 0, 3, 0, 0, 3, 15, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 7, 3, 0, 7, 3, 15, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 1, 3, 0, 7, 3, 0, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 1, 3, 15, 6, 3, 15, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 0, 2, 0, 0, 2, 15, BASE_GRAY, BASE_GRAY, false);
            this.generateBox(var0, var4, 7, 2, 0, 7, 2, 15, BASE_GRAY, BASE_GRAY, false);
            this.generateBox(var0, var4, 1, 2, 0, 7, 2, 0, BASE_GRAY, BASE_GRAY, false);
            this.generateBox(var0, var4, 1, 2, 15, 6, 2, 15, BASE_GRAY, BASE_GRAY, false);
            this.generateBox(var0, var4, 0, 1, 0, 0, 1, 15, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 7, 1, 0, 7, 1, 15, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 1, 1, 0, 7, 1, 0, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 1, 1, 15, 6, 1, 15, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 1, 1, 1, 1, 1, 2, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 6, 1, 1, 6, 1, 2, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 1, 3, 1, 1, 3, 2, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 6, 3, 1, 6, 3, 2, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 1, 1, 13, 1, 1, 14, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 6, 1, 13, 6, 1, 14, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 1, 3, 13, 1, 3, 14, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 6, 3, 13, 6, 3, 14, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 2, 1, 6, 2, 3, 6, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 5, 1, 6, 5, 3, 6, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 2, 1, 9, 2, 3, 9, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 5, 1, 9, 5, 3, 9, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 3, 2, 6, 4, 2, 6, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 3, 2, 9, 4, 2, 9, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 2, 2, 7, 2, 2, 8, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 5, 2, 7, 5, 2, 8, BASE_LIGHT, BASE_LIGHT, false);
            this.placeBlock(var0, LAMP_BLOCK, 2, 2, 5, var4);
            this.placeBlock(var0, LAMP_BLOCK, 5, 2, 5, var4);
            this.placeBlock(var0, LAMP_BLOCK, 2, 2, 10, var4);
            this.placeBlock(var0, LAMP_BLOCK, 5, 2, 10, var4);
            this.placeBlock(var0, BASE_LIGHT, 2, 3, 5, var4);
            this.placeBlock(var0, BASE_LIGHT, 5, 3, 5, var4);
            this.placeBlock(var0, BASE_LIGHT, 2, 3, 10, var4);
            this.placeBlock(var0, BASE_LIGHT, 5, 3, 10, var4);
            if (var8.hasOpening[Direction.SOUTH.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 3, 1, 0, 4, 2, 0);
            }
            if (var8.hasOpening[Direction.EAST.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 7, 1, 3, 7, 2, 4);
            }
            if (var8.hasOpening[Direction.WEST.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 0, 1, 3, 0, 2, 4);
            }
            if (var7.hasOpening[Direction.NORTH.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 3, 1, 15, 4, 2, 15);
            }
            if (var7.hasOpening[Direction.WEST.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 0, 1, 11, 0, 2, 12);
            }
            if (var7.hasOpening[Direction.EAST.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 7, 1, 11, 7, 2, 12);
            }
        }
    }

    public static class OceanMonumentDoubleXRoom
    extends OceanMonumentPiece {
        public OceanMonumentDoubleXRoom(Direction var0, RoomDefinition var1) {
            super(StructurePieceType.OCEAN_MONUMENT_DOUBLE_X_ROOM, 1, var0, var1, 2, 1, 1);
        }

        public OceanMonumentDoubleXRoom(CompoundTag var0) {
            super(StructurePieceType.OCEAN_MONUMENT_DOUBLE_X_ROOM, var0);
        }

        @Override
        public void postProcess(WorldGenLevel var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, BoundingBox var4, ChunkPos var5, BlockPos var6) {
            RoomDefinition var7 = this.roomDefinition.connections[Direction.EAST.get3DDataValue()];
            RoomDefinition var8 = this.roomDefinition;
            if (this.roomDefinition.index / 25 > 0) {
                this.generateDefaultFloor(var0, var4, 8, 0, var7.hasOpening[Direction.DOWN.get3DDataValue()]);
                this.generateDefaultFloor(var0, var4, 0, 0, var8.hasOpening[Direction.DOWN.get3DDataValue()]);
            }
            if (var8.connections[Direction.UP.get3DDataValue()] == null) {
                this.generateBoxOnFillOnly(var0, var4, 1, 4, 1, 7, 4, 6, BASE_GRAY);
            }
            if (var7.connections[Direction.UP.get3DDataValue()] == null) {
                this.generateBoxOnFillOnly(var0, var4, 8, 4, 1, 14, 4, 6, BASE_GRAY);
            }
            this.generateBox(var0, var4, 0, 3, 0, 0, 3, 7, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 15, 3, 0, 15, 3, 7, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 1, 3, 0, 15, 3, 0, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 1, 3, 7, 14, 3, 7, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 0, 2, 0, 0, 2, 7, BASE_GRAY, BASE_GRAY, false);
            this.generateBox(var0, var4, 15, 2, 0, 15, 2, 7, BASE_GRAY, BASE_GRAY, false);
            this.generateBox(var0, var4, 1, 2, 0, 15, 2, 0, BASE_GRAY, BASE_GRAY, false);
            this.generateBox(var0, var4, 1, 2, 7, 14, 2, 7, BASE_GRAY, BASE_GRAY, false);
            this.generateBox(var0, var4, 0, 1, 0, 0, 1, 7, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 15, 1, 0, 15, 1, 7, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 1, 1, 0, 15, 1, 0, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 1, 1, 7, 14, 1, 7, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 5, 1, 0, 10, 1, 4, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 6, 2, 0, 9, 2, 3, BASE_GRAY, BASE_GRAY, false);
            this.generateBox(var0, var4, 5, 3, 0, 10, 3, 4, BASE_LIGHT, BASE_LIGHT, false);
            this.placeBlock(var0, LAMP_BLOCK, 6, 2, 3, var4);
            this.placeBlock(var0, LAMP_BLOCK, 9, 2, 3, var4);
            if (var8.hasOpening[Direction.SOUTH.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 3, 1, 0, 4, 2, 0);
            }
            if (var8.hasOpening[Direction.NORTH.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 3, 1, 7, 4, 2, 7);
            }
            if (var8.hasOpening[Direction.WEST.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 0, 1, 3, 0, 2, 4);
            }
            if (var7.hasOpening[Direction.SOUTH.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 11, 1, 0, 12, 2, 0);
            }
            if (var7.hasOpening[Direction.NORTH.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 11, 1, 7, 12, 2, 7);
            }
            if (var7.hasOpening[Direction.EAST.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 15, 1, 3, 15, 2, 4);
            }
        }
    }

    public static class OceanMonumentDoubleYRoom
    extends OceanMonumentPiece {
        public OceanMonumentDoubleYRoom(Direction var0, RoomDefinition var1) {
            super(StructurePieceType.OCEAN_MONUMENT_DOUBLE_Y_ROOM, 1, var0, var1, 1, 2, 1);
        }

        public OceanMonumentDoubleYRoom(CompoundTag var0) {
            super(StructurePieceType.OCEAN_MONUMENT_DOUBLE_Y_ROOM, var0);
        }

        @Override
        public void postProcess(WorldGenLevel var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, BoundingBox var4, ChunkPos var5, BlockPos var6) {
            if (this.roomDefinition.index / 25 > 0) {
                this.generateDefaultFloor(var0, var4, 0, 0, this.roomDefinition.hasOpening[Direction.DOWN.get3DDataValue()]);
            }
            RoomDefinition var7 = this.roomDefinition.connections[Direction.UP.get3DDataValue()];
            if (var7.connections[Direction.UP.get3DDataValue()] == null) {
                this.generateBoxOnFillOnly(var0, var4, 1, 8, 1, 6, 8, 6, BASE_GRAY);
            }
            this.generateBox(var0, var4, 0, 4, 0, 0, 4, 7, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 7, 4, 0, 7, 4, 7, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 1, 4, 0, 6, 4, 0, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 1, 4, 7, 6, 4, 7, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 2, 4, 1, 2, 4, 2, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 1, 4, 2, 1, 4, 2, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 5, 4, 1, 5, 4, 2, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 6, 4, 2, 6, 4, 2, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 2, 4, 5, 2, 4, 6, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 1, 4, 5, 1, 4, 5, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 5, 4, 5, 5, 4, 6, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 6, 4, 5, 6, 4, 5, BASE_LIGHT, BASE_LIGHT, false);
            RoomDefinition var8 = this.roomDefinition;
            for (int var9 = 1; var9 <= 5; var9 += 4) {
                int var10 = 0;
                if (var8.hasOpening[Direction.SOUTH.get3DDataValue()]) {
                    this.generateBox(var0, var4, 2, var9, var10, 2, var9 + 2, var10, BASE_LIGHT, BASE_LIGHT, false);
                    this.generateBox(var0, var4, 5, var9, var10, 5, var9 + 2, var10, BASE_LIGHT, BASE_LIGHT, false);
                    this.generateBox(var0, var4, 3, var9 + 2, var10, 4, var9 + 2, var10, BASE_LIGHT, BASE_LIGHT, false);
                } else {
                    this.generateBox(var0, var4, 0, var9, var10, 7, var9 + 2, var10, BASE_LIGHT, BASE_LIGHT, false);
                    this.generateBox(var0, var4, 0, var9 + 1, var10, 7, var9 + 1, var10, BASE_GRAY, BASE_GRAY, false);
                }
                var10 = 7;
                if (var8.hasOpening[Direction.NORTH.get3DDataValue()]) {
                    this.generateBox(var0, var4, 2, var9, var10, 2, var9 + 2, var10, BASE_LIGHT, BASE_LIGHT, false);
                    this.generateBox(var0, var4, 5, var9, var10, 5, var9 + 2, var10, BASE_LIGHT, BASE_LIGHT, false);
                    this.generateBox(var0, var4, 3, var9 + 2, var10, 4, var9 + 2, var10, BASE_LIGHT, BASE_LIGHT, false);
                } else {
                    this.generateBox(var0, var4, 0, var9, var10, 7, var9 + 2, var10, BASE_LIGHT, BASE_LIGHT, false);
                    this.generateBox(var0, var4, 0, var9 + 1, var10, 7, var9 + 1, var10, BASE_GRAY, BASE_GRAY, false);
                }
                int var11 = 0;
                if (var8.hasOpening[Direction.WEST.get3DDataValue()]) {
                    this.generateBox(var0, var4, var11, var9, 2, var11, var9 + 2, 2, BASE_LIGHT, BASE_LIGHT, false);
                    this.generateBox(var0, var4, var11, var9, 5, var11, var9 + 2, 5, BASE_LIGHT, BASE_LIGHT, false);
                    this.generateBox(var0, var4, var11, var9 + 2, 3, var11, var9 + 2, 4, BASE_LIGHT, BASE_LIGHT, false);
                } else {
                    this.generateBox(var0, var4, var11, var9, 0, var11, var9 + 2, 7, BASE_LIGHT, BASE_LIGHT, false);
                    this.generateBox(var0, var4, var11, var9 + 1, 0, var11, var9 + 1, 7, BASE_GRAY, BASE_GRAY, false);
                }
                var11 = 7;
                if (var8.hasOpening[Direction.EAST.get3DDataValue()]) {
                    this.generateBox(var0, var4, var11, var9, 2, var11, var9 + 2, 2, BASE_LIGHT, BASE_LIGHT, false);
                    this.generateBox(var0, var4, var11, var9, 5, var11, var9 + 2, 5, BASE_LIGHT, BASE_LIGHT, false);
                    this.generateBox(var0, var4, var11, var9 + 2, 3, var11, var9 + 2, 4, BASE_LIGHT, BASE_LIGHT, false);
                } else {
                    this.generateBox(var0, var4, var11, var9, 0, var11, var9 + 2, 7, BASE_LIGHT, BASE_LIGHT, false);
                    this.generateBox(var0, var4, var11, var9 + 1, 0, var11, var9 + 1, 7, BASE_GRAY, BASE_GRAY, false);
                }
                var8 = var7;
            }
        }
    }

    public static class OceanMonumentSimpleTopRoom
    extends OceanMonumentPiece {
        public OceanMonumentSimpleTopRoom(Direction var0, RoomDefinition var1) {
            super(StructurePieceType.OCEAN_MONUMENT_SIMPLE_TOP_ROOM, 1, var0, var1, 1, 1, 1);
        }

        public OceanMonumentSimpleTopRoom(CompoundTag var0) {
            super(StructurePieceType.OCEAN_MONUMENT_SIMPLE_TOP_ROOM, var0);
        }

        @Override
        public void postProcess(WorldGenLevel var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, BoundingBox var4, ChunkPos var5, BlockPos var6) {
            if (this.roomDefinition.index / 25 > 0) {
                this.generateDefaultFloor(var0, var4, 0, 0, this.roomDefinition.hasOpening[Direction.DOWN.get3DDataValue()]);
            }
            if (this.roomDefinition.connections[Direction.UP.get3DDataValue()] == null) {
                this.generateBoxOnFillOnly(var0, var4, 1, 4, 1, 6, 4, 6, BASE_GRAY);
            }
            for (int var7 = 1; var7 <= 6; ++var7) {
                for (int var8 = 1; var8 <= 6; ++var8) {
                    if (var3.nextInt(3) == 0) continue;
                    int var9 = 2 + (var3.nextInt(4) == 0 ? 0 : 1);
                    BlockState var10 = Blocks.WET_SPONGE.defaultBlockState();
                    this.generateBox(var0, var4, var7, var9, var8, var7, 3, var8, var10, var10, false);
                }
            }
            this.generateBox(var0, var4, 0, 1, 0, 0, 1, 7, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 7, 1, 0, 7, 1, 7, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 1, 1, 0, 6, 1, 0, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 1, 1, 7, 6, 1, 7, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 0, 2, 0, 0, 2, 7, BASE_BLACK, BASE_BLACK, false);
            this.generateBox(var0, var4, 7, 2, 0, 7, 2, 7, BASE_BLACK, BASE_BLACK, false);
            this.generateBox(var0, var4, 1, 2, 0, 6, 2, 0, BASE_BLACK, BASE_BLACK, false);
            this.generateBox(var0, var4, 1, 2, 7, 6, 2, 7, BASE_BLACK, BASE_BLACK, false);
            this.generateBox(var0, var4, 0, 3, 0, 0, 3, 7, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 7, 3, 0, 7, 3, 7, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 1, 3, 0, 6, 3, 0, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 1, 3, 7, 6, 3, 7, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 0, 1, 3, 0, 2, 4, BASE_BLACK, BASE_BLACK, false);
            this.generateBox(var0, var4, 7, 1, 3, 7, 2, 4, BASE_BLACK, BASE_BLACK, false);
            this.generateBox(var0, var4, 3, 1, 0, 4, 2, 0, BASE_BLACK, BASE_BLACK, false);
            this.generateBox(var0, var4, 3, 1, 7, 4, 2, 7, BASE_BLACK, BASE_BLACK, false);
            if (this.roomDefinition.hasOpening[Direction.SOUTH.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 3, 1, 0, 4, 2, 0);
            }
        }
    }

    public static class OceanMonumentSimpleRoom
    extends OceanMonumentPiece {
        private int mainDesign;

        public OceanMonumentSimpleRoom(Direction var0, RoomDefinition var1, RandomSource var2) {
            super(StructurePieceType.OCEAN_MONUMENT_SIMPLE_ROOM, 1, var0, var1, 1, 1, 1);
            this.mainDesign = var2.nextInt(3);
        }

        public OceanMonumentSimpleRoom(CompoundTag var0) {
            super(StructurePieceType.OCEAN_MONUMENT_SIMPLE_ROOM, var0);
        }

        @Override
        public void postProcess(WorldGenLevel var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, BoundingBox var4, ChunkPos var5, BlockPos var6) {
            boolean var7;
            if (this.roomDefinition.index / 25 > 0) {
                this.generateDefaultFloor(var0, var4, 0, 0, this.roomDefinition.hasOpening[Direction.DOWN.get3DDataValue()]);
            }
            if (this.roomDefinition.connections[Direction.UP.get3DDataValue()] == null) {
                this.generateBoxOnFillOnly(var0, var4, 1, 4, 1, 6, 4, 6, BASE_GRAY);
            }
            boolean bl = var7 = this.mainDesign != 0 && var3.nextBoolean() && !this.roomDefinition.hasOpening[Direction.DOWN.get3DDataValue()] && !this.roomDefinition.hasOpening[Direction.UP.get3DDataValue()] && this.roomDefinition.countOpenings() > 1;
            if (this.mainDesign == 0) {
                this.generateBox(var0, var4, 0, 1, 0, 2, 1, 2, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 0, 3, 0, 2, 3, 2, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 0, 2, 0, 0, 2, 2, BASE_GRAY, BASE_GRAY, false);
                this.generateBox(var0, var4, 1, 2, 0, 2, 2, 0, BASE_GRAY, BASE_GRAY, false);
                this.placeBlock(var0, LAMP_BLOCK, 1, 2, 1, var4);
                this.generateBox(var0, var4, 5, 1, 0, 7, 1, 2, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 5, 3, 0, 7, 3, 2, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 7, 2, 0, 7, 2, 2, BASE_GRAY, BASE_GRAY, false);
                this.generateBox(var0, var4, 5, 2, 0, 6, 2, 0, BASE_GRAY, BASE_GRAY, false);
                this.placeBlock(var0, LAMP_BLOCK, 6, 2, 1, var4);
                this.generateBox(var0, var4, 0, 1, 5, 2, 1, 7, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 0, 3, 5, 2, 3, 7, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 0, 2, 5, 0, 2, 7, BASE_GRAY, BASE_GRAY, false);
                this.generateBox(var0, var4, 1, 2, 7, 2, 2, 7, BASE_GRAY, BASE_GRAY, false);
                this.placeBlock(var0, LAMP_BLOCK, 1, 2, 6, var4);
                this.generateBox(var0, var4, 5, 1, 5, 7, 1, 7, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 5, 3, 5, 7, 3, 7, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 7, 2, 5, 7, 2, 7, BASE_GRAY, BASE_GRAY, false);
                this.generateBox(var0, var4, 5, 2, 7, 6, 2, 7, BASE_GRAY, BASE_GRAY, false);
                this.placeBlock(var0, LAMP_BLOCK, 6, 2, 6, var4);
                if (this.roomDefinition.hasOpening[Direction.SOUTH.get3DDataValue()]) {
                    this.generateBox(var0, var4, 3, 3, 0, 4, 3, 0, BASE_LIGHT, BASE_LIGHT, false);
                } else {
                    this.generateBox(var0, var4, 3, 3, 0, 4, 3, 1, BASE_LIGHT, BASE_LIGHT, false);
                    this.generateBox(var0, var4, 3, 2, 0, 4, 2, 0, BASE_GRAY, BASE_GRAY, false);
                    this.generateBox(var0, var4, 3, 1, 0, 4, 1, 1, BASE_LIGHT, BASE_LIGHT, false);
                }
                if (this.roomDefinition.hasOpening[Direction.NORTH.get3DDataValue()]) {
                    this.generateBox(var0, var4, 3, 3, 7, 4, 3, 7, BASE_LIGHT, BASE_LIGHT, false);
                } else {
                    this.generateBox(var0, var4, 3, 3, 6, 4, 3, 7, BASE_LIGHT, BASE_LIGHT, false);
                    this.generateBox(var0, var4, 3, 2, 7, 4, 2, 7, BASE_GRAY, BASE_GRAY, false);
                    this.generateBox(var0, var4, 3, 1, 6, 4, 1, 7, BASE_LIGHT, BASE_LIGHT, false);
                }
                if (this.roomDefinition.hasOpening[Direction.WEST.get3DDataValue()]) {
                    this.generateBox(var0, var4, 0, 3, 3, 0, 3, 4, BASE_LIGHT, BASE_LIGHT, false);
                } else {
                    this.generateBox(var0, var4, 0, 3, 3, 1, 3, 4, BASE_LIGHT, BASE_LIGHT, false);
                    this.generateBox(var0, var4, 0, 2, 3, 0, 2, 4, BASE_GRAY, BASE_GRAY, false);
                    this.generateBox(var0, var4, 0, 1, 3, 1, 1, 4, BASE_LIGHT, BASE_LIGHT, false);
                }
                if (this.roomDefinition.hasOpening[Direction.EAST.get3DDataValue()]) {
                    this.generateBox(var0, var4, 7, 3, 3, 7, 3, 4, BASE_LIGHT, BASE_LIGHT, false);
                } else {
                    this.generateBox(var0, var4, 6, 3, 3, 7, 3, 4, BASE_LIGHT, BASE_LIGHT, false);
                    this.generateBox(var0, var4, 7, 2, 3, 7, 2, 4, BASE_GRAY, BASE_GRAY, false);
                    this.generateBox(var0, var4, 6, 1, 3, 7, 1, 4, BASE_LIGHT, BASE_LIGHT, false);
                }
            } else if (this.mainDesign == 1) {
                this.generateBox(var0, var4, 2, 1, 2, 2, 3, 2, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 2, 1, 5, 2, 3, 5, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 5, 1, 5, 5, 3, 5, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 5, 1, 2, 5, 3, 2, BASE_LIGHT, BASE_LIGHT, false);
                this.placeBlock(var0, LAMP_BLOCK, 2, 2, 2, var4);
                this.placeBlock(var0, LAMP_BLOCK, 2, 2, 5, var4);
                this.placeBlock(var0, LAMP_BLOCK, 5, 2, 5, var4);
                this.placeBlock(var0, LAMP_BLOCK, 5, 2, 2, var4);
                this.generateBox(var0, var4, 0, 1, 0, 1, 3, 0, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 0, 1, 1, 0, 3, 1, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 0, 1, 7, 1, 3, 7, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 0, 1, 6, 0, 3, 6, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 6, 1, 7, 7, 3, 7, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 7, 1, 6, 7, 3, 6, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 6, 1, 0, 7, 3, 0, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 7, 1, 1, 7, 3, 1, BASE_LIGHT, BASE_LIGHT, false);
                this.placeBlock(var0, BASE_GRAY, 1, 2, 0, var4);
                this.placeBlock(var0, BASE_GRAY, 0, 2, 1, var4);
                this.placeBlock(var0, BASE_GRAY, 1, 2, 7, var4);
                this.placeBlock(var0, BASE_GRAY, 0, 2, 6, var4);
                this.placeBlock(var0, BASE_GRAY, 6, 2, 7, var4);
                this.placeBlock(var0, BASE_GRAY, 7, 2, 6, var4);
                this.placeBlock(var0, BASE_GRAY, 6, 2, 0, var4);
                this.placeBlock(var0, BASE_GRAY, 7, 2, 1, var4);
                if (!this.roomDefinition.hasOpening[Direction.SOUTH.get3DDataValue()]) {
                    this.generateBox(var0, var4, 1, 3, 0, 6, 3, 0, BASE_LIGHT, BASE_LIGHT, false);
                    this.generateBox(var0, var4, 1, 2, 0, 6, 2, 0, BASE_GRAY, BASE_GRAY, false);
                    this.generateBox(var0, var4, 1, 1, 0, 6, 1, 0, BASE_LIGHT, BASE_LIGHT, false);
                }
                if (!this.roomDefinition.hasOpening[Direction.NORTH.get3DDataValue()]) {
                    this.generateBox(var0, var4, 1, 3, 7, 6, 3, 7, BASE_LIGHT, BASE_LIGHT, false);
                    this.generateBox(var0, var4, 1, 2, 7, 6, 2, 7, BASE_GRAY, BASE_GRAY, false);
                    this.generateBox(var0, var4, 1, 1, 7, 6, 1, 7, BASE_LIGHT, BASE_LIGHT, false);
                }
                if (!this.roomDefinition.hasOpening[Direction.WEST.get3DDataValue()]) {
                    this.generateBox(var0, var4, 0, 3, 1, 0, 3, 6, BASE_LIGHT, BASE_LIGHT, false);
                    this.generateBox(var0, var4, 0, 2, 1, 0, 2, 6, BASE_GRAY, BASE_GRAY, false);
                    this.generateBox(var0, var4, 0, 1, 1, 0, 1, 6, BASE_LIGHT, BASE_LIGHT, false);
                }
                if (!this.roomDefinition.hasOpening[Direction.EAST.get3DDataValue()]) {
                    this.generateBox(var0, var4, 7, 3, 1, 7, 3, 6, BASE_LIGHT, BASE_LIGHT, false);
                    this.generateBox(var0, var4, 7, 2, 1, 7, 2, 6, BASE_GRAY, BASE_GRAY, false);
                    this.generateBox(var0, var4, 7, 1, 1, 7, 1, 6, BASE_LIGHT, BASE_LIGHT, false);
                }
            } else if (this.mainDesign == 2) {
                this.generateBox(var0, var4, 0, 1, 0, 0, 1, 7, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 7, 1, 0, 7, 1, 7, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 1, 1, 0, 6, 1, 0, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 1, 1, 7, 6, 1, 7, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 0, 2, 0, 0, 2, 7, BASE_BLACK, BASE_BLACK, false);
                this.generateBox(var0, var4, 7, 2, 0, 7, 2, 7, BASE_BLACK, BASE_BLACK, false);
                this.generateBox(var0, var4, 1, 2, 0, 6, 2, 0, BASE_BLACK, BASE_BLACK, false);
                this.generateBox(var0, var4, 1, 2, 7, 6, 2, 7, BASE_BLACK, BASE_BLACK, false);
                this.generateBox(var0, var4, 0, 3, 0, 0, 3, 7, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 7, 3, 0, 7, 3, 7, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 1, 3, 0, 6, 3, 0, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 1, 3, 7, 6, 3, 7, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 0, 1, 3, 0, 2, 4, BASE_BLACK, BASE_BLACK, false);
                this.generateBox(var0, var4, 7, 1, 3, 7, 2, 4, BASE_BLACK, BASE_BLACK, false);
                this.generateBox(var0, var4, 3, 1, 0, 4, 2, 0, BASE_BLACK, BASE_BLACK, false);
                this.generateBox(var0, var4, 3, 1, 7, 4, 2, 7, BASE_BLACK, BASE_BLACK, false);
                if (this.roomDefinition.hasOpening[Direction.SOUTH.get3DDataValue()]) {
                    this.generateWaterBox(var0, var4, 3, 1, 0, 4, 2, 0);
                }
                if (this.roomDefinition.hasOpening[Direction.NORTH.get3DDataValue()]) {
                    this.generateWaterBox(var0, var4, 3, 1, 7, 4, 2, 7);
                }
                if (this.roomDefinition.hasOpening[Direction.WEST.get3DDataValue()]) {
                    this.generateWaterBox(var0, var4, 0, 1, 3, 0, 2, 4);
                }
                if (this.roomDefinition.hasOpening[Direction.EAST.get3DDataValue()]) {
                    this.generateWaterBox(var0, var4, 7, 1, 3, 7, 2, 4);
                }
            }
            if (var7) {
                this.generateBox(var0, var4, 3, 1, 3, 4, 1, 4, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var4, 3, 2, 3, 4, 2, 4, BASE_GRAY, BASE_GRAY, false);
                this.generateBox(var0, var4, 3, 3, 3, 4, 3, 4, BASE_LIGHT, BASE_LIGHT, false);
            }
        }
    }

    public static class OceanMonumentEntryRoom
    extends OceanMonumentPiece {
        public OceanMonumentEntryRoom(Direction var0, RoomDefinition var1) {
            super(StructurePieceType.OCEAN_MONUMENT_ENTRY_ROOM, 1, var0, var1, 1, 1, 1);
        }

        public OceanMonumentEntryRoom(CompoundTag var0) {
            super(StructurePieceType.OCEAN_MONUMENT_ENTRY_ROOM, var0);
        }

        @Override
        public void postProcess(WorldGenLevel var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, BoundingBox var4, ChunkPos var5, BlockPos var6) {
            this.generateBox(var0, var4, 0, 3, 0, 2, 3, 7, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 5, 3, 0, 7, 3, 7, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 0, 2, 0, 1, 2, 7, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 6, 2, 0, 7, 2, 7, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 0, 1, 0, 0, 1, 7, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 7, 1, 0, 7, 1, 7, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 0, 1, 7, 7, 3, 7, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 1, 1, 0, 2, 3, 0, BASE_LIGHT, BASE_LIGHT, false);
            this.generateBox(var0, var4, 5, 1, 0, 6, 3, 0, BASE_LIGHT, BASE_LIGHT, false);
            if (this.roomDefinition.hasOpening[Direction.NORTH.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 3, 1, 7, 4, 2, 7);
            }
            if (this.roomDefinition.hasOpening[Direction.WEST.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 0, 1, 3, 1, 2, 4);
            }
            if (this.roomDefinition.hasOpening[Direction.EAST.get3DDataValue()]) {
                this.generateWaterBox(var0, var4, 6, 1, 3, 7, 2, 4);
            }
        }
    }

    public static class MonumentBuilding
    extends OceanMonumentPiece {
        private static final int WIDTH = 58;
        private static final int HEIGHT = 22;
        private static final int DEPTH = 58;
        public static final int BIOME_RANGE_CHECK = 29;
        private static final int TOP_POSITION = 61;
        private RoomDefinition sourceRoom;
        private RoomDefinition coreRoom;
        private final List<OceanMonumentPiece> childPieces = Lists.newArrayList();

        public MonumentBuilding(RandomSource var0, int var1, int var2, Direction var3) {
            super(StructurePieceType.OCEAN_MONUMENT_BUILDING, var3, 0, MonumentBuilding.makeBoundingBox(var1, 39, var2, var3, 58, 23, 58));
            this.setOrientation(var3);
            List<RoomDefinition> var4 = this.generateRoomGraph(var0);
            this.sourceRoom.claimed = true;
            this.childPieces.add(new OceanMonumentEntryRoom(var3, this.sourceRoom));
            this.childPieces.add(new OceanMonumentCoreRoom(var3, this.coreRoom));
            ArrayList var5 = Lists.newArrayList();
            var5.add(new FitDoubleXYRoom());
            var5.add(new FitDoubleYZRoom());
            var5.add(new FitDoubleZRoom());
            var5.add(new FitDoubleXRoom());
            var5.add(new FitDoubleYRoom());
            var5.add(new FitSimpleTopRoom());
            var5.add(new FitSimpleRoom());
            block0: for (RoomDefinition roomDefinition : var4) {
                if (roomDefinition.claimed || roomDefinition.isSpecial()) continue;
                for (MonumentRoomFitter var92 : var5) {
                    if (!var92.fits(roomDefinition)) continue;
                    this.childPieces.add(var92.create(var3, roomDefinition, var0));
                    continue block0;
                }
            }
            BlockPos.MutableBlockPos var6 = this.getWorldPos(9, 0, 22);
            for (OceanMonumentPiece oceanMonumentPiece : this.childPieces) {
                oceanMonumentPiece.getBoundingBox().move(var6);
            }
            BoundingBox boundingBox = BoundingBox.fromCorners(this.getWorldPos(1, 1, 1), this.getWorldPos(23, 8, 21));
            BoundingBox boundingBox2 = BoundingBox.fromCorners(this.getWorldPos(34, 1, 1), this.getWorldPos(56, 8, 21));
            BoundingBox var9 = BoundingBox.fromCorners(this.getWorldPos(22, 13, 22), this.getWorldPos(35, 17, 35));
            int var10 = var0.nextInt();
            this.childPieces.add(new OceanMonumentWingRoom(var3, boundingBox, var10++));
            this.childPieces.add(new OceanMonumentWingRoom(var3, boundingBox2, var10++));
            this.childPieces.add(new OceanMonumentPenthouse(var3, var9));
        }

        public MonumentBuilding(CompoundTag var0) {
            super(StructurePieceType.OCEAN_MONUMENT_BUILDING, var0);
        }

        private List<RoomDefinition> generateRoomGraph(RandomSource var0) {
            int var12;
            int var11;
            int var10;
            int var5;
            int var4;
            int var3;
            int var2;
            RoomDefinition[] var1 = new RoomDefinition[75];
            for (var2 = 0; var2 < 5; ++var2) {
                for (var3 = 0; var3 < 4; ++var3) {
                    var4 = 0;
                    var5 = MonumentBuilding.getRoomIndex(var2, 0, var3);
                    var1[var5] = new RoomDefinition(var5);
                }
            }
            for (var2 = 0; var2 < 5; ++var2) {
                for (var3 = 0; var3 < 4; ++var3) {
                    var4 = 1;
                    var5 = MonumentBuilding.getRoomIndex(var2, 1, var3);
                    var1[var5] = new RoomDefinition(var5);
                }
            }
            for (var2 = 1; var2 < 4; ++var2) {
                for (var3 = 0; var3 < 2; ++var3) {
                    var4 = 2;
                    var5 = MonumentBuilding.getRoomIndex(var2, 2, var3);
                    var1[var5] = new RoomDefinition(var5);
                }
            }
            this.sourceRoom = var1[GRIDROOM_SOURCE_INDEX];
            for (var2 = 0; var2 < 5; ++var2) {
                for (var3 = 0; var3 < 5; ++var3) {
                    for (var4 = 0; var4 < 3; ++var4) {
                        var5 = MonumentBuilding.getRoomIndex(var2, var4, var3);
                        if (var1[var5] == null) continue;
                        for (Direction direction : Direction.values()) {
                            int var13;
                            var10 = var2 + direction.getStepX();
                            var11 = var4 + direction.getStepY();
                            var12 = var3 + direction.getStepZ();
                            if (var10 < 0 || var10 >= 5 || var12 < 0 || var12 >= 5 || var11 < 0 || var11 >= 3 || var1[var13 = MonumentBuilding.getRoomIndex(var10, var11, var12)] == null) continue;
                            if (var12 == var3) {
                                var1[var5].setConnection(direction, var1[var13]);
                                continue;
                            }
                            var1[var5].setConnection(direction.getOpposite(), var1[var13]);
                        }
                    }
                }
            }
            RoomDefinition var22 = new RoomDefinition(1003);
            RoomDefinition var32 = new RoomDefinition(1001);
            RoomDefinition var42 = new RoomDefinition(1002);
            var1[GRIDROOM_TOP_CONNECT_INDEX].setConnection(Direction.UP, var22);
            var1[GRIDROOM_LEFTWING_CONNECT_INDEX].setConnection(Direction.SOUTH, var32);
            var1[GRIDROOM_RIGHTWING_CONNECT_INDEX].setConnection(Direction.SOUTH, var42);
            var22.claimed = true;
            var32.claimed = true;
            var42.claimed = true;
            this.sourceRoom.isSource = true;
            this.coreRoom = var1[MonumentBuilding.getRoomIndex(var0.nextInt(4), 0, 2)];
            this.coreRoom.claimed = true;
            this.coreRoom.connections[Direction.EAST.get3DDataValue()].claimed = true;
            this.coreRoom.connections[Direction.NORTH.get3DDataValue()].claimed = true;
            this.coreRoom.connections[Direction.EAST.get3DDataValue()].connections[Direction.NORTH.get3DDataValue()].claimed = true;
            this.coreRoom.connections[Direction.UP.get3DDataValue()].claimed = true;
            this.coreRoom.connections[Direction.EAST.get3DDataValue()].connections[Direction.UP.get3DDataValue()].claimed = true;
            this.coreRoom.connections[Direction.NORTH.get3DDataValue()].connections[Direction.UP.get3DDataValue()].claimed = true;
            this.coreRoom.connections[Direction.EAST.get3DDataValue()].connections[Direction.NORTH.get3DDataValue()].connections[Direction.UP.get3DDataValue()].claimed = true;
            ObjectArrayList var52 = new ObjectArrayList();
            for (RoomDefinition roomDefinition : var1) {
                if (roomDefinition == null) continue;
                roomDefinition.updateOpenings();
                var52.add((Object)roomDefinition);
            }
            var22.updateOpenings();
            Util.shuffle(var52, var0);
            int var6 = 1;
            for (RoomDefinition var8 : var52) {
                int n = 0;
                for (var10 = 0; n < 2 && var10 < 5; ++var10) {
                    var11 = var0.nextInt(6);
                    if (!var8.hasOpening[var11]) continue;
                    var12 = Direction.from3DDataValue(var11).getOpposite().get3DDataValue();
                    var8.hasOpening[var11] = false;
                    var8.connections[var11].hasOpening[var12] = false;
                    if (var8.findSource(var6++) && var8.connections[var11].findSource(var6++)) {
                        ++n;
                        continue;
                    }
                    var8.hasOpening[var11] = true;
                    var8.connections[var11].hasOpening[var12] = true;
                }
            }
            var52.add((Object)var22);
            var52.add((Object)var32);
            var52.add((Object)var42);
            return var52;
        }

        @Override
        public void postProcess(WorldGenLevel var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, BoundingBox var4, ChunkPos var5, BlockPos var6) {
            int var8;
            int var7 = Math.max(var0.getSeaLevel(), 64) - this.boundingBox.minY();
            this.generateWaterBox(var0, var4, 0, 0, 0, 58, var7, 58);
            this.generateWing(false, 0, var0, var3, var4);
            this.generateWing(true, 33, var0, var3, var4);
            this.generateEntranceArchs(var0, var3, var4);
            this.generateEntranceWall(var0, var3, var4);
            this.generateRoofPiece(var0, var3, var4);
            this.generateLowerWall(var0, var3, var4);
            this.generateMiddleWall(var0, var3, var4);
            this.generateUpperWall(var0, var3, var4);
            for (var8 = 0; var8 < 7; ++var8) {
                int var9 = 0;
                while (var9 < 7) {
                    if (var9 == 0 && var8 == 3) {
                        var9 = 6;
                    }
                    int var10 = var8 * 9;
                    int var11 = var9 * 9;
                    for (int var12 = 0; var12 < 4; ++var12) {
                        for (int var13 = 0; var13 < 4; ++var13) {
                            this.placeBlock(var0, BASE_LIGHT, var10 + var12, 0, var11 + var13, var4);
                            this.fillColumnDown(var0, BASE_LIGHT, var10 + var12, -1, var11 + var13, var4);
                        }
                    }
                    if (var8 == 0 || var8 == 6) {
                        ++var9;
                        continue;
                    }
                    var9 += 6;
                }
            }
            for (var8 = 0; var8 < 5; ++var8) {
                this.generateWaterBox(var0, var4, -1 - var8, 0 + var8 * 2, -1 - var8, -1 - var8, 23, 58 + var8);
                this.generateWaterBox(var0, var4, 58 + var8, 0 + var8 * 2, -1 - var8, 58 + var8, 23, 58 + var8);
                this.generateWaterBox(var0, var4, 0 - var8, 0 + var8 * 2, -1 - var8, 57 + var8, 23, -1 - var8);
                this.generateWaterBox(var0, var4, 0 - var8, 0 + var8 * 2, 58 + var8, 57 + var8, 23, 58 + var8);
            }
            for (OceanMonumentPiece var9 : this.childPieces) {
                if (!var9.getBoundingBox().intersects(var4)) continue;
                var9.postProcess(var0, var1, var2, var3, var4, var5, var6);
            }
        }

        private void generateWing(boolean var0, int var1, WorldGenLevel var2, RandomSource var3, BoundingBox var4) {
            int var5 = 24;
            if (this.chunkIntersects(var4, var1, 0, var1 + 23, 20)) {
                int var8;
                int var6;
                this.generateBox(var2, var4, var1 + 0, 0, 0, var1 + 24, 0, 20, BASE_GRAY, BASE_GRAY, false);
                this.generateWaterBox(var2, var4, var1 + 0, 1, 0, var1 + 24, 10, 20);
                for (var6 = 0; var6 < 4; ++var6) {
                    this.generateBox(var2, var4, var1 + var6, var6 + 1, var6, var1 + var6, var6 + 1, 20, BASE_LIGHT, BASE_LIGHT, false);
                    this.generateBox(var2, var4, var1 + var6 + 7, var6 + 5, var6 + 7, var1 + var6 + 7, var6 + 5, 20, BASE_LIGHT, BASE_LIGHT, false);
                    this.generateBox(var2, var4, var1 + 17 - var6, var6 + 5, var6 + 7, var1 + 17 - var6, var6 + 5, 20, BASE_LIGHT, BASE_LIGHT, false);
                    this.generateBox(var2, var4, var1 + 24 - var6, var6 + 1, var6, var1 + 24 - var6, var6 + 1, 20, BASE_LIGHT, BASE_LIGHT, false);
                    this.generateBox(var2, var4, var1 + var6 + 1, var6 + 1, var6, var1 + 23 - var6, var6 + 1, var6, BASE_LIGHT, BASE_LIGHT, false);
                    this.generateBox(var2, var4, var1 + var6 + 8, var6 + 5, var6 + 7, var1 + 16 - var6, var6 + 5, var6 + 7, BASE_LIGHT, BASE_LIGHT, false);
                }
                this.generateBox(var2, var4, var1 + 4, 4, 4, var1 + 6, 4, 20, BASE_GRAY, BASE_GRAY, false);
                this.generateBox(var2, var4, var1 + 7, 4, 4, var1 + 17, 4, 6, BASE_GRAY, BASE_GRAY, false);
                this.generateBox(var2, var4, var1 + 18, 4, 4, var1 + 20, 4, 20, BASE_GRAY, BASE_GRAY, false);
                this.generateBox(var2, var4, var1 + 11, 8, 11, var1 + 13, 8, 20, BASE_GRAY, BASE_GRAY, false);
                this.placeBlock(var2, DOT_DECO_DATA, var1 + 12, 9, 12, var4);
                this.placeBlock(var2, DOT_DECO_DATA, var1 + 12, 9, 15, var4);
                this.placeBlock(var2, DOT_DECO_DATA, var1 + 12, 9, 18, var4);
                var6 = var1 + (var0 ? 19 : 5);
                int var7 = var1 + (var0 ? 5 : 19);
                for (var8 = 20; var8 >= 5; var8 -= 3) {
                    this.placeBlock(var2, DOT_DECO_DATA, var6, 5, var8, var4);
                }
                for (var8 = 19; var8 >= 7; var8 -= 3) {
                    this.placeBlock(var2, DOT_DECO_DATA, var7, 5, var8, var4);
                }
                for (var8 = 0; var8 < 4; ++var8) {
                    int var9 = var0 ? var1 + 24 - (17 - var8 * 3) : var1 + 17 - var8 * 3;
                    this.placeBlock(var2, DOT_DECO_DATA, var9, 5, 5, var4);
                }
                this.placeBlock(var2, DOT_DECO_DATA, var7, 5, 5, var4);
                this.generateBox(var2, var4, var1 + 11, 1, 12, var1 + 13, 7, 12, BASE_GRAY, BASE_GRAY, false);
                this.generateBox(var2, var4, var1 + 12, 1, 11, var1 + 12, 7, 13, BASE_GRAY, BASE_GRAY, false);
            }
        }

        private void generateEntranceArchs(WorldGenLevel var0, RandomSource var1, BoundingBox var2) {
            if (this.chunkIntersects(var2, 22, 5, 35, 17)) {
                this.generateWaterBox(var0, var2, 25, 0, 0, 32, 8, 20);
                for (int var3 = 0; var3 < 4; ++var3) {
                    this.generateBox(var0, var2, 24, 2, 5 + var3 * 4, 24, 4, 5 + var3 * 4, BASE_LIGHT, BASE_LIGHT, false);
                    this.generateBox(var0, var2, 22, 4, 5 + var3 * 4, 23, 4, 5 + var3 * 4, BASE_LIGHT, BASE_LIGHT, false);
                    this.placeBlock(var0, BASE_LIGHT, 25, 5, 5 + var3 * 4, var2);
                    this.placeBlock(var0, BASE_LIGHT, 26, 6, 5 + var3 * 4, var2);
                    this.placeBlock(var0, LAMP_BLOCK, 26, 5, 5 + var3 * 4, var2);
                    this.generateBox(var0, var2, 33, 2, 5 + var3 * 4, 33, 4, 5 + var3 * 4, BASE_LIGHT, BASE_LIGHT, false);
                    this.generateBox(var0, var2, 34, 4, 5 + var3 * 4, 35, 4, 5 + var3 * 4, BASE_LIGHT, BASE_LIGHT, false);
                    this.placeBlock(var0, BASE_LIGHT, 32, 5, 5 + var3 * 4, var2);
                    this.placeBlock(var0, BASE_LIGHT, 31, 6, 5 + var3 * 4, var2);
                    this.placeBlock(var0, LAMP_BLOCK, 31, 5, 5 + var3 * 4, var2);
                    this.generateBox(var0, var2, 27, 6, 5 + var3 * 4, 30, 6, 5 + var3 * 4, BASE_GRAY, BASE_GRAY, false);
                }
            }
        }

        private void generateEntranceWall(WorldGenLevel var0, RandomSource var1, BoundingBox var2) {
            if (this.chunkIntersects(var2, 15, 20, 42, 21)) {
                int var3;
                this.generateBox(var0, var2, 15, 0, 21, 42, 0, 21, BASE_GRAY, BASE_GRAY, false);
                this.generateWaterBox(var0, var2, 26, 1, 21, 31, 3, 21);
                this.generateBox(var0, var2, 21, 12, 21, 36, 12, 21, BASE_GRAY, BASE_GRAY, false);
                this.generateBox(var0, var2, 17, 11, 21, 40, 11, 21, BASE_GRAY, BASE_GRAY, false);
                this.generateBox(var0, var2, 16, 10, 21, 41, 10, 21, BASE_GRAY, BASE_GRAY, false);
                this.generateBox(var0, var2, 15, 7, 21, 42, 9, 21, BASE_GRAY, BASE_GRAY, false);
                this.generateBox(var0, var2, 16, 6, 21, 41, 6, 21, BASE_GRAY, BASE_GRAY, false);
                this.generateBox(var0, var2, 17, 5, 21, 40, 5, 21, BASE_GRAY, BASE_GRAY, false);
                this.generateBox(var0, var2, 21, 4, 21, 36, 4, 21, BASE_GRAY, BASE_GRAY, false);
                this.generateBox(var0, var2, 22, 3, 21, 26, 3, 21, BASE_GRAY, BASE_GRAY, false);
                this.generateBox(var0, var2, 31, 3, 21, 35, 3, 21, BASE_GRAY, BASE_GRAY, false);
                this.generateBox(var0, var2, 23, 2, 21, 25, 2, 21, BASE_GRAY, BASE_GRAY, false);
                this.generateBox(var0, var2, 32, 2, 21, 34, 2, 21, BASE_GRAY, BASE_GRAY, false);
                this.generateBox(var0, var2, 28, 4, 20, 29, 4, 21, BASE_LIGHT, BASE_LIGHT, false);
                this.placeBlock(var0, BASE_LIGHT, 27, 3, 21, var2);
                this.placeBlock(var0, BASE_LIGHT, 30, 3, 21, var2);
                this.placeBlock(var0, BASE_LIGHT, 26, 2, 21, var2);
                this.placeBlock(var0, BASE_LIGHT, 31, 2, 21, var2);
                this.placeBlock(var0, BASE_LIGHT, 25, 1, 21, var2);
                this.placeBlock(var0, BASE_LIGHT, 32, 1, 21, var2);
                for (var3 = 0; var3 < 7; ++var3) {
                    this.placeBlock(var0, BASE_BLACK, 28 - var3, 6 + var3, 21, var2);
                    this.placeBlock(var0, BASE_BLACK, 29 + var3, 6 + var3, 21, var2);
                }
                for (var3 = 0; var3 < 4; ++var3) {
                    this.placeBlock(var0, BASE_BLACK, 28 - var3, 9 + var3, 21, var2);
                    this.placeBlock(var0, BASE_BLACK, 29 + var3, 9 + var3, 21, var2);
                }
                this.placeBlock(var0, BASE_BLACK, 28, 12, 21, var2);
                this.placeBlock(var0, BASE_BLACK, 29, 12, 21, var2);
                for (var3 = 0; var3 < 3; ++var3) {
                    this.placeBlock(var0, BASE_BLACK, 22 - var3 * 2, 8, 21, var2);
                    this.placeBlock(var0, BASE_BLACK, 22 - var3 * 2, 9, 21, var2);
                    this.placeBlock(var0, BASE_BLACK, 35 + var3 * 2, 8, 21, var2);
                    this.placeBlock(var0, BASE_BLACK, 35 + var3 * 2, 9, 21, var2);
                }
                this.generateWaterBox(var0, var2, 15, 13, 21, 42, 15, 21);
                this.generateWaterBox(var0, var2, 15, 1, 21, 15, 6, 21);
                this.generateWaterBox(var0, var2, 16, 1, 21, 16, 5, 21);
                this.generateWaterBox(var0, var2, 17, 1, 21, 20, 4, 21);
                this.generateWaterBox(var0, var2, 21, 1, 21, 21, 3, 21);
                this.generateWaterBox(var0, var2, 22, 1, 21, 22, 2, 21);
                this.generateWaterBox(var0, var2, 23, 1, 21, 24, 1, 21);
                this.generateWaterBox(var0, var2, 42, 1, 21, 42, 6, 21);
                this.generateWaterBox(var0, var2, 41, 1, 21, 41, 5, 21);
                this.generateWaterBox(var0, var2, 37, 1, 21, 40, 4, 21);
                this.generateWaterBox(var0, var2, 36, 1, 21, 36, 3, 21);
                this.generateWaterBox(var0, var2, 33, 1, 21, 34, 1, 21);
                this.generateWaterBox(var0, var2, 35, 1, 21, 35, 2, 21);
            }
        }

        private void generateRoofPiece(WorldGenLevel var0, RandomSource var1, BoundingBox var2) {
            if (this.chunkIntersects(var2, 21, 21, 36, 36)) {
                this.generateBox(var0, var2, 21, 0, 22, 36, 0, 36, BASE_GRAY, BASE_GRAY, false);
                this.generateWaterBox(var0, var2, 21, 1, 22, 36, 23, 36);
                for (int var3 = 0; var3 < 4; ++var3) {
                    this.generateBox(var0, var2, 21 + var3, 13 + var3, 21 + var3, 36 - var3, 13 + var3, 21 + var3, BASE_LIGHT, BASE_LIGHT, false);
                    this.generateBox(var0, var2, 21 + var3, 13 + var3, 36 - var3, 36 - var3, 13 + var3, 36 - var3, BASE_LIGHT, BASE_LIGHT, false);
                    this.generateBox(var0, var2, 21 + var3, 13 + var3, 22 + var3, 21 + var3, 13 + var3, 35 - var3, BASE_LIGHT, BASE_LIGHT, false);
                    this.generateBox(var0, var2, 36 - var3, 13 + var3, 22 + var3, 36 - var3, 13 + var3, 35 - var3, BASE_LIGHT, BASE_LIGHT, false);
                }
                this.generateBox(var0, var2, 25, 16, 25, 32, 16, 32, BASE_GRAY, BASE_GRAY, false);
                this.generateBox(var0, var2, 25, 17, 25, 25, 19, 25, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var2, 32, 17, 25, 32, 19, 25, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var2, 25, 17, 32, 25, 19, 32, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var2, 32, 17, 32, 32, 19, 32, BASE_LIGHT, BASE_LIGHT, false);
                this.placeBlock(var0, BASE_LIGHT, 26, 20, 26, var2);
                this.placeBlock(var0, BASE_LIGHT, 27, 21, 27, var2);
                this.placeBlock(var0, LAMP_BLOCK, 27, 20, 27, var2);
                this.placeBlock(var0, BASE_LIGHT, 26, 20, 31, var2);
                this.placeBlock(var0, BASE_LIGHT, 27, 21, 30, var2);
                this.placeBlock(var0, LAMP_BLOCK, 27, 20, 30, var2);
                this.placeBlock(var0, BASE_LIGHT, 31, 20, 31, var2);
                this.placeBlock(var0, BASE_LIGHT, 30, 21, 30, var2);
                this.placeBlock(var0, LAMP_BLOCK, 30, 20, 30, var2);
                this.placeBlock(var0, BASE_LIGHT, 31, 20, 26, var2);
                this.placeBlock(var0, BASE_LIGHT, 30, 21, 27, var2);
                this.placeBlock(var0, LAMP_BLOCK, 30, 20, 27, var2);
                this.generateBox(var0, var2, 28, 21, 27, 29, 21, 27, BASE_GRAY, BASE_GRAY, false);
                this.generateBox(var0, var2, 27, 21, 28, 27, 21, 29, BASE_GRAY, BASE_GRAY, false);
                this.generateBox(var0, var2, 28, 21, 30, 29, 21, 30, BASE_GRAY, BASE_GRAY, false);
                this.generateBox(var0, var2, 30, 21, 28, 30, 21, 29, BASE_GRAY, BASE_GRAY, false);
            }
        }

        private void generateLowerWall(WorldGenLevel var0, RandomSource var1, BoundingBox var2) {
            int var3;
            if (this.chunkIntersects(var2, 0, 21, 6, 58)) {
                this.generateBox(var0, var2, 0, 0, 21, 6, 0, 57, BASE_GRAY, BASE_GRAY, false);
                this.generateWaterBox(var0, var2, 0, 1, 21, 6, 7, 57);
                this.generateBox(var0, var2, 4, 4, 21, 6, 4, 53, BASE_GRAY, BASE_GRAY, false);
                for (var3 = 0; var3 < 4; ++var3) {
                    this.generateBox(var0, var2, var3, var3 + 1, 21, var3, var3 + 1, 57 - var3, BASE_LIGHT, BASE_LIGHT, false);
                }
                for (var3 = 23; var3 < 53; var3 += 3) {
                    this.placeBlock(var0, DOT_DECO_DATA, 5, 5, var3, var2);
                }
                this.placeBlock(var0, DOT_DECO_DATA, 5, 5, 52, var2);
                for (var3 = 0; var3 < 4; ++var3) {
                    this.generateBox(var0, var2, var3, var3 + 1, 21, var3, var3 + 1, 57 - var3, BASE_LIGHT, BASE_LIGHT, false);
                }
                this.generateBox(var0, var2, 4, 1, 52, 6, 3, 52, BASE_GRAY, BASE_GRAY, false);
                this.generateBox(var0, var2, 5, 1, 51, 5, 3, 53, BASE_GRAY, BASE_GRAY, false);
            }
            if (this.chunkIntersects(var2, 51, 21, 58, 58)) {
                this.generateBox(var0, var2, 51, 0, 21, 57, 0, 57, BASE_GRAY, BASE_GRAY, false);
                this.generateWaterBox(var0, var2, 51, 1, 21, 57, 7, 57);
                this.generateBox(var0, var2, 51, 4, 21, 53, 4, 53, BASE_GRAY, BASE_GRAY, false);
                for (var3 = 0; var3 < 4; ++var3) {
                    this.generateBox(var0, var2, 57 - var3, var3 + 1, 21, 57 - var3, var3 + 1, 57 - var3, BASE_LIGHT, BASE_LIGHT, false);
                }
                for (var3 = 23; var3 < 53; var3 += 3) {
                    this.placeBlock(var0, DOT_DECO_DATA, 52, 5, var3, var2);
                }
                this.placeBlock(var0, DOT_DECO_DATA, 52, 5, 52, var2);
                this.generateBox(var0, var2, 51, 1, 52, 53, 3, 52, BASE_GRAY, BASE_GRAY, false);
                this.generateBox(var0, var2, 52, 1, 51, 52, 3, 53, BASE_GRAY, BASE_GRAY, false);
            }
            if (this.chunkIntersects(var2, 0, 51, 57, 57)) {
                this.generateBox(var0, var2, 7, 0, 51, 50, 0, 57, BASE_GRAY, BASE_GRAY, false);
                this.generateWaterBox(var0, var2, 7, 1, 51, 50, 10, 57);
                for (var3 = 0; var3 < 4; ++var3) {
                    this.generateBox(var0, var2, var3 + 1, var3 + 1, 57 - var3, 56 - var3, var3 + 1, 57 - var3, BASE_LIGHT, BASE_LIGHT, false);
                }
            }
        }

        private void generateMiddleWall(WorldGenLevel var0, RandomSource var1, BoundingBox var2) {
            int var3;
            if (this.chunkIntersects(var2, 7, 21, 13, 50)) {
                this.generateBox(var0, var2, 7, 0, 21, 13, 0, 50, BASE_GRAY, BASE_GRAY, false);
                this.generateWaterBox(var0, var2, 7, 1, 21, 13, 10, 50);
                this.generateBox(var0, var2, 11, 8, 21, 13, 8, 53, BASE_GRAY, BASE_GRAY, false);
                for (var3 = 0; var3 < 4; ++var3) {
                    this.generateBox(var0, var2, var3 + 7, var3 + 5, 21, var3 + 7, var3 + 5, 54, BASE_LIGHT, BASE_LIGHT, false);
                }
                for (var3 = 21; var3 <= 45; var3 += 3) {
                    this.placeBlock(var0, DOT_DECO_DATA, 12, 9, var3, var2);
                }
            }
            if (this.chunkIntersects(var2, 44, 21, 50, 54)) {
                this.generateBox(var0, var2, 44, 0, 21, 50, 0, 50, BASE_GRAY, BASE_GRAY, false);
                this.generateWaterBox(var0, var2, 44, 1, 21, 50, 10, 50);
                this.generateBox(var0, var2, 44, 8, 21, 46, 8, 53, BASE_GRAY, BASE_GRAY, false);
                for (var3 = 0; var3 < 4; ++var3) {
                    this.generateBox(var0, var2, 50 - var3, var3 + 5, 21, 50 - var3, var3 + 5, 54, BASE_LIGHT, BASE_LIGHT, false);
                }
                for (var3 = 21; var3 <= 45; var3 += 3) {
                    this.placeBlock(var0, DOT_DECO_DATA, 45, 9, var3, var2);
                }
            }
            if (this.chunkIntersects(var2, 8, 44, 49, 54)) {
                this.generateBox(var0, var2, 14, 0, 44, 43, 0, 50, BASE_GRAY, BASE_GRAY, false);
                this.generateWaterBox(var0, var2, 14, 1, 44, 43, 10, 50);
                for (var3 = 12; var3 <= 45; var3 += 3) {
                    this.placeBlock(var0, DOT_DECO_DATA, var3, 9, 45, var2);
                    this.placeBlock(var0, DOT_DECO_DATA, var3, 9, 52, var2);
                    if (var3 != 12 && var3 != 18 && var3 != 24 && var3 != 33 && var3 != 39 && var3 != 45) continue;
                    this.placeBlock(var0, DOT_DECO_DATA, var3, 9, 47, var2);
                    this.placeBlock(var0, DOT_DECO_DATA, var3, 9, 50, var2);
                    this.placeBlock(var0, DOT_DECO_DATA, var3, 10, 45, var2);
                    this.placeBlock(var0, DOT_DECO_DATA, var3, 10, 46, var2);
                    this.placeBlock(var0, DOT_DECO_DATA, var3, 10, 51, var2);
                    this.placeBlock(var0, DOT_DECO_DATA, var3, 10, 52, var2);
                    this.placeBlock(var0, DOT_DECO_DATA, var3, 11, 47, var2);
                    this.placeBlock(var0, DOT_DECO_DATA, var3, 11, 50, var2);
                    this.placeBlock(var0, DOT_DECO_DATA, var3, 12, 48, var2);
                    this.placeBlock(var0, DOT_DECO_DATA, var3, 12, 49, var2);
                }
                for (var3 = 0; var3 < 3; ++var3) {
                    this.generateBox(var0, var2, 8 + var3, 5 + var3, 54, 49 - var3, 5 + var3, 54, BASE_GRAY, BASE_GRAY, false);
                }
                this.generateBox(var0, var2, 11, 8, 54, 46, 8, 54, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var2, 14, 8, 44, 43, 8, 53, BASE_GRAY, BASE_GRAY, false);
            }
        }

        private void generateUpperWall(WorldGenLevel var0, RandomSource var1, BoundingBox var2) {
            int var3;
            if (this.chunkIntersects(var2, 14, 21, 20, 43)) {
                this.generateBox(var0, var2, 14, 0, 21, 20, 0, 43, BASE_GRAY, BASE_GRAY, false);
                this.generateWaterBox(var0, var2, 14, 1, 22, 20, 14, 43);
                this.generateBox(var0, var2, 18, 12, 22, 20, 12, 39, BASE_GRAY, BASE_GRAY, false);
                this.generateBox(var0, var2, 18, 12, 21, 20, 12, 21, BASE_LIGHT, BASE_LIGHT, false);
                for (var3 = 0; var3 < 4; ++var3) {
                    this.generateBox(var0, var2, var3 + 14, var3 + 9, 21, var3 + 14, var3 + 9, 43 - var3, BASE_LIGHT, BASE_LIGHT, false);
                }
                for (var3 = 23; var3 <= 39; var3 += 3) {
                    this.placeBlock(var0, DOT_DECO_DATA, 19, 13, var3, var2);
                }
            }
            if (this.chunkIntersects(var2, 37, 21, 43, 43)) {
                this.generateBox(var0, var2, 37, 0, 21, 43, 0, 43, BASE_GRAY, BASE_GRAY, false);
                this.generateWaterBox(var0, var2, 37, 1, 22, 43, 14, 43);
                this.generateBox(var0, var2, 37, 12, 22, 39, 12, 39, BASE_GRAY, BASE_GRAY, false);
                this.generateBox(var0, var2, 37, 12, 21, 39, 12, 21, BASE_LIGHT, BASE_LIGHT, false);
                for (var3 = 0; var3 < 4; ++var3) {
                    this.generateBox(var0, var2, 43 - var3, var3 + 9, 21, 43 - var3, var3 + 9, 43 - var3, BASE_LIGHT, BASE_LIGHT, false);
                }
                for (var3 = 23; var3 <= 39; var3 += 3) {
                    this.placeBlock(var0, DOT_DECO_DATA, 38, 13, var3, var2);
                }
            }
            if (this.chunkIntersects(var2, 15, 37, 42, 43)) {
                this.generateBox(var0, var2, 21, 0, 37, 36, 0, 43, BASE_GRAY, BASE_GRAY, false);
                this.generateWaterBox(var0, var2, 21, 1, 37, 36, 14, 43);
                this.generateBox(var0, var2, 21, 12, 37, 36, 12, 39, BASE_GRAY, BASE_GRAY, false);
                for (var3 = 0; var3 < 4; ++var3) {
                    this.generateBox(var0, var2, 15 + var3, var3 + 9, 43 - var3, 42 - var3, var3 + 9, 43 - var3, BASE_LIGHT, BASE_LIGHT, false);
                }
                for (var3 = 21; var3 <= 36; var3 += 3) {
                    this.placeBlock(var0, DOT_DECO_DATA, var3, 13, 38, var2);
                }
            }
        }
    }

    protected static abstract class OceanMonumentPiece
    extends StructurePiece {
        protected static final BlockState BASE_GRAY = Blocks.PRISMARINE.defaultBlockState();
        protected static final BlockState BASE_LIGHT = Blocks.PRISMARINE_BRICKS.defaultBlockState();
        protected static final BlockState BASE_BLACK = Blocks.DARK_PRISMARINE.defaultBlockState();
        protected static final BlockState DOT_DECO_DATA = BASE_LIGHT;
        protected static final BlockState LAMP_BLOCK = Blocks.SEA_LANTERN.defaultBlockState();
        protected static final boolean DO_FILL = true;
        protected static final BlockState FILL_BLOCK = Blocks.WATER.defaultBlockState();
        protected static final Set<Block> FILL_KEEP = ImmutableSet.builder().add((Object)Blocks.ICE).add((Object)Blocks.PACKED_ICE).add((Object)Blocks.BLUE_ICE).add((Object)FILL_BLOCK.getBlock()).build();
        protected static final int GRIDROOM_WIDTH = 8;
        protected static final int GRIDROOM_DEPTH = 8;
        protected static final int GRIDROOM_HEIGHT = 4;
        protected static final int GRID_WIDTH = 5;
        protected static final int GRID_DEPTH = 5;
        protected static final int GRID_HEIGHT = 3;
        protected static final int GRID_FLOOR_COUNT = 25;
        protected static final int GRID_SIZE = 75;
        protected static final int GRIDROOM_SOURCE_INDEX = OceanMonumentPiece.getRoomIndex(2, 0, 0);
        protected static final int GRIDROOM_TOP_CONNECT_INDEX = OceanMonumentPiece.getRoomIndex(2, 2, 0);
        protected static final int GRIDROOM_LEFTWING_CONNECT_INDEX = OceanMonumentPiece.getRoomIndex(0, 1, 0);
        protected static final int GRIDROOM_RIGHTWING_CONNECT_INDEX = OceanMonumentPiece.getRoomIndex(4, 1, 0);
        protected static final int LEFTWING_INDEX = 1001;
        protected static final int RIGHTWING_INDEX = 1002;
        protected static final int PENTHOUSE_INDEX = 1003;
        protected RoomDefinition roomDefinition;

        protected static int getRoomIndex(int var0, int var1, int var2) {
            return var1 * 25 + var2 * 5 + var0;
        }

        public OceanMonumentPiece(StructurePieceType var0, Direction var1, int var2, BoundingBox var3) {
            super(var0, var2, var3);
            this.setOrientation(var1);
        }

        protected OceanMonumentPiece(StructurePieceType var0, int var1, Direction var2, RoomDefinition var3, int var4, int var5, int var6) {
            super(var0, var1, OceanMonumentPiece.makeBoundingBox(var2, var3, var4, var5, var6));
            this.setOrientation(var2);
            this.roomDefinition = var3;
        }

        private static BoundingBox makeBoundingBox(Direction var0, RoomDefinition var1, int var2, int var3, int var4) {
            int var5 = var1.index;
            int var6 = var5 % 5;
            int var7 = var5 / 5 % 5;
            int var8 = var5 / 25;
            BoundingBox var9 = OceanMonumentPiece.makeBoundingBox(0, 0, 0, var0, var2 * 8, var3 * 4, var4 * 8);
            switch (var0) {
                case NORTH: {
                    var9.move(var6 * 8, var8 * 4, -(var7 + var4) * 8 + 1);
                    break;
                }
                case SOUTH: {
                    var9.move(var6 * 8, var8 * 4, var7 * 8);
                    break;
                }
                case WEST: {
                    var9.move(-(var7 + var4) * 8 + 1, var8 * 4, var6 * 8);
                    break;
                }
                default: {
                    var9.move(var7 * 8, var8 * 4, var6 * 8);
                }
            }
            return var9;
        }

        public OceanMonumentPiece(StructurePieceType var0, CompoundTag var1) {
            super(var0, var1);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext var0, CompoundTag var1) {
        }

        protected void generateWaterBox(WorldGenLevel var0, BoundingBox var1, int var2, int var3, int var4, int var5, int var6, int var7) {
            for (int var8 = var3; var8 <= var6; ++var8) {
                for (int var9 = var2; var9 <= var5; ++var9) {
                    for (int var10 = var4; var10 <= var7; ++var10) {
                        BlockState var11 = this.getBlock(var0, var9, var8, var10, var1);
                        if (FILL_KEEP.contains(var11.getBlock())) continue;
                        if (this.getWorldY(var8) >= var0.getSeaLevel() && var11 != FILL_BLOCK) {
                            this.placeBlock(var0, Blocks.AIR.defaultBlockState(), var9, var8, var10, var1);
                            continue;
                        }
                        this.placeBlock(var0, FILL_BLOCK, var9, var8, var10, var1);
                    }
                }
            }
        }

        protected void generateDefaultFloor(WorldGenLevel var0, BoundingBox var1, int var2, int var3, boolean var4) {
            if (var4) {
                this.generateBox(var0, var1, var2 + 0, 0, var3 + 0, var2 + 2, 0, var3 + 8 - 1, BASE_GRAY, BASE_GRAY, false);
                this.generateBox(var0, var1, var2 + 5, 0, var3 + 0, var2 + 8 - 1, 0, var3 + 8 - 1, BASE_GRAY, BASE_GRAY, false);
                this.generateBox(var0, var1, var2 + 3, 0, var3 + 0, var2 + 4, 0, var3 + 2, BASE_GRAY, BASE_GRAY, false);
                this.generateBox(var0, var1, var2 + 3, 0, var3 + 5, var2 + 4, 0, var3 + 8 - 1, BASE_GRAY, BASE_GRAY, false);
                this.generateBox(var0, var1, var2 + 3, 0, var3 + 2, var2 + 4, 0, var3 + 2, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var1, var2 + 3, 0, var3 + 5, var2 + 4, 0, var3 + 5, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var1, var2 + 2, 0, var3 + 3, var2 + 2, 0, var3 + 4, BASE_LIGHT, BASE_LIGHT, false);
                this.generateBox(var0, var1, var2 + 5, 0, var3 + 3, var2 + 5, 0, var3 + 4, BASE_LIGHT, BASE_LIGHT, false);
            } else {
                this.generateBox(var0, var1, var2 + 0, 0, var3 + 0, var2 + 8 - 1, 0, var3 + 8 - 1, BASE_GRAY, BASE_GRAY, false);
            }
        }

        protected void generateBoxOnFillOnly(WorldGenLevel var0, BoundingBox var1, int var2, int var3, int var4, int var5, int var6, int var7, BlockState var8) {
            for (int var9 = var3; var9 <= var6; ++var9) {
                for (int var10 = var2; var10 <= var5; ++var10) {
                    for (int var11 = var4; var11 <= var7; ++var11) {
                        if (this.getBlock(var0, var10, var9, var11, var1) != FILL_BLOCK) continue;
                        this.placeBlock(var0, var8, var10, var9, var11, var1);
                    }
                }
            }
        }

        protected boolean chunkIntersects(BoundingBox var0, int var1, int var2, int var3, int var4) {
            int var5 = this.getWorldX(var1, var2);
            int var6 = this.getWorldZ(var1, var2);
            int var7 = this.getWorldX(var3, var4);
            int var8 = this.getWorldZ(var3, var4);
            return var0.intersects(Math.min(var5, var7), Math.min(var6, var8), Math.max(var5, var7), Math.max(var6, var8));
        }

        protected void spawnElder(WorldGenLevel var0, BoundingBox var1, int var2, int var3, int var4) {
            ElderGuardian var6;
            BlockPos.MutableBlockPos var5 = this.getWorldPos(var2, var3, var4);
            if (var1.isInside(var5) && (var6 = EntityType.ELDER_GUARDIAN.create(var0.getLevel(), EntitySpawnReason.STRUCTURE)) != null) {
                var6.heal(var6.getMaxHealth());
                var6.snapTo((double)var5.getX() + 0.5, var5.getY(), (double)var5.getZ() + 0.5, 0.0f, 0.0f);
                var6.finalizeSpawn(var0, var0.getCurrentDifficultyAt(var6.blockPosition()), EntitySpawnReason.STRUCTURE, null);
                var0.addFreshEntityWithPassengers(var6);
            }
        }
    }
}

