/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.Identifier;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlackstoneReplaceProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockAgeProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.LavaSubmergedBlockProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProtectedBlockProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class RuinedPortalPiece
extends TemplateStructurePiece {
    private static final float PROBABILITY_OF_GOLD_GONE = 0.3f;
    private static final float PROBABILITY_OF_MAGMA_INSTEAD_OF_NETHERRACK = 0.07f;
    private static final float PROBABILITY_OF_MAGMA_INSTEAD_OF_LAVA = 0.2f;
    private final VerticalPlacement verticalPlacement;
    private final Properties properties;

    public RuinedPortalPiece(StructureTemplateManager var0, BlockPos var1, VerticalPlacement var2, Properties var3, Identifier var4, StructureTemplate var5, Rotation var6, Mirror var7, BlockPos var8) {
        super(StructurePieceType.RUINED_PORTAL, 0, var0, var4, var4.toString(), RuinedPortalPiece.makeSettings(var7, var6, var2, var8, var3), var1);
        this.verticalPlacement = var2;
        this.properties = var3;
    }

    public RuinedPortalPiece(StructureTemplateManager var0, CompoundTag var1) {
        super(StructurePieceType.RUINED_PORTAL, var1, var0, var2 -> RuinedPortalPiece.makeSettings(var0, var1, var2));
        this.verticalPlacement = var1.read("VerticalPlacement", VerticalPlacement.CODEC).orElseThrow();
        this.properties = var1.read("Properties", Properties.CODEC).orElseThrow();
    }

    @Override
    protected void addAdditionalSaveData(StructurePieceSerializationContext var0, CompoundTag var1) {
        super.addAdditionalSaveData(var0, var1);
        var1.store("Rotation", Rotation.LEGACY_CODEC, this.placeSettings.getRotation());
        var1.store("Mirror", Mirror.LEGACY_CODEC, this.placeSettings.getMirror());
        var1.store("VerticalPlacement", VerticalPlacement.CODEC, this.verticalPlacement);
        var1.store("Properties", Properties.CODEC, this.properties);
    }

    private static StructurePlaceSettings makeSettings(StructureTemplateManager var0, CompoundTag var1, Identifier var2) {
        StructureTemplate var3 = var0.getOrCreate(var2);
        BlockPos var4 = new BlockPos(var3.getSize().getX() / 2, 0, var3.getSize().getZ() / 2);
        return RuinedPortalPiece.makeSettings(var1.read("Mirror", Mirror.LEGACY_CODEC).orElseThrow(), var1.read("Rotation", Rotation.LEGACY_CODEC).orElseThrow(), var1.read("VerticalPlacement", VerticalPlacement.CODEC).orElseThrow(), var4, (Properties)Properties.CODEC.parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)var1.get("Properties"))).getPartialOrThrow());
    }

    private static StructurePlaceSettings makeSettings(Mirror var0, Rotation var1, VerticalPlacement var2, BlockPos var3, Properties var4) {
        BlockIgnoreProcessor var5 = var4.airPocket ? BlockIgnoreProcessor.STRUCTURE_BLOCK : BlockIgnoreProcessor.STRUCTURE_AND_AIR;
        ArrayList var6 = Lists.newArrayList();
        var6.add(RuinedPortalPiece.getBlockReplaceRule(Blocks.GOLD_BLOCK, 0.3f, Blocks.AIR));
        var6.add(RuinedPortalPiece.getLavaProcessorRule(var2, var4));
        if (!var4.cold) {
            var6.add(RuinedPortalPiece.getBlockReplaceRule(Blocks.NETHERRACK, 0.07f, Blocks.MAGMA_BLOCK));
        }
        StructurePlaceSettings var7 = new StructurePlaceSettings().setRotation(var1).setMirror(var0).setRotationPivot(var3).addProcessor(var5).addProcessor(new RuleProcessor(var6)).addProcessor(new BlockAgeProcessor(var4.mossiness)).addProcessor(new ProtectedBlockProcessor(BlockTags.FEATURES_CANNOT_REPLACE)).addProcessor(new LavaSubmergedBlockProcessor());
        if (var4.replaceWithBlackstone) {
            var7.addProcessor(BlackstoneReplaceProcessor.INSTANCE);
        }
        return var7;
    }

    private static ProcessorRule getLavaProcessorRule(VerticalPlacement var0, Properties var1) {
        if (var0 == VerticalPlacement.ON_OCEAN_FLOOR) {
            return RuinedPortalPiece.getBlockReplaceRule(Blocks.LAVA, Blocks.MAGMA_BLOCK);
        }
        if (var1.cold) {
            return RuinedPortalPiece.getBlockReplaceRule(Blocks.LAVA, Blocks.NETHERRACK);
        }
        return RuinedPortalPiece.getBlockReplaceRule(Blocks.LAVA, 0.2f, Blocks.MAGMA_BLOCK);
    }

    @Override
    public void postProcess(WorldGenLevel var0, StructureManager var1, ChunkGenerator var22, RandomSource var3, BoundingBox var4, ChunkPos var5, BlockPos var6) {
        BoundingBox var7 = this.template.getBoundingBox(this.placeSettings, this.templatePosition);
        if (!var4.isInside(var7.getCenter())) {
            return;
        }
        var4.encapsulate(var7);
        super.postProcess(var0, var1, var22, var3, var4, var5, var6);
        this.spreadNetherrack(var3, var0);
        this.addNetherrackDripColumnsBelowPortal(var3, var0);
        if (this.properties.vines || this.properties.overgrown) {
            BlockPos.betweenClosedStream(this.getBoundingBox()).forEach(var2 -> {
                if (this.properties.vines) {
                    this.maybeAddVines(var3, var0, (BlockPos)var2);
                }
                if (this.properties.overgrown) {
                    this.maybeAddLeavesAbove(var3, var0, (BlockPos)var2);
                }
            });
        }
    }

    @Override
    protected void handleDataMarker(String var0, BlockPos var1, ServerLevelAccessor var2, RandomSource var3, BoundingBox var4) {
    }

    private void maybeAddVines(RandomSource var0, LevelAccessor var1, BlockPos var2) {
        BlockState var3 = var1.getBlockState(var2);
        if (var3.isAir() || var3.is(Blocks.VINE)) {
            return;
        }
        Direction var4 = RuinedPortalPiece.getRandomHorizontalDirection(var0);
        BlockPos var5 = var2.relative(var4);
        BlockState var6 = var1.getBlockState(var5);
        if (!var6.isAir()) {
            return;
        }
        if (!Block.isFaceFull(var3.getCollisionShape(var1, var2), var4)) {
            return;
        }
        BooleanProperty var7 = VineBlock.getPropertyForFace(var4.getOpposite());
        var1.setBlock(var5, (BlockState)Blocks.VINE.defaultBlockState().setValue(var7, true), 3);
    }

    private void maybeAddLeavesAbove(RandomSource var0, LevelAccessor var1, BlockPos var2) {
        if (var0.nextFloat() < 0.5f && var1.getBlockState(var2).is(Blocks.NETHERRACK) && var1.getBlockState(var2.above()).isAir()) {
            var1.setBlock(var2.above(), (BlockState)Blocks.JUNGLE_LEAVES.defaultBlockState().setValue(LeavesBlock.PERSISTENT, true), 3);
        }
    }

    private void addNetherrackDripColumnsBelowPortal(RandomSource var0, LevelAccessor var1) {
        for (int var2 = this.boundingBox.minX() + 1; var2 < this.boundingBox.maxX(); ++var2) {
            for (int var3 = this.boundingBox.minZ() + 1; var3 < this.boundingBox.maxZ(); ++var3) {
                BlockPos var4 = new BlockPos(var2, this.boundingBox.minY(), var3);
                if (!var1.getBlockState(var4).is(Blocks.NETHERRACK)) continue;
                this.addNetherrackDripColumn(var0, var1, var4.below());
            }
        }
    }

    private void addNetherrackDripColumn(RandomSource var0, LevelAccessor var1, BlockPos var2) {
        BlockPos.MutableBlockPos var3 = var2.mutable();
        this.placeNetherrackOrMagma(var0, var1, var3);
        for (int var4 = 8; var4 > 0 && var0.nextFloat() < 0.5f; --var4) {
            var3.move(Direction.DOWN);
            this.placeNetherrackOrMagma(var0, var1, var3);
        }
    }

    private void spreadNetherrack(RandomSource var0, LevelAccessor var1) {
        boolean var2 = this.verticalPlacement == VerticalPlacement.ON_LAND_SURFACE || this.verticalPlacement == VerticalPlacement.ON_OCEAN_FLOOR;
        BlockPos var3 = this.boundingBox.getCenter();
        int var4 = var3.getX();
        int var5 = var3.getZ();
        float[] var6 = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.9f, 0.9f, 0.8f, 0.7f, 0.6f, 0.4f, 0.2f};
        int var7 = var6.length;
        int var8 = (this.boundingBox.getXSpan() + this.boundingBox.getZSpan()) / 2;
        int var9 = var0.nextInt(Math.max(1, 8 - var8 / 2));
        int var10 = 3;
        BlockPos.MutableBlockPos var11 = BlockPos.ZERO.mutable();
        for (int var12 = var4 - var7; var12 <= var4 + var7; ++var12) {
            for (int var13 = var5 - var7; var13 <= var5 + var7; ++var13) {
                int var14 = Math.abs(var12 - var4) + Math.abs(var13 - var5);
                int var15 = Math.max(0, var14 + var9);
                if (var15 >= var7) continue;
                float var16 = var6[var15];
                if (!(var0.nextDouble() < (double)var16)) continue;
                int var17 = RuinedPortalPiece.getSurfaceY(var1, var12, var13, this.verticalPlacement);
                int var18 = var2 ? var17 : Math.min(this.boundingBox.minY(), var17);
                var11.set(var12, var18, var13);
                if (Math.abs(var18 - this.boundingBox.minY()) > 3 || !this.canBlockBeReplacedByNetherrackOrMagma(var1, var11)) continue;
                this.placeNetherrackOrMagma(var0, var1, var11);
                if (this.properties.overgrown) {
                    this.maybeAddLeavesAbove(var0, var1, var11);
                }
                this.addNetherrackDripColumn(var0, var1, (BlockPos)var11.below());
            }
        }
    }

    private boolean canBlockBeReplacedByNetherrackOrMagma(LevelAccessor var0, BlockPos var1) {
        BlockState var2 = var0.getBlockState(var1);
        return !var2.is(Blocks.AIR) && !var2.is(Blocks.OBSIDIAN) && !var2.is(BlockTags.FEATURES_CANNOT_REPLACE) && (this.verticalPlacement == VerticalPlacement.IN_NETHER || !var2.is(Blocks.LAVA));
    }

    private void placeNetherrackOrMagma(RandomSource var0, LevelAccessor var1, BlockPos var2) {
        if (!this.properties.cold && var0.nextFloat() < 0.07f) {
            var1.setBlock(var2, Blocks.MAGMA_BLOCK.defaultBlockState(), 3);
        } else {
            var1.setBlock(var2, Blocks.NETHERRACK.defaultBlockState(), 3);
        }
    }

    private static int getSurfaceY(LevelAccessor var0, int var1, int var2, VerticalPlacement var3) {
        return var0.getHeight(RuinedPortalPiece.getHeightMapType(var3), var1, var2) - 1;
    }

    public static Heightmap.Types getHeightMapType(VerticalPlacement var0) {
        return var0 == VerticalPlacement.ON_OCEAN_FLOOR ? Heightmap.Types.OCEAN_FLOOR_WG : Heightmap.Types.WORLD_SURFACE_WG;
    }

    private static ProcessorRule getBlockReplaceRule(Block var0, float var1, Block var2) {
        return new ProcessorRule(new RandomBlockMatchTest(var0, var1), AlwaysTrueTest.INSTANCE, var2.defaultBlockState());
    }

    private static ProcessorRule getBlockReplaceRule(Block var0, Block var1) {
        return new ProcessorRule(new BlockMatchTest(var0), AlwaysTrueTest.INSTANCE, var1.defaultBlockState());
    }

    public static enum VerticalPlacement implements StringRepresentable
    {
        ON_LAND_SURFACE("on_land_surface"),
        PARTLY_BURIED("partly_buried"),
        ON_OCEAN_FLOOR("on_ocean_floor"),
        IN_MOUNTAIN("in_mountain"),
        UNDERGROUND("underground"),
        IN_NETHER("in_nether");

        public static final Codec<VerticalPlacement> CODEC;
        private final String name;

        private VerticalPlacement(String var2) {
            this.name = var2;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(VerticalPlacement::values);
        }
    }

    public static class Properties {
        public static final Codec<Properties> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.BOOL.fieldOf("cold").forGetter(var0 -> var0.cold), (App)Codec.FLOAT.fieldOf("mossiness").forGetter(var0 -> Float.valueOf(var0.mossiness)), (App)Codec.BOOL.fieldOf("air_pocket").forGetter(var0 -> var0.airPocket), (App)Codec.BOOL.fieldOf("overgrown").forGetter(var0 -> var0.overgrown), (App)Codec.BOOL.fieldOf("vines").forGetter(var0 -> var0.vines), (App)Codec.BOOL.fieldOf("replace_with_blackstone").forGetter(var0 -> var0.replaceWithBlackstone)).apply((Applicative)var02, Properties::new));
        public boolean cold;
        public float mossiness;
        public boolean airPocket;
        public boolean overgrown;
        public boolean vines;
        public boolean replaceWithBlackstone;

        public Properties() {
        }

        public Properties(boolean var0, float var1, boolean var2, boolean var3, boolean var4, boolean var5) {
            this.cold = var0;
            this.mossiness = var1;
            this.airPocket = var2;
            this.overgrown = var3;
            this.vines = var4;
            this.replaceWithBlackstone = var5;
        }
    }
}

