/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jspecify.annotations.Nullable;

public class BlockAgeProcessor
extends StructureProcessor {
    public static final MapCodec<BlockAgeProcessor> CODEC = Codec.FLOAT.fieldOf("mossiness").xmap(BlockAgeProcessor::new, var0 -> Float.valueOf(var0.mossiness));
    private static final float PROBABILITY_OF_REPLACING_FULL_BLOCK = 0.5f;
    private static final float PROBABILITY_OF_REPLACING_STAIRS = 0.5f;
    private static final float PROBABILITY_OF_REPLACING_OBSIDIAN = 0.15f;
    private static final BlockState[] NON_MOSSY_REPLACEMENTS = new BlockState[]{Blocks.STONE_SLAB.defaultBlockState(), Blocks.STONE_BRICK_SLAB.defaultBlockState()};
    private final float mossiness;

    public BlockAgeProcessor(float var0) {
        this.mossiness = var0;
    }

    @Override
    public @Nullable StructureTemplate.StructureBlockInfo processBlock(LevelReader var0, BlockPos var1, BlockPos var2, StructureTemplate.StructureBlockInfo var3, StructureTemplate.StructureBlockInfo var4, StructurePlaceSettings var5) {
        RandomSource var6 = var5.getRandom(var4.pos());
        BlockState var7 = var4.state();
        BlockPos var8 = var4.pos();
        BlockState var9 = null;
        if (var7.is(Blocks.STONE_BRICKS) || var7.is(Blocks.STONE) || var7.is(Blocks.CHISELED_STONE_BRICKS)) {
            var9 = this.maybeReplaceFullStoneBlock(var6);
        } else if (var7.is(BlockTags.STAIRS)) {
            var9 = this.maybeReplaceStairs(var7, var6);
        } else if (var7.is(BlockTags.SLABS)) {
            var9 = this.maybeReplaceSlab(var7, var6);
        } else if (var7.is(BlockTags.WALLS)) {
            var9 = this.maybeReplaceWall(var7, var6);
        } else if (var7.is(Blocks.OBSIDIAN)) {
            var9 = this.maybeReplaceObsidian(var6);
        }
        if (var9 != null) {
            return new StructureTemplate.StructureBlockInfo(var8, var9, var4.nbt());
        }
        return var4;
    }

    private @Nullable BlockState maybeReplaceFullStoneBlock(RandomSource var0) {
        if (var0.nextFloat() >= 0.5f) {
            return null;
        }
        BlockState[] var1 = new BlockState[]{Blocks.CRACKED_STONE_BRICKS.defaultBlockState(), BlockAgeProcessor.getRandomFacingStairs(var0, Blocks.STONE_BRICK_STAIRS)};
        BlockState[] var2 = new BlockState[]{Blocks.MOSSY_STONE_BRICKS.defaultBlockState(), BlockAgeProcessor.getRandomFacingStairs(var0, Blocks.MOSSY_STONE_BRICK_STAIRS)};
        return this.getRandomBlock(var0, var1, var2);
    }

    private @Nullable BlockState maybeReplaceStairs(BlockState var0, RandomSource var1) {
        if (var1.nextFloat() >= 0.5f) {
            return null;
        }
        BlockState[] var2 = new BlockState[]{Blocks.MOSSY_STONE_BRICK_STAIRS.withPropertiesOf(var0), Blocks.MOSSY_STONE_BRICK_SLAB.defaultBlockState()};
        return this.getRandomBlock(var1, NON_MOSSY_REPLACEMENTS, var2);
    }

    private @Nullable BlockState maybeReplaceSlab(BlockState var0, RandomSource var1) {
        if (var1.nextFloat() < this.mossiness) {
            return Blocks.MOSSY_STONE_BRICK_SLAB.withPropertiesOf(var0);
        }
        return null;
    }

    private @Nullable BlockState maybeReplaceWall(BlockState var0, RandomSource var1) {
        if (var1.nextFloat() < this.mossiness) {
            return Blocks.MOSSY_STONE_BRICK_WALL.withPropertiesOf(var0);
        }
        return null;
    }

    private @Nullable BlockState maybeReplaceObsidian(RandomSource var0) {
        if (var0.nextFloat() < 0.15f) {
            return Blocks.CRYING_OBSIDIAN.defaultBlockState();
        }
        return null;
    }

    private static BlockState getRandomFacingStairs(RandomSource var0, Block var1) {
        return (BlockState)((BlockState)var1.defaultBlockState().setValue(StairBlock.FACING, Direction.Plane.HORIZONTAL.getRandomDirection(var0))).setValue(StairBlock.HALF, Util.getRandom(Half.values(), var0));
    }

    private BlockState getRandomBlock(RandomSource var0, BlockState[] var1, BlockState[] var2) {
        if (var0.nextFloat() < this.mossiness) {
            return BlockAgeProcessor.getRandomBlock(var0, var2);
        }
        return BlockAgeProcessor.getRandomBlock(var0, var1);
    }

    private static BlockState getRandomBlock(RandomSource var0, BlockState[] var1) {
        return var1[var0.nextInt(var1.length)];
    }

    @Override
    protected StructureProcessorType<?> getType() {
        return StructureProcessorType.BLOCK_AGE;
    }
}

