/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jspecify.annotations.Nullable;

public class StructurePlaceSettings {
    private Mirror mirror = Mirror.NONE;
    private Rotation rotation = Rotation.NONE;
    private BlockPos rotationPivot = BlockPos.ZERO;
    private boolean ignoreEntities;
    private @Nullable BoundingBox boundingBox;
    private LiquidSettings liquidSettings = LiquidSettings.APPLY_WATERLOGGING;
    private @Nullable RandomSource random;
    public int palette = -1;
    private final List<StructureProcessor> processors = Lists.newArrayList();
    private boolean knownShape;
    private boolean finalizeEntities;

    public StructurePlaceSettings copy() {
        StructurePlaceSettings definedstructureinfo = new StructurePlaceSettings();
        definedstructureinfo.mirror = this.mirror;
        definedstructureinfo.rotation = this.rotation;
        definedstructureinfo.rotationPivot = this.rotationPivot;
        definedstructureinfo.ignoreEntities = this.ignoreEntities;
        definedstructureinfo.boundingBox = this.boundingBox;
        definedstructureinfo.liquidSettings = this.liquidSettings;
        definedstructureinfo.random = this.random;
        definedstructureinfo.palette = this.palette;
        definedstructureinfo.processors.addAll(this.processors);
        definedstructureinfo.knownShape = this.knownShape;
        definedstructureinfo.finalizeEntities = this.finalizeEntities;
        return definedstructureinfo;
    }

    public StructurePlaceSettings setMirror(Mirror enumblockmirror) {
        this.mirror = enumblockmirror;
        return this;
    }

    public StructurePlaceSettings setRotation(Rotation enumblockrotation) {
        this.rotation = enumblockrotation;
        return this;
    }

    public StructurePlaceSettings setRotationPivot(BlockPos blockposition) {
        this.rotationPivot = blockposition;
        return this;
    }

    public StructurePlaceSettings setIgnoreEntities(boolean flag) {
        this.ignoreEntities = flag;
        return this;
    }

    public StructurePlaceSettings setBoundingBox(BoundingBox structureboundingbox) {
        this.boundingBox = structureboundingbox;
        return this;
    }

    public StructurePlaceSettings setRandom(@Nullable RandomSource randomsource) {
        this.random = randomsource;
        return this;
    }

    public StructurePlaceSettings setLiquidSettings(LiquidSettings liquidsettings) {
        this.liquidSettings = liquidsettings;
        return this;
    }

    public StructurePlaceSettings setKnownShape(boolean flag) {
        this.knownShape = flag;
        return this;
    }

    public StructurePlaceSettings clearProcessors() {
        this.processors.clear();
        return this;
    }

    public StructurePlaceSettings addProcessor(StructureProcessor definedstructureprocessor) {
        this.processors.add(definedstructureprocessor);
        return this;
    }

    public StructurePlaceSettings popProcessor(StructureProcessor definedstructureprocessor) {
        this.processors.remove(definedstructureprocessor);
        return this;
    }

    public Mirror getMirror() {
        return this.mirror;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public BlockPos getRotationPivot() {
        return this.rotationPivot;
    }

    public RandomSource getRandom(@Nullable BlockPos blockposition) {
        return this.random != null ? this.random : (blockposition == null ? RandomSource.create(Util.getMillis()) : RandomSource.create(Mth.getSeed(blockposition)));
    }

    public boolean isIgnoreEntities() {
        return this.ignoreEntities;
    }

    public @Nullable BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public boolean getKnownShape() {
        return this.knownShape;
    }

    public List<StructureProcessor> getProcessors() {
        return this.processors;
    }

    public boolean shouldApplyWaterlogging() {
        return this.liquidSettings == LiquidSettings.APPLY_WATERLOGGING;
    }

    public StructureTemplate.Palette getRandomPalette(List<StructureTemplate.Palette> list, @Nullable BlockPos blockposition) {
        int i = list.size();
        if (i == 0) {
            throw new IllegalStateException("No palettes");
        }
        if (this.palette >= 0) {
            if (this.palette >= i) {
                throw new IllegalArgumentException("Palette index out of bounds. Got " + this.palette + " where there are only " + i + " palettes available.");
            }
            return list.get(this.palette);
        }
        return list.get(this.getRandom(blockposition).nextInt(i));
    }

    public StructurePlaceSettings setFinalizeEntities(boolean flag) {
        this.finalizeEntities = flag;
        return this;
    }

    public boolean shouldFinalizeEntities() {
        return this.finalizeEntities;
    }
}

