/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.Target;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jspecify.annotations.Nullable;

public class WalkNodeEvaluator
extends NodeEvaluator {
    public static final double SPACE_BETWEEN_WALL_POSTS = 0.5;
    private static final double DEFAULT_MOB_JUMP_HEIGHT = 1.125;
    private final Long2ObjectMap<PathType> pathTypesByPosCacheByMob = new Long2ObjectOpenHashMap();
    private final Object2BooleanMap<AABB> collisionCache = new Object2BooleanOpenHashMap();
    private final Node[] reusableNeighbors = new Node[Direction.Plane.HORIZONTAL.length()];

    @Override
    public void prepare(PathNavigationRegion var0, Mob var1) {
        super.prepare(var0, var1);
        var1.onPathfindingStart();
    }

    @Override
    public void done() {
        this.mob.onPathfindingDone();
        this.pathTypesByPosCacheByMob.clear();
        this.collisionCache.clear();
        super.done();
    }

    @Override
    public Node getStart() {
        Object var3;
        BlockPos.MutableBlockPos var1 = new BlockPos.MutableBlockPos();
        int var0 = this.mob.getBlockY();
        BlockState var2 = this.currentContext.getBlockState(var1.set(this.mob.getX(), (double)var0, this.mob.getZ()));
        if (this.mob.canStandOnFluid(var2.getFluidState())) {
            while (this.mob.canStandOnFluid(var2.getFluidState())) {
                var2 = this.currentContext.getBlockState(var1.set(this.mob.getX(), (double)(++var0), this.mob.getZ()));
            }
            --var0;
        } else if (this.canFloat() && this.mob.isInWater()) {
            while (var2.is(Blocks.WATER) || var2.getFluidState() == Fluids.WATER.getSource(false)) {
                var2 = this.currentContext.getBlockState(var1.set(this.mob.getX(), (double)(++var0), this.mob.getZ()));
            }
            --var0;
        } else if (this.mob.onGround()) {
            var0 = Mth.floor(this.mob.getY() + 0.5);
        } else {
            var1.set(this.mob.getX(), this.mob.getY() + 1.0, this.mob.getZ());
            while (var1.getY() > this.currentContext.level().getMinY()) {
                var0 = var1.getY();
                var1.setY(var1.getY() - 1);
                var3 = this.currentContext.getBlockState(var1);
                if (((BlockBehaviour.BlockStateBase)var3).isAir() || ((BlockBehaviour.BlockStateBase)var3).isPathfindable(PathComputationType.LAND)) continue;
                break;
            }
        }
        var3 = this.mob.blockPosition();
        if (!this.canStartAt(var1.set(((Vec3i)var3).getX(), var0, ((Vec3i)var3).getZ()))) {
            AABB var4 = this.mob.getBoundingBox();
            if (this.canStartAt(var1.set(var4.minX, (double)var0, var4.minZ)) || this.canStartAt(var1.set(var4.minX, (double)var0, var4.maxZ)) || this.canStartAt(var1.set(var4.maxX, (double)var0, var4.minZ)) || this.canStartAt(var1.set(var4.maxX, (double)var0, var4.maxZ))) {
                return this.getStartNode(var1);
            }
        }
        return this.getStartNode(new BlockPos(((Vec3i)var3).getX(), var0, ((Vec3i)var3).getZ()));
    }

    protected Node getStartNode(BlockPos var0) {
        Node var1 = this.getNode(var0);
        var1.type = this.getCachedPathType(var1.x, var1.y, var1.z);
        var1.costMalus = this.mob.getPathfindingMalus(var1.type);
        return var1;
    }

    protected boolean canStartAt(BlockPos var0) {
        PathType var1 = this.getCachedPathType(var0.getX(), var0.getY(), var0.getZ());
        return var1 != PathType.OPEN && this.mob.getPathfindingMalus(var1) >= 0.0f;
    }

    @Override
    public Target getTarget(double var0, double var2, double var4) {
        return this.getTargetNodeAt(var0, var2, var4);
    }

    @Override
    public int getNeighbors(Node[] var0, Node var1) {
        Object var10;
        int var2 = 0;
        int var3 = 0;
        PathType var4 = this.getCachedPathType(var1.x, var1.y + 1, var1.z);
        PathType var5 = this.getCachedPathType(var1.x, var1.y, var1.z);
        if (this.mob.getPathfindingMalus(var4) >= 0.0f && var5 != PathType.STICKY_HONEY) {
            var3 = Mth.floor(Math.max(1.0f, this.mob.maxUpStep()));
        }
        double var6 = this.getFloorLevel(new BlockPos(var1.x, var1.y, var1.z));
        for (Direction var9 : Direction.Plane.HORIZONTAL) {
            this.reusableNeighbors[var9.get2DDataValue()] = var10 = this.findAcceptedNode(var1.x + var9.getStepX(), var1.y, var1.z + var9.getStepZ(), var3, var6, var9, var5);
            if (!this.isNeighborValid((Node)var10, var1)) continue;
            var0[var2++] = var10;
        }
        for (Direction var9 : Direction.Plane.HORIZONTAL) {
            Node var11;
            var10 = var9.getClockWise();
            if (!this.isDiagonalValid(var1, this.reusableNeighbors[var9.get2DDataValue()], this.reusableNeighbors[((Direction)var10).get2DDataValue()]) || !this.isDiagonalValid(var11 = this.findAcceptedNode(var1.x + var9.getStepX() + ((Direction)var10).getStepX(), var1.y, var1.z + var9.getStepZ() + ((Direction)var10).getStepZ(), var3, var6, var9, var5))) continue;
            var0[var2++] = var11;
        }
        return var2;
    }

    protected boolean isNeighborValid(@Nullable Node var0, Node var1) {
        return var0 != null && !var0.closed && (var0.costMalus >= 0.0f || var1.costMalus < 0.0f);
    }

    protected boolean isDiagonalValid(Node var0, @Nullable Node var1, @Nullable Node var2) {
        if (var2 == null || var1 == null || var2.y > var0.y || var1.y > var0.y) {
            return false;
        }
        if (var1.type == PathType.WALKABLE_DOOR || var2.type == PathType.WALKABLE_DOOR) {
            return false;
        }
        boolean var3 = var2.type == PathType.FENCE && var1.type == PathType.FENCE && (double)this.mob.getBbWidth() < 0.5;
        return (var2.y < var0.y || var2.costMalus >= 0.0f || var3) && (var1.y < var0.y || var1.costMalus >= 0.0f || var3);
    }

    protected boolean isDiagonalValid(@Nullable Node var0) {
        if (var0 == null || var0.closed) {
            return false;
        }
        if (var0.type == PathType.WALKABLE_DOOR) {
            return false;
        }
        return var0.costMalus >= 0.0f;
    }

    private static boolean doesBlockHavePartialCollision(PathType var0) {
        return var0 == PathType.FENCE || var0 == PathType.DOOR_WOOD_CLOSED || var0 == PathType.DOOR_IRON_CLOSED;
    }

    private boolean canReachWithoutCollision(Node var0) {
        AABB var1 = this.mob.getBoundingBox();
        Vec3 var2 = new Vec3((double)var0.x - this.mob.getX() + var1.getXsize() / 2.0, (double)var0.y - this.mob.getY() + var1.getYsize() / 2.0, (double)var0.z - this.mob.getZ() + var1.getZsize() / 2.0);
        int var3 = Mth.ceil(var2.length() / var1.getSize());
        var2 = var2.scale(1.0f / (float)var3);
        for (int var4 = 1; var4 <= var3; ++var4) {
            if (!this.hasCollisions(var1 = var1.move(var2))) continue;
            return false;
        }
        return true;
    }

    protected double getFloorLevel(BlockPos var0) {
        CollisionGetter var1 = this.currentContext.level();
        if ((this.canFloat() || this.isAmphibious()) && var1.getFluidState(var0).is(FluidTags.WATER)) {
            return (double)var0.getY() + 0.5;
        }
        return WalkNodeEvaluator.getFloorLevel(var1, var0);
    }

    public static double getFloorLevel(BlockGetter var0, BlockPos var1) {
        BlockPos var2 = var1.below();
        VoxelShape var3 = var0.getBlockState(var2).getCollisionShape(var0, var2);
        return (double)var2.getY() + (var3.isEmpty() ? 0.0 : var3.max(Direction.Axis.Y));
    }

    protected boolean isAmphibious() {
        return false;
    }

    protected @Nullable Node findAcceptedNode(int var0, int var1, int var2, int var3, double var4, Direction var6, PathType var7) {
        Node var8 = null;
        BlockPos.MutableBlockPos var9 = new BlockPos.MutableBlockPos();
        double var10 = this.getFloorLevel(var9.set(var0, var1, var2));
        if (var10 - var4 > this.getMobJumpHeight()) {
            return null;
        }
        PathType var12 = this.getCachedPathType(var0, var1, var2);
        float var13 = this.mob.getPathfindingMalus(var12);
        if (var13 >= 0.0f) {
            var8 = this.getNodeAndUpdateCostToMax(var0, var1, var2, var12, var13);
        }
        if (WalkNodeEvaluator.doesBlockHavePartialCollision(var7) && var8 != null && var8.costMalus >= 0.0f && !this.canReachWithoutCollision(var8)) {
            var8 = null;
        }
        if (var12 == PathType.WALKABLE || this.isAmphibious() && var12 == PathType.WATER) {
            return var8;
        }
        if ((var8 == null || var8.costMalus < 0.0f) && var3 > 0 && (var12 != PathType.FENCE || this.canWalkOverFences()) && var12 != PathType.UNPASSABLE_RAIL && var12 != PathType.TRAPDOOR && var12 != PathType.POWDER_SNOW) {
            var8 = this.tryJumpOn(var0, var1, var2, var3, var4, var6, var7, var9);
        } else if (!this.isAmphibious() && var12 == PathType.WATER && !this.canFloat()) {
            var8 = this.tryFindFirstNonWaterBelow(var0, var1, var2, var8);
        } else if (var12 == PathType.OPEN) {
            var8 = this.tryFindFirstGroundNodeBelow(var0, var1, var2);
        } else if (WalkNodeEvaluator.doesBlockHavePartialCollision(var12) && var8 == null) {
            var8 = this.getClosedNode(var0, var1, var2, var12);
        }
        return var8;
    }

    private double getMobJumpHeight() {
        return Math.max(1.125, (double)this.mob.maxUpStep());
    }

    private Node getNodeAndUpdateCostToMax(int var0, int var1, int var2, PathType var3, float var4) {
        Node var5 = this.getNode(var0, var1, var2);
        var5.type = var3;
        var5.costMalus = Math.max(var5.costMalus, var4);
        return var5;
    }

    private Node getBlockedNode(int var0, int var1, int var2) {
        Node var3 = this.getNode(var0, var1, var2);
        var3.type = PathType.BLOCKED;
        var3.costMalus = -1.0f;
        return var3;
    }

    private Node getClosedNode(int var0, int var1, int var2, PathType var3) {
        Node var4 = this.getNode(var0, var1, var2);
        var4.closed = true;
        var4.type = var3;
        var4.costMalus = var3.getMalus();
        return var4;
    }

    private @Nullable Node tryJumpOn(int var0, int var1, int var2, int var3, double var4, Direction var6, PathType var7, BlockPos.MutableBlockPos var8) {
        Node var9 = this.findAcceptedNode(var0, var1 + 1, var2, var3 - 1, var4, var6, var7);
        if (var9 == null) {
            return null;
        }
        if (this.mob.getBbWidth() >= 1.0f) {
            return var9;
        }
        if (var9.type != PathType.OPEN && var9.type != PathType.WALKABLE) {
            return var9;
        }
        double var10 = (double)(var0 - var6.getStepX()) + 0.5;
        double var12 = (double)(var2 - var6.getStepZ()) + 0.5;
        double var14 = (double)this.mob.getBbWidth() / 2.0;
        AABB var16 = new AABB(var10 - var14, this.getFloorLevel(var8.set(var10, (double)(var1 + 1), var12)) + 0.001, var12 - var14, var10 + var14, (double)this.mob.getBbHeight() + this.getFloorLevel(var8.set((double)var9.x, (double)var9.y, (double)var9.z)) - 0.002, var12 + var14);
        return this.hasCollisions(var16) ? null : var9;
    }

    private @Nullable Node tryFindFirstNonWaterBelow(int var0, int var1, int var2, @Nullable Node var3) {
        --var1;
        while (var1 > this.mob.level().getMinY()) {
            PathType var4 = this.getCachedPathType(var0, var1, var2);
            if (var4 != PathType.WATER) {
                return var3;
            }
            var3 = this.getNodeAndUpdateCostToMax(var0, var1, var2, var4, this.mob.getPathfindingMalus(var4));
            --var1;
        }
        return var3;
    }

    private Node tryFindFirstGroundNodeBelow(int var0, int var1, int var2) {
        for (int var3 = var1 - 1; var3 >= this.mob.level().getMinY(); --var3) {
            if (var1 - var3 > this.mob.getMaxFallDistance()) {
                return this.getBlockedNode(var0, var3, var2);
            }
            PathType var4 = this.getCachedPathType(var0, var3, var2);
            float var5 = this.mob.getPathfindingMalus(var4);
            if (var4 == PathType.OPEN) continue;
            if (var5 >= 0.0f) {
                return this.getNodeAndUpdateCostToMax(var0, var3, var2, var4, var5);
            }
            return this.getBlockedNode(var0, var3, var2);
        }
        return this.getBlockedNode(var0, var1, var2);
    }

    private boolean hasCollisions(AABB var0) {
        return this.collisionCache.computeIfAbsent((Object)var0, var1 -> !this.currentContext.level().noCollision(this.mob, var0));
    }

    protected PathType getCachedPathType(int var0, int var1, int var2) {
        return (PathType)((Object)this.pathTypesByPosCacheByMob.computeIfAbsent(BlockPos.asLong(var0, var1, var2), var3 -> this.getPathTypeOfMob(this.currentContext, var0, var1, var2, this.mob)));
    }

    @Override
    public PathType getPathTypeOfMob(PathfindingContext var0, int var1, int var2, int var3, Mob var4) {
        Set<PathType> var5 = this.getPathTypeWithinMobBB(var0, var1, var2, var3);
        if (var5.contains((Object)PathType.FENCE)) {
            return PathType.FENCE;
        }
        if (var5.contains((Object)PathType.UNPASSABLE_RAIL)) {
            return PathType.UNPASSABLE_RAIL;
        }
        PathType var6 = PathType.BLOCKED;
        for (PathType var8 : var5) {
            if (var4.getPathfindingMalus(var8) < 0.0f) {
                return var8;
            }
            if (!(var4.getPathfindingMalus(var8) >= var4.getPathfindingMalus(var6))) continue;
            var6 = var8;
        }
        if (this.entityWidth <= 1 && var6 != PathType.OPEN && var4.getPathfindingMalus(var6) == 0.0f && this.getPathType(var0, var1, var2, var3) == PathType.OPEN) {
            return PathType.OPEN;
        }
        return var6;
    }

    public Set<PathType> getPathTypeWithinMobBB(PathfindingContext var0, int var1, int var2, int var3) {
        EnumSet<PathType> var4 = EnumSet.noneOf(PathType.class);
        for (int var5 = 0; var5 < this.entityWidth; ++var5) {
            for (int var6 = 0; var6 < this.entityHeight; ++var6) {
                for (int var7 = 0; var7 < this.entityDepth; ++var7) {
                    int var8 = var5 + var1;
                    int var9 = var6 + var2;
                    int var10 = var7 + var3;
                    PathType var11 = this.getPathType(var0, var8, var9, var10);
                    BlockPos var12 = this.mob.blockPosition();
                    boolean var13 = this.canPassDoors();
                    if (var11 == PathType.DOOR_WOOD_CLOSED && this.canOpenDoors() && var13) {
                        var11 = PathType.WALKABLE_DOOR;
                    }
                    if (var11 == PathType.DOOR_OPEN && !var13) {
                        var11 = PathType.BLOCKED;
                    }
                    if (var11 == PathType.RAIL && this.getPathType(var0, var12.getX(), var12.getY(), var12.getZ()) != PathType.RAIL && this.getPathType(var0, var12.getX(), var12.getY() - 1, var12.getZ()) != PathType.RAIL) {
                        var11 = PathType.UNPASSABLE_RAIL;
                    }
                    var4.add(var11);
                }
            }
        }
        return var4;
    }

    @Override
    public PathType getPathType(PathfindingContext var0, int var1, int var2, int var3) {
        return WalkNodeEvaluator.getPathTypeStatic(var0, new BlockPos.MutableBlockPos(var1, var2, var3));
    }

    public static PathType getPathTypeStatic(Mob var0, BlockPos var1) {
        return WalkNodeEvaluator.getPathTypeStatic(new PathfindingContext(var0.level(), var0), var1.mutable());
    }

    public static PathType getPathTypeStatic(PathfindingContext var0, BlockPos.MutableBlockPos var1) {
        int var4;
        int var3;
        int var2 = var1.getX();
        PathType var5 = var0.getPathTypeFromState(var2, var3 = var1.getY(), var4 = var1.getZ());
        if (var5 != PathType.OPEN || var3 < var0.level().getMinY() + 1) {
            return var5;
        }
        return switch (var0.getPathTypeFromState(var2, var3 - 1, var4)) {
            case PathType.OPEN, PathType.WATER, PathType.LAVA, PathType.WALKABLE -> PathType.OPEN;
            case PathType.DAMAGE_FIRE -> PathType.DAMAGE_FIRE;
            case PathType.DAMAGE_OTHER -> PathType.DAMAGE_OTHER;
            case PathType.STICKY_HONEY -> PathType.STICKY_HONEY;
            case PathType.POWDER_SNOW -> PathType.DANGER_POWDER_SNOW;
            case PathType.DAMAGE_CAUTIOUS -> PathType.DAMAGE_CAUTIOUS;
            case PathType.TRAPDOOR -> PathType.DANGER_TRAPDOOR;
            default -> WalkNodeEvaluator.checkNeighbourBlocks(var0, var2, var3, var4, PathType.WALKABLE);
        };
    }

    public static PathType checkNeighbourBlocks(PathfindingContext var0, int var1, int var2, int var3, PathType var4) {
        for (int var5 = -1; var5 <= 1; ++var5) {
            for (int var6 = -1; var6 <= 1; ++var6) {
                for (int var7 = -1; var7 <= 1; ++var7) {
                    if (var5 == 0 && var7 == 0) continue;
                    PathType var8 = var0.getPathTypeFromState(var1 + var5, var2 + var6, var3 + var7);
                    if (var8 == PathType.DAMAGE_OTHER) {
                        return PathType.DANGER_OTHER;
                    }
                    if (var8 == PathType.DAMAGE_FIRE || var8 == PathType.LAVA) {
                        return PathType.DANGER_FIRE;
                    }
                    if (var8 == PathType.WATER) {
                        return PathType.WATER_BORDER;
                    }
                    if (var8 != PathType.DAMAGE_CAUTIOUS) continue;
                    return PathType.DAMAGE_CAUTIOUS;
                }
            }
        }
        return var4;
    }

    protected static PathType getPathTypeFromState(BlockGetter var0, BlockPos var1) {
        BlockState var2 = var0.getBlockState(var1);
        Block var3 = var2.getBlock();
        if (var2.isAir()) {
            return PathType.OPEN;
        }
        if (var2.is(BlockTags.TRAPDOORS) || var2.is(Blocks.LILY_PAD) || var2.is(Blocks.BIG_DRIPLEAF)) {
            return PathType.TRAPDOOR;
        }
        if (var2.is(Blocks.POWDER_SNOW)) {
            return PathType.POWDER_SNOW;
        }
        if (var2.is(Blocks.CACTUS) || var2.is(Blocks.SWEET_BERRY_BUSH)) {
            return PathType.DAMAGE_OTHER;
        }
        if (var2.is(Blocks.HONEY_BLOCK)) {
            return PathType.STICKY_HONEY;
        }
        if (var2.is(Blocks.COCOA)) {
            return PathType.COCOA;
        }
        if (var2.is(Blocks.WITHER_ROSE) || var2.is(Blocks.POINTED_DRIPSTONE)) {
            return PathType.DAMAGE_CAUTIOUS;
        }
        FluidState var4 = var2.getFluidState();
        if (var4.is(FluidTags.LAVA)) {
            return PathType.LAVA;
        }
        if (WalkNodeEvaluator.isBurningBlock(var2)) {
            return PathType.DAMAGE_FIRE;
        }
        if (var3 instanceof DoorBlock) {
            DoorBlock var5 = (DoorBlock)var3;
            if (var2.getValue(DoorBlock.OPEN).booleanValue()) {
                return PathType.DOOR_OPEN;
            }
            return var5.type().canOpenByHand() ? PathType.DOOR_WOOD_CLOSED : PathType.DOOR_IRON_CLOSED;
        }
        if (var3 instanceof BaseRailBlock) {
            return PathType.RAIL;
        }
        if (var3 instanceof LeavesBlock) {
            return PathType.LEAVES;
        }
        if (var2.is(BlockTags.FENCES) || var2.is(BlockTags.WALLS) || var3 instanceof FenceGateBlock && !var2.getValue(FenceGateBlock.OPEN).booleanValue()) {
            return PathType.FENCE;
        }
        if (!var2.isPathfindable(PathComputationType.LAND)) {
            return PathType.BLOCKED;
        }
        if (var4.is(FluidTags.WATER)) {
            return PathType.WATER;
        }
        return PathType.OPEN;
    }
}

