/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.redstone;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.redstone.Orientation;
import org.jspecify.annotations.Nullable;

public abstract class RedstoneWireEvaluator {
    protected final RedStoneWireBlock wireBlock;

    protected RedstoneWireEvaluator(RedStoneWireBlock var0) {
        this.wireBlock = var0;
    }

    public abstract void updatePowerStrength(Level var1, BlockPos var2, BlockState var3, @Nullable Orientation var4, boolean var5);

    protected int getBlockSignal(Level var0, BlockPos var1) {
        return this.wireBlock.getBlockSignal(var0, var1);
    }

    protected int getWireSignal(BlockPos var0, BlockState var1) {
        return var1.is(this.wireBlock) ? var1.getValue(RedStoneWireBlock.POWER) : 0;
    }

    protected int getIncomingWireSignal(Level var0, BlockPos var1) {
        int var2 = 0;
        for (Direction var4 : Direction.Plane.HORIZONTAL) {
            BlockPos var8;
            BlockPos var5 = var1.relative(var4);
            BlockState var6 = var0.getBlockState(var5);
            var2 = Math.max(var2, this.getWireSignal(var5, var6));
            BlockPos var7 = var1.above();
            if (var6.isRedstoneConductor(var0, var5) && !var0.getBlockState(var7).isRedstoneConductor(var0, var7)) {
                var8 = var5.above();
                var2 = Math.max(var2, this.getWireSignal(var8, var0.getBlockState(var8)));
                continue;
            }
            if (var6.isRedstoneConductor(var0, var5)) continue;
            var8 = var5.below();
            var2 = Math.max(var2, this.getWireSignal(var8, var0.getBlockState(var8)));
        }
        return Math.max(0, var2 - 1);
    }
}

