/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.Identifier;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jspecify.annotations.Nullable;

public class CommandStorage {
    private static final String ID_PREFIX = "command_storage_";
    private final Map<String, Container> namespaces = new HashMap<String, Container>();
    private final DimensionDataStorage storage;

    public CommandStorage(DimensionDataStorage var0) {
        this.storage = var0;
    }

    public CompoundTag get(Identifier var0) {
        Container var1 = this.getContainer(var0.getNamespace());
        if (var1 != null) {
            return var1.get(var0.getPath());
        }
        return new CompoundTag();
    }

    private @Nullable Container getContainer(String var0) {
        Container var1 = this.namespaces.get(var0);
        if (var1 != null) {
            return var1;
        }
        Container var2 = this.storage.get(Container.type(var0));
        if (var2 != null) {
            this.namespaces.put(var0, var2);
        }
        return var2;
    }

    private Container getOrCreateContainer(String var0) {
        Container var1 = this.namespaces.get(var0);
        if (var1 != null) {
            return var1;
        }
        Container var2 = this.storage.computeIfAbsent(Container.type(var0));
        this.namespaces.put(var0, var2);
        return var2;
    }

    public void set(Identifier var0, CompoundTag var1) {
        this.getOrCreateContainer(var0.getNamespace()).put(var0.getPath(), var1);
    }

    public Stream<Identifier> keys() {
        return this.namespaces.entrySet().stream().flatMap(var0 -> ((Container)var0.getValue()).getKeys((String)var0.getKey()));
    }

    static String createId(String var0) {
        return ID_PREFIX + var0;
    }

    static class Container
    extends SavedData {
        public static final Codec<Container> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.unboundedMap(ExtraCodecs.RESOURCE_PATH_CODEC, CompoundTag.CODEC).fieldOf("contents").forGetter(var0 -> var0.storage)).apply((Applicative)var02, Container::new));
        private final Map<String, CompoundTag> storage;

        private Container(Map<String, CompoundTag> var0) {
            this.storage = new HashMap<String, CompoundTag>(var0);
        }

        private Container() {
            this(new HashMap<String, CompoundTag>());
        }

        public static SavedDataType<Container> type(String var0) {
            return new SavedDataType<Container>(CommandStorage.createId(var0), Container::new, CODEC, DataFixTypes.SAVED_DATA_COMMAND_STORAGE);
        }

        public CompoundTag get(String var0) {
            CompoundTag var1 = this.storage.get(var0);
            return var1 != null ? var1 : new CompoundTag();
        }

        public void put(String var0, CompoundTag var1) {
            if (var1.isEmpty()) {
                this.storage.remove(var0);
            } else {
                this.storage.put(var0, var1);
            }
            this.setDirty();
        }

        public Stream<Identifier> getKeys(String var0) {
            return this.storage.keySet().stream().map(var1 -> Identifier.fromNamespaceAndPath(var0, var1));
        }
    }
}

