/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.mojang.serialization.Codec;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.loot.LootContextUser;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.bukkit.craftbukkit.v1_21_R7.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftNamespacedKey;

public record LootDataType<T>(ResourceKey<Registry<T>> registryKey, Codec<T> codec, Validator<T> validator) {
    public static final LootDataType<LootItemCondition> PREDICATE = new LootDataType<LootItemCondition>(Registries.PREDICATE, LootItemCondition.DIRECT_CODEC, LootDataType.createSimpleValidator());
    public static final LootDataType<LootItemFunction> MODIFIER = new LootDataType<LootItemFunction>(Registries.ITEM_MODIFIER, LootItemFunctions.ROOT_CODEC, LootDataType.createSimpleValidator());
    public static final LootDataType<LootTable> TABLE = new LootDataType<LootTable>(Registries.LOOT_TABLE, LootTable.DIRECT_CODEC, LootDataType.createLootTableValidator());

    public void runValidation(ValidationContext lootcollector, ResourceKey<T> resourcekey, T t0) {
        this.validator.run(lootcollector, resourcekey, t0);
    }

    public static Stream<LootDataType<?>> values() {
        return Stream.of(PREDICATE, MODIFIER, TABLE);
    }

    private static <T extends LootContextUser> Validator<T> createSimpleValidator() {
        return (lootcollector, resourcekey, lootitemuser) -> lootitemuser.validate(lootcollector.enterElement(new ProblemReporter.RootElementPathElement(resourcekey), resourcekey));
    }

    private static Validator<LootTable> createLootTableValidator() {
        return (lootcollector, resourcekey, loottable) -> {
            loottable.validate(lootcollector.setContextKeySet(loottable.getParamSet()).enterElement(new ProblemReporter.RootElementPathElement(resourcekey), resourcekey));
            loottable.craftLootTable = new CraftLootTable(CraftNamespacedKey.fromMinecraft(resourcekey.identifier()), (LootTable)loottable);
        };
    }

    @FunctionalInterface
    public static interface Validator<T> {
        public void run(ValidationContext var1, ResourceKey<T> var2, T var3);
    }
}

