/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.context.ContextKey;
import net.minecraft.util.context.ContextKeySet;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.item.ItemStack;
import org.jspecify.annotations.Nullable;

public class LootParams {
    private final ServerLevel level;
    private final ContextMap params;
    private final Map<Identifier, DynamicDrop> dynamicDrops;
    private final float luck;

    public LootParams(ServerLevel var0, ContextMap var1, Map<Identifier, DynamicDrop> var2, float var3) {
        this.level = var0;
        this.params = var1;
        this.dynamicDrops = var2;
        this.luck = var3;
    }

    public ServerLevel getLevel() {
        return this.level;
    }

    public ContextMap contextMap() {
        return this.params;
    }

    public void addDynamicDrops(Identifier var0, Consumer<ItemStack> var1) {
        DynamicDrop var2 = this.dynamicDrops.get(var0);
        if (var2 != null) {
            var2.add(var1);
        }
    }

    public float getLuck() {
        return this.luck;
    }

    @FunctionalInterface
    public static interface DynamicDrop {
        public void add(Consumer<ItemStack> var1);
    }

    public static class Builder {
        private final ServerLevel level;
        private final ContextMap.Builder params = new ContextMap.Builder();
        private final Map<Identifier, DynamicDrop> dynamicDrops = Maps.newHashMap();
        private float luck;

        public Builder(ServerLevel var0) {
            this.level = var0;
        }

        public ServerLevel getLevel() {
            return this.level;
        }

        public <T> Builder withParameter(ContextKey<T> var0, T var1) {
            this.params.withParameter(var0, var1);
            return this;
        }

        public <T> Builder withOptionalParameter(ContextKey<T> var0, @Nullable T var1) {
            this.params.withOptionalParameter(var0, var1);
            return this;
        }

        public <T> T getParameter(ContextKey<T> var0) {
            return this.params.getParameter(var0);
        }

        public <T> @Nullable T getOptionalParameter(ContextKey<T> var0) {
            return this.params.getOptionalParameter(var0);
        }

        public Builder withDynamicDrop(Identifier var0, DynamicDrop var1) {
            DynamicDrop var2 = this.dynamicDrops.put(var0, var1);
            if (var2 != null) {
                throw new IllegalStateException("Duplicated dynamic drop '" + String.valueOf(this.dynamicDrops) + "'");
            }
            return this;
        }

        public Builder withLuck(float var0) {
            this.luck = var0;
            return this;
        }

        public LootParams create(ContextKeySet var0) {
            ContextMap var1 = this.params.create(var0);
            return new LootParams(this.level, var1, this.dynamicDrops, this.luck);
        }
    }
}

