/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntry;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import org.apache.commons.lang3.mutable.MutableInt;

public class LootPool {
    public static final Codec<LootPool> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)LootPoolEntries.CODEC.listOf().fieldOf("entries").forGetter(var0 -> var0.entries), (App)LootItemCondition.DIRECT_CODEC.listOf().optionalFieldOf("conditions", List.of()).forGetter(var0 -> var0.conditions), (App)LootItemFunctions.ROOT_CODEC.listOf().optionalFieldOf("functions", List.of()).forGetter(var0 -> var0.functions), (App)NumberProviders.CODEC.fieldOf("rolls").forGetter(var0 -> var0.rolls), (App)NumberProviders.CODEC.fieldOf("bonus_rolls").orElse((Object)ConstantValue.exactly(0.0f)).forGetter(var0 -> var0.bonusRolls)).apply((Applicative)var02, LootPool::new));
    private final List<LootPoolEntryContainer> entries;
    private final List<LootItemCondition> conditions;
    private final Predicate<LootContext> compositeCondition;
    private final List<LootItemFunction> functions;
    private final BiFunction<ItemStack, LootContext, ItemStack> compositeFunction;
    private final NumberProvider rolls;
    private final NumberProvider bonusRolls;

    LootPool(List<LootPoolEntryContainer> var0, List<LootItemCondition> var1, List<LootItemFunction> var2, NumberProvider var3, NumberProvider var4) {
        this.entries = var0;
        this.conditions = var1;
        this.compositeCondition = Util.allOf(var1);
        this.functions = var2;
        this.compositeFunction = LootItemFunctions.compose(var2);
        this.rolls = var3;
        this.bonusRolls = var4;
    }

    private void addRandomItem(Consumer<ItemStack> var0, LootContext var1) {
        RandomSource var2 = var1.getRandom();
        ArrayList var32 = Lists.newArrayList();
        MutableInt var4 = new MutableInt();
        for (LootPoolEntryContainer var6 : this.entries) {
            var6.expand(var1, var3 -> {
                int var4 = var3.getWeight(var1.getLuck());
                if (var4 > 0) {
                    var32.add(var3);
                    var4.add(var4);
                }
            });
        }
        int var5 = var32.size();
        if (var4.intValue() == 0 || var5 == 0) {
            return;
        }
        if (var5 == 1) {
            ((LootPoolEntry)var32.get(0)).createItemStack(var0, var1);
            return;
        }
        int var6 = var2.nextInt(var4.intValue());
        for (LootPoolEntry var8 : var32) {
            if ((var6 -= var8.getWeight(var1.getLuck())) >= 0) continue;
            var8.createItemStack(var0, var1);
            return;
        }
    }

    public void addRandomItems(Consumer<ItemStack> var0, LootContext var1) {
        if (!this.compositeCondition.test(var1)) {
            return;
        }
        Consumer<ItemStack> var2 = LootItemFunction.decorate(this.compositeFunction, var0, var1);
        int var3 = this.rolls.getInt(var1) + Mth.floor(this.bonusRolls.getFloat(var1) * var1.getLuck());
        for (int var4 = 0; var4 < var3; ++var4) {
            this.addRandomItem(var2, var1);
        }
    }

    public void validate(ValidationContext var0) {
        int var1;
        for (var1 = 0; var1 < this.conditions.size(); ++var1) {
            this.conditions.get(var1).validate(var0.forChild(new ProblemReporter.IndexedFieldPathElement("conditions", var1)));
        }
        for (var1 = 0; var1 < this.functions.size(); ++var1) {
            this.functions.get(var1).validate(var0.forChild(new ProblemReporter.IndexedFieldPathElement("functions", var1)));
        }
        for (var1 = 0; var1 < this.entries.size(); ++var1) {
            this.entries.get(var1).validate(var0.forChild(new ProblemReporter.IndexedFieldPathElement("entries", var1)));
        }
        this.rolls.validate(var0.forChild(new ProblemReporter.FieldPathElement("rolls")));
        this.bonusRolls.validate(var0.forChild(new ProblemReporter.FieldPathElement("bonus_rolls")));
    }

    public static Builder lootPool() {
        return new Builder();
    }

    public static class Builder
    implements FunctionUserBuilder<Builder>,
    ConditionUserBuilder<Builder> {
        private final ImmutableList.Builder<LootPoolEntryContainer> entries = ImmutableList.builder();
        private final ImmutableList.Builder<LootItemCondition> conditions = ImmutableList.builder();
        private final ImmutableList.Builder<LootItemFunction> functions = ImmutableList.builder();
        private NumberProvider rolls = ConstantValue.exactly(1.0f);
        private NumberProvider bonusRolls = ConstantValue.exactly(0.0f);

        public Builder setRolls(NumberProvider var0) {
            this.rolls = var0;
            return this;
        }

        @Override
        public Builder unwrap() {
            return this;
        }

        public Builder setBonusRolls(NumberProvider var0) {
            this.bonusRolls = var0;
            return this;
        }

        public Builder add(LootPoolEntryContainer.Builder<?> var0) {
            this.entries.add((Object)var0.build());
            return this;
        }

        @Override
        public Builder when(LootItemCondition.Builder var0) {
            this.conditions.add((Object)var0.build());
            return this;
        }

        @Override
        public Builder apply(LootItemFunction.Builder var0) {
            this.functions.add((Object)var0.build());
            return this;
        }

        public LootPool build() {
            return new LootPool((List<LootPoolEntryContainer>)this.entries.build(), (List<LootItemCondition>)this.conditions.build(), (List<LootItemFunction>)this.functions.build(), this.rolls, this.bonusRolls);
        }

        @Override
        public /* synthetic */ FunctionUserBuilder unwrap() {
            return this.unwrap();
        }

        @Override
        public /* synthetic */ FunctionUserBuilder apply(LootItemFunction.Builder builder) {
            return this.apply(builder);
        }

        @Override
        public /* synthetic */ ConditionUserBuilder unwrap() {
            return this.unwrap();
        }

        @Override
        public /* synthetic */ ConditionUserBuilder when(LootItemCondition.Builder builder) {
            return this.when(builder);
        }
    }
}

