/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.resources.Identifier;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ApplyBonusCount
extends LootItemConditionalFunction {
    private static final Map<Identifier, FormulaType> FORMULAS = Stream.of(BinomialWithBonusCount.TYPE, OreDrops.TYPE, UniformBonusCount.TYPE).collect(Collectors.toMap(FormulaType::id, Function.identity()));
    private static final Codec<FormulaType> FORMULA_TYPE_CODEC = Identifier.CODEC.comapFlatMap(var0 -> {
        FormulaType var1 = FORMULAS.get(var0);
        if (var1 != null) {
            return DataResult.success((Object)var1);
        }
        return DataResult.error(() -> "No formula type with id: '" + String.valueOf(var0) + "'");
    }, FormulaType::id);
    private static final MapCodec<Formula> FORMULA_CODEC = ExtraCodecs.dispatchOptionalValue("formula", "parameters", FORMULA_TYPE_CODEC, Formula::getType, FormulaType::codec);
    public static final MapCodec<ApplyBonusCount> CODEC = RecordCodecBuilder.mapCodec(var02 -> ApplyBonusCount.commonFields(var02).and(var02.group((App)Enchantment.CODEC.fieldOf("enchantment").forGetter(var0 -> var0.enchantment), (App)FORMULA_CODEC.forGetter(var0 -> var0.formula))).apply((Applicative)var02, ApplyBonusCount::new));
    private final Holder<Enchantment> enchantment;
    private final Formula formula;

    private ApplyBonusCount(List<LootItemCondition> var0, Holder<Enchantment> var1, Formula var2) {
        super(var0);
        this.enchantment = var1;
        this.formula = var2;
    }

    public LootItemFunctionType<ApplyBonusCount> getType() {
        return LootItemFunctions.APPLY_BONUS;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return Set.of(LootContextParams.TOOL);
    }

    @Override
    public ItemStack run(ItemStack var0, LootContext var1) {
        ItemStack var2 = var1.getOptionalParameter(LootContextParams.TOOL);
        if (var2 != null) {
            int var3 = EnchantmentHelper.getItemEnchantmentLevel(this.enchantment, var2);
            int var4 = this.formula.calculateNewCount(var1.getRandom(), var0.getCount(), var3);
            var0.setCount(var4);
        }
        return var0;
    }

    public static LootItemConditionalFunction.Builder<?> addBonusBinomialDistributionCount(Holder<Enchantment> var0, float var1, int var2) {
        return ApplyBonusCount.simpleBuilder(var3 -> new ApplyBonusCount((List<LootItemCondition>)var3, var0, new BinomialWithBonusCount(var2, var1)));
    }

    public static LootItemConditionalFunction.Builder<?> addOreBonusCount(Holder<Enchantment> var0) {
        return ApplyBonusCount.simpleBuilder(var1 -> new ApplyBonusCount((List<LootItemCondition>)var1, var0, OreDrops.INSTANCE));
    }

    public static LootItemConditionalFunction.Builder<?> addUniformBonusCount(Holder<Enchantment> var0) {
        return ApplyBonusCount.simpleBuilder(var1 -> new ApplyBonusCount((List<LootItemCondition>)var1, var0, new UniformBonusCount(1)));
    }

    public static LootItemConditionalFunction.Builder<?> addUniformBonusCount(Holder<Enchantment> var0, int var1) {
        return ApplyBonusCount.simpleBuilder(var2 -> new ApplyBonusCount((List<LootItemCondition>)var2, var0, new UniformBonusCount(var1)));
    }

    static interface Formula {
        public int calculateNewCount(RandomSource var1, int var2, int var3);

        public FormulaType getType();
    }

    record UniformBonusCount(int bonusMultiplier) implements Formula
    {
        public static final Codec<UniformBonusCount> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.INT.fieldOf("bonusMultiplier").forGetter(UniformBonusCount::bonusMultiplier)).apply((Applicative)var0, UniformBonusCount::new));
        public static final FormulaType TYPE = new FormulaType(Identifier.withDefaultNamespace("uniform_bonus_count"), CODEC);

        @Override
        public int calculateNewCount(RandomSource var0, int var1, int var2) {
            return var1 + var0.nextInt(this.bonusMultiplier * var2 + 1);
        }

        @Override
        public FormulaType getType() {
            return TYPE;
        }
    }

    record OreDrops() implements Formula
    {
        public static final OreDrops INSTANCE = new OreDrops();
        public static final Codec<OreDrops> CODEC = MapCodec.unitCodec((Object)INSTANCE);
        public static final FormulaType TYPE = new FormulaType(Identifier.withDefaultNamespace("ore_drops"), CODEC);

        @Override
        public int calculateNewCount(RandomSource var0, int var1, int var2) {
            if (var2 > 0) {
                int var3 = var0.nextInt(var2 + 2) - 1;
                if (var3 < 0) {
                    var3 = 0;
                }
                return var1 * (var3 + 1);
            }
            return var1;
        }

        @Override
        public FormulaType getType() {
            return TYPE;
        }
    }

    record BinomialWithBonusCount(int extraRounds, float probability) implements Formula
    {
        private static final Codec<BinomialWithBonusCount> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.INT.fieldOf("extra").forGetter(BinomialWithBonusCount::extraRounds), (App)Codec.FLOAT.fieldOf("probability").forGetter(BinomialWithBonusCount::probability)).apply((Applicative)var0, BinomialWithBonusCount::new));
        public static final FormulaType TYPE = new FormulaType(Identifier.withDefaultNamespace("binomial_with_bonus_count"), CODEC);

        @Override
        public int calculateNewCount(RandomSource var0, int var1, int var2) {
            for (int var3 = 0; var3 < var2 + this.extraRounds; ++var3) {
                if (!(var0.nextFloat() < this.probability)) continue;
                ++var1;
            }
            return var1;
        }

        @Override
        public FormulaType getType() {
            return TYPE;
        }
    }

    record FormulaType(Identifier id, Codec<? extends Formula> codec) {
    }
}

