/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ApplyExplosionDecay
extends LootItemConditionalFunction {
    public static final MapCodec<ApplyExplosionDecay> CODEC = RecordCodecBuilder.mapCodec(var0 -> ApplyExplosionDecay.commonFields(var0).apply((Applicative)var0, ApplyExplosionDecay::new));

    private ApplyExplosionDecay(List<LootItemCondition> var0) {
        super(var0);
    }

    public LootItemFunctionType<ApplyExplosionDecay> getType() {
        return LootItemFunctions.EXPLOSION_DECAY;
    }

    @Override
    public ItemStack run(ItemStack var0, LootContext var1) {
        Float var2 = var1.getOptionalParameter(LootContextParams.EXPLOSION_RADIUS);
        if (var2 != null) {
            RandomSource var3 = var1.getRandom();
            float var4 = 1.0f / var2.floatValue();
            int var5 = var0.getCount();
            int var6 = 0;
            for (int var7 = 0; var7 < var5; ++var7) {
                if (!(var3.nextFloat() <= var4)) continue;
                ++var6;
            }
            var0.setCount(var6);
        }
        return var0;
    }

    public static LootItemConditionalFunction.Builder<?> explosionDecay() {
        return ApplyExplosionDecay.simpleBuilder(ApplyExplosionDecay::new);
    }
}

