/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class FillPlayerHead
extends LootItemConditionalFunction {
    public static final MapCodec<FillPlayerHead> CODEC = RecordCodecBuilder.mapCodec(var02 -> FillPlayerHead.commonFields(var02).and((App)LootContext.EntityTarget.CODEC.fieldOf("entity").forGetter(var0 -> var0.entityTarget)).apply((Applicative)var02, FillPlayerHead::new));
    private final LootContext.EntityTarget entityTarget;

    public FillPlayerHead(List<LootItemCondition> var0, LootContext.EntityTarget var1) {
        super(var0);
        this.entityTarget = var1;
    }

    public LootItemFunctionType<FillPlayerHead> getType() {
        return LootItemFunctions.FILL_PLAYER_HEAD;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return Set.of(this.entityTarget.contextParam());
    }

    @Override
    public ItemStack run(ItemStack var0, LootContext var1) {
        Entity entity;
        if (var0.is(Items.PLAYER_HEAD) && (entity = var1.getOptionalParameter(this.entityTarget.contextParam())) instanceof Player) {
            Player var2 = (Player)entity;
            var0.set(DataComponents.PROFILE, ResolvableProfile.createResolved(var2.getGameProfile()));
        }
        return var0;
    }

    public static LootItemConditionalFunction.Builder<?> fillPlayerHead(LootContext.EntityTarget var0) {
        return FillPlayerHead.simpleBuilder(var1 -> new FillPlayerHead((List<LootItemCondition>)var1, var0));
    }
}

