/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.jspecify.annotations.Nullable;

public class AABB {
    private static final double EPSILON = 1.0E-7;
    public final double minX;
    public final double minY;
    public final double minZ;
    public final double maxX;
    public final double maxY;
    public final double maxZ;

    public AABB(double var0, double var2, double var4, double var6, double var8, double var10) {
        this.minX = Math.min(var0, var6);
        this.minY = Math.min(var2, var8);
        this.minZ = Math.min(var4, var10);
        this.maxX = Math.max(var0, var6);
        this.maxY = Math.max(var2, var8);
        this.maxZ = Math.max(var4, var10);
    }

    public AABB(BlockPos var0) {
        this(var0.getX(), var0.getY(), var0.getZ(), var0.getX() + 1, var0.getY() + 1, var0.getZ() + 1);
    }

    public AABB(Vec3 var0, Vec3 var1) {
        this(var0.x, var0.y, var0.z, var1.x, var1.y, var1.z);
    }

    public static AABB of(BoundingBox var0) {
        return new AABB(var0.minX(), var0.minY(), var0.minZ(), var0.maxX() + 1, var0.maxY() + 1, var0.maxZ() + 1);
    }

    public static AABB unitCubeFromLowerCorner(Vec3 var0) {
        return new AABB(var0.x, var0.y, var0.z, var0.x + 1.0, var0.y + 1.0, var0.z + 1.0);
    }

    public static AABB encapsulatingFullBlocks(BlockPos var0, BlockPos var1) {
        return new AABB(Math.min(var0.getX(), var1.getX()), Math.min(var0.getY(), var1.getY()), Math.min(var0.getZ(), var1.getZ()), Math.max(var0.getX(), var1.getX()) + 1, Math.max(var0.getY(), var1.getY()) + 1, Math.max(var0.getZ(), var1.getZ()) + 1);
    }

    public AABB setMinX(double var0) {
        return new AABB(var0, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public AABB setMinY(double var0) {
        return new AABB(this.minX, var0, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public AABB setMinZ(double var0) {
        return new AABB(this.minX, this.minY, var0, this.maxX, this.maxY, this.maxZ);
    }

    public AABB setMaxX(double var0) {
        return new AABB(this.minX, this.minY, this.minZ, var0, this.maxY, this.maxZ);
    }

    public AABB setMaxY(double var0) {
        return new AABB(this.minX, this.minY, this.minZ, this.maxX, var0, this.maxZ);
    }

    public AABB setMaxZ(double var0) {
        return new AABB(this.minX, this.minY, this.minZ, this.maxX, this.maxY, var0);
    }

    public double min(Direction.Axis var0) {
        return var0.choose(this.minX, this.minY, this.minZ);
    }

    public double max(Direction.Axis var0) {
        return var0.choose(this.maxX, this.maxY, this.maxZ);
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof AABB)) {
            return false;
        }
        AABB var1 = (AABB)var0;
        if (Double.compare(var1.minX, this.minX) != 0) {
            return false;
        }
        if (Double.compare(var1.minY, this.minY) != 0) {
            return false;
        }
        if (Double.compare(var1.minZ, this.minZ) != 0) {
            return false;
        }
        if (Double.compare(var1.maxX, this.maxX) != 0) {
            return false;
        }
        if (Double.compare(var1.maxY, this.maxY) != 0) {
            return false;
        }
        return Double.compare(var1.maxZ, this.maxZ) == 0;
    }

    public int hashCode() {
        long var0 = Double.doubleToLongBits(this.minX);
        int var2 = (int)(var0 ^ var0 >>> 32);
        var0 = Double.doubleToLongBits(this.minY);
        var2 = 31 * var2 + (int)(var0 ^ var0 >>> 32);
        var0 = Double.doubleToLongBits(this.minZ);
        var2 = 31 * var2 + (int)(var0 ^ var0 >>> 32);
        var0 = Double.doubleToLongBits(this.maxX);
        var2 = 31 * var2 + (int)(var0 ^ var0 >>> 32);
        var0 = Double.doubleToLongBits(this.maxY);
        var2 = 31 * var2 + (int)(var0 ^ var0 >>> 32);
        var0 = Double.doubleToLongBits(this.maxZ);
        var2 = 31 * var2 + (int)(var0 ^ var0 >>> 32);
        return var2;
    }

    public AABB contract(double var0, double var2, double var4) {
        double var6 = this.minX;
        double var8 = this.minY;
        double var10 = this.minZ;
        double var12 = this.maxX;
        double var14 = this.maxY;
        double var16 = this.maxZ;
        if (var0 < 0.0) {
            var6 -= var0;
        } else if (var0 > 0.0) {
            var12 -= var0;
        }
        if (var2 < 0.0) {
            var8 -= var2;
        } else if (var2 > 0.0) {
            var14 -= var2;
        }
        if (var4 < 0.0) {
            var10 -= var4;
        } else if (var4 > 0.0) {
            var16 -= var4;
        }
        return new AABB(var6, var8, var10, var12, var14, var16);
    }

    public AABB expandTowards(Vec3 var0) {
        return this.expandTowards(var0.x, var0.y, var0.z);
    }

    public AABB expandTowards(double var0, double var2, double var4) {
        double var6 = this.minX;
        double var8 = this.minY;
        double var10 = this.minZ;
        double var12 = this.maxX;
        double var14 = this.maxY;
        double var16 = this.maxZ;
        if (var0 < 0.0) {
            var6 += var0;
        } else if (var0 > 0.0) {
            var12 += var0;
        }
        if (var2 < 0.0) {
            var8 += var2;
        } else if (var2 > 0.0) {
            var14 += var2;
        }
        if (var4 < 0.0) {
            var10 += var4;
        } else if (var4 > 0.0) {
            var16 += var4;
        }
        return new AABB(var6, var8, var10, var12, var14, var16);
    }

    public AABB inflate(double var0, double var2, double var4) {
        double var6 = this.minX - var0;
        double var8 = this.minY - var2;
        double var10 = this.minZ - var4;
        double var12 = this.maxX + var0;
        double var14 = this.maxY + var2;
        double var16 = this.maxZ + var4;
        return new AABB(var6, var8, var10, var12, var14, var16);
    }

    public AABB inflate(double var0) {
        return this.inflate(var0, var0, var0);
    }

    public AABB intersect(AABB var0) {
        double var1 = Math.max(this.minX, var0.minX);
        double var3 = Math.max(this.minY, var0.minY);
        double var5 = Math.max(this.minZ, var0.minZ);
        double var7 = Math.min(this.maxX, var0.maxX);
        double var9 = Math.min(this.maxY, var0.maxY);
        double var11 = Math.min(this.maxZ, var0.maxZ);
        return new AABB(var1, var3, var5, var7, var9, var11);
    }

    public AABB minmax(AABB var0) {
        double var1 = Math.min(this.minX, var0.minX);
        double var3 = Math.min(this.minY, var0.minY);
        double var5 = Math.min(this.minZ, var0.minZ);
        double var7 = Math.max(this.maxX, var0.maxX);
        double var9 = Math.max(this.maxY, var0.maxY);
        double var11 = Math.max(this.maxZ, var0.maxZ);
        return new AABB(var1, var3, var5, var7, var9, var11);
    }

    public AABB move(double var0, double var2, double var4) {
        return new AABB(this.minX + var0, this.minY + var2, this.minZ + var4, this.maxX + var0, this.maxY + var2, this.maxZ + var4);
    }

    public AABB move(BlockPos var0) {
        return new AABB(this.minX + (double)var0.getX(), this.minY + (double)var0.getY(), this.minZ + (double)var0.getZ(), this.maxX + (double)var0.getX(), this.maxY + (double)var0.getY(), this.maxZ + (double)var0.getZ());
    }

    public AABB move(Vec3 var0) {
        return this.move(var0.x, var0.y, var0.z);
    }

    public AABB move(Vector3f var0) {
        return this.move(var0.x, var0.y, var0.z);
    }

    public boolean intersects(AABB var0) {
        return this.intersects(var0.minX, var0.minY, var0.minZ, var0.maxX, var0.maxY, var0.maxZ);
    }

    public boolean intersects(double var0, double var2, double var4, double var6, double var8, double var10) {
        return this.minX < var6 && this.maxX > var0 && this.minY < var8 && this.maxY > var2 && this.minZ < var10 && this.maxZ > var4;
    }

    public boolean intersects(Vec3 var0, Vec3 var1) {
        return this.intersects(Math.min(var0.x, var1.x), Math.min(var0.y, var1.y), Math.min(var0.z, var1.z), Math.max(var0.x, var1.x), Math.max(var0.y, var1.y), Math.max(var0.z, var1.z));
    }

    public boolean intersects(BlockPos var0) {
        return this.intersects(var0.getX(), var0.getY(), var0.getZ(), var0.getX() + 1, var0.getY() + 1, var0.getZ() + 1);
    }

    public boolean contains(Vec3 var0) {
        return this.contains(var0.x, var0.y, var0.z);
    }

    public boolean contains(double var0, double var2, double var4) {
        return var0 >= this.minX && var0 < this.maxX && var2 >= this.minY && var2 < this.maxY && var4 >= this.minZ && var4 < this.maxZ;
    }

    public double getSize() {
        double var0 = this.getXsize();
        double var2 = this.getYsize();
        double var4 = this.getZsize();
        return (var0 + var2 + var4) / 3.0;
    }

    public double getXsize() {
        return this.maxX - this.minX;
    }

    public double getYsize() {
        return this.maxY - this.minY;
    }

    public double getZsize() {
        return this.maxZ - this.minZ;
    }

    public AABB deflate(double var0, double var2, double var4) {
        return this.inflate(-var0, -var2, -var4);
    }

    public AABB deflate(double var0) {
        return this.inflate(-var0);
    }

    public Optional<Vec3> clip(Vec3 var0, Vec3 var1) {
        return AABB.clip(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ, var0, var1);
    }

    public static Optional<Vec3> clip(double var0, double var2, double var4, double var6, double var8, double var10, Vec3 var12, Vec3 var13) {
        double[] var14 = new double[]{1.0};
        double var15 = var13.x - var12.x;
        double var17 = var13.y - var12.y;
        double var19 = var13.z - var12.z;
        Direction var21 = AABB.getDirection(var0, var2, var4, var6, var8, var10, var12, var14, null, var15, var17, var19);
        if (var21 == null) {
            return Optional.empty();
        }
        double var22 = var14[0];
        return Optional.of(var12.add(var22 * var15, var22 * var17, var22 * var19));
    }

    public static @Nullable BlockHitResult clip(Iterable<AABB> var0, Vec3 var1, Vec3 var2, BlockPos var3) {
        double[] var4 = new double[]{1.0};
        Direction var5 = null;
        double var6 = var2.x - var1.x;
        double var8 = var2.y - var1.y;
        double var10 = var2.z - var1.z;
        for (AABB var13 : var0) {
            var5 = AABB.getDirection(var13.move(var3), var1, var4, var5, var6, var8, var10);
        }
        if (var5 == null) {
            return null;
        }
        double var12 = var4[0];
        return new BlockHitResult(var1.add(var12 * var6, var12 * var8, var12 * var10), var5, var3, false);
    }

    private static @Nullable Direction getDirection(AABB var0, Vec3 var1, double[] var2, @Nullable Direction var3, double var4, double var6, double var8) {
        return AABB.getDirection(var0.minX, var0.minY, var0.minZ, var0.maxX, var0.maxY, var0.maxZ, var1, var2, var3, var4, var6, var8);
    }

    private static @Nullable Direction getDirection(double var0, double var2, double var4, double var6, double var8, double var10, Vec3 var12, double[] var13, @Nullable Direction var14, double var15, double var17, double var19) {
        if (var15 > 1.0E-7) {
            var14 = AABB.clipPoint(var13, var14, var15, var17, var19, var0, var2, var8, var4, var10, Direction.WEST, var12.x, var12.y, var12.z);
        } else if (var15 < -1.0E-7) {
            var14 = AABB.clipPoint(var13, var14, var15, var17, var19, var6, var2, var8, var4, var10, Direction.EAST, var12.x, var12.y, var12.z);
        }
        if (var17 > 1.0E-7) {
            var14 = AABB.clipPoint(var13, var14, var17, var19, var15, var2, var4, var10, var0, var6, Direction.DOWN, var12.y, var12.z, var12.x);
        } else if (var17 < -1.0E-7) {
            var14 = AABB.clipPoint(var13, var14, var17, var19, var15, var8, var4, var10, var0, var6, Direction.UP, var12.y, var12.z, var12.x);
        }
        if (var19 > 1.0E-7) {
            var14 = AABB.clipPoint(var13, var14, var19, var15, var17, var4, var0, var6, var2, var8, Direction.NORTH, var12.z, var12.x, var12.y);
        } else if (var19 < -1.0E-7) {
            var14 = AABB.clipPoint(var13, var14, var19, var15, var17, var10, var0, var6, var2, var8, Direction.SOUTH, var12.z, var12.x, var12.y);
        }
        return var14;
    }

    private static @Nullable Direction clipPoint(double[] var0, @Nullable Direction var1, double var2, double var4, double var6, double var8, double var10, double var12, double var14, double var16, Direction var18, double var19, double var21, double var23) {
        double var25 = (var8 - var19) / var2;
        double var27 = var21 + var25 * var4;
        double var29 = var23 + var25 * var6;
        if (0.0 < var25 && var25 < var0[0] && var10 - 1.0E-7 < var27 && var27 < var12 + 1.0E-7 && var14 - 1.0E-7 < var29 && var29 < var16 + 1.0E-7) {
            var0[0] = var25;
            return var18;
        }
        return var1;
    }

    public boolean collidedAlongVector(Vec3 var0, List<AABB> var1) {
        Vec3 var2 = this.getCenter();
        Vec3 var3 = var2.add(var0);
        for (AABB var5 : var1) {
            AABB var6 = var5.inflate(this.getXsize() * 0.5 - 1.0E-7, this.getYsize() * 0.5 - 1.0E-7, this.getZsize() * 0.5 - 1.0E-7);
            if (var6.contains(var3) || var6.contains(var2)) {
                return true;
            }
            if (!var6.clip(var2, var3).isPresent()) continue;
            return true;
        }
        return false;
    }

    public double distanceToSqr(Vec3 var0) {
        double var1 = Math.max(Math.max(this.minX - var0.x, var0.x - this.maxX), 0.0);
        double var3 = Math.max(Math.max(this.minY - var0.y, var0.y - this.maxY), 0.0);
        double var5 = Math.max(Math.max(this.minZ - var0.z, var0.z - this.maxZ), 0.0);
        return Mth.lengthSquared(var1, var3, var5);
    }

    public double distanceToSqr(AABB var0) {
        double var1 = Math.max(Math.max(this.minX - var0.maxX, var0.minX - this.maxX), 0.0);
        double var3 = Math.max(Math.max(this.minY - var0.maxY, var0.minY - this.maxY), 0.0);
        double var5 = Math.max(Math.max(this.minZ - var0.maxZ, var0.minZ - this.maxZ), 0.0);
        return Mth.lengthSquared(var1, var3, var5);
    }

    public String toString() {
        return "AABB[" + this.minX + ", " + this.minY + ", " + this.minZ + "] -> [" + this.maxX + ", " + this.maxY + ", " + this.maxZ + "]";
    }

    public boolean hasNaN() {
        return Double.isNaN(this.minX) || Double.isNaN(this.minY) || Double.isNaN(this.minZ) || Double.isNaN(this.maxX) || Double.isNaN(this.maxY) || Double.isNaN(this.maxZ);
    }

    public Vec3 getCenter() {
        return new Vec3(Mth.lerp(0.5, this.minX, this.maxX), Mth.lerp(0.5, this.minY, this.maxY), Mth.lerp(0.5, this.minZ, this.maxZ));
    }

    public Vec3 getBottomCenter() {
        return new Vec3(Mth.lerp(0.5, this.minX, this.maxX), this.minY, Mth.lerp(0.5, this.minZ, this.maxZ));
    }

    public Vec3 getMinPosition() {
        return new Vec3(this.minX, this.minY, this.minZ);
    }

    public Vec3 getMaxPosition() {
        return new Vec3(this.maxX, this.maxY, this.maxZ);
    }

    public static AABB ofSize(Vec3 var0, double var1, double var3, double var5) {
        return new AABB(var0.x - var1 / 2.0, var0.y - var3 / 2.0, var0.z - var5 / 2.0, var0.x + var1 / 2.0, var0.y + var3 / 2.0, var0.z + var5 / 2.0);
    }

    public static class Builder {
        private float minX = Float.POSITIVE_INFINITY;
        private float minY = Float.POSITIVE_INFINITY;
        private float minZ = Float.POSITIVE_INFINITY;
        private float maxX = Float.NEGATIVE_INFINITY;
        private float maxY = Float.NEGATIVE_INFINITY;
        private float maxZ = Float.NEGATIVE_INFINITY;

        public void include(Vector3fc var0) {
            this.minX = Math.min(this.minX, var0.x());
            this.minY = Math.min(this.minY, var0.y());
            this.minZ = Math.min(this.minZ, var0.z());
            this.maxX = Math.max(this.maxX, var0.x());
            this.maxY = Math.max(this.maxY, var0.y());
            this.maxZ = Math.max(this.maxZ, var0.z());
        }

        public AABB build() {
            return new AABB(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
        }
    }
}

