/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.vehicle.minecart.AbstractMinecart;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jspecify.annotations.Nullable;

public class MinecartCollisionContext
extends EntityCollisionContext {
    private @Nullable BlockPos ingoreBelow;
    private @Nullable BlockPos slopeIgnore;

    protected MinecartCollisionContext(AbstractMinecart var0, boolean var1) {
        super(var0, var1, false);
        this.setupContext(var0);
    }

    private void setupContext(AbstractMinecart var0) {
        BlockPos var1 = var0.getCurrentBlockPosOrRailBelow();
        BlockState var2 = var0.level().getBlockState(var1);
        boolean var3 = BaseRailBlock.isRail(var2);
        if (var3) {
            this.ingoreBelow = var1.below();
            RailShape var4 = var2.getValue(((BaseRailBlock)var2.getBlock()).getShapeProperty());
            if (var4.isSlope()) {
                this.slopeIgnore = switch (var4) {
                    case RailShape.ASCENDING_EAST -> var1.east();
                    case RailShape.ASCENDING_WEST -> var1.west();
                    case RailShape.ASCENDING_NORTH -> var1.north();
                    case RailShape.ASCENDING_SOUTH -> var1.south();
                    default -> null;
                };
            }
        }
    }

    @Override
    public VoxelShape getCollisionShape(BlockState var0, CollisionGetter var1, BlockPos var2) {
        if (var2.equals(this.ingoreBelow) || var2.equals(this.slopeIgnore)) {
            return Shapes.empty();
        }
        return super.getCollisionShape(var0, var1, var2);
    }
}

