/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.network.chat.numbers.NumberFormatTypes;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import org.jspecify.annotations.Nullable;

public class Score
implements ReadOnlyScoreInfo {
    private int value;
    private boolean locked = true;
    private @Nullable Component display;
    private @Nullable NumberFormat numberFormat;

    public Score() {
    }

    public Score(Packed var0) {
        this.value = var0.value;
        this.locked = var0.locked;
        this.display = var0.display.orElse(null);
        this.numberFormat = var0.numberFormat.orElse(null);
    }

    public Packed pack() {
        return new Packed(this.value, this.locked, Optional.ofNullable(this.display), Optional.ofNullable(this.numberFormat));
    }

    @Override
    public int value() {
        return this.value;
    }

    public void value(int var0) {
        this.value = var0;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean var0) {
        this.locked = var0;
    }

    public @Nullable Component display() {
        return this.display;
    }

    public void display(@Nullable Component var0) {
        this.display = var0;
    }

    @Override
    public @Nullable NumberFormat numberFormat() {
        return this.numberFormat;
    }

    public void numberFormat(@Nullable NumberFormat var0) {
        this.numberFormat = var0;
    }

    public static final class Packed
    extends Record {
        final int value;
        final boolean locked;
        final Optional<Component> display;
        final Optional<NumberFormat> numberFormat;
        public static final MapCodec<Packed> MAP_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.INT.optionalFieldOf("Score", (Object)0).forGetter(Packed::value), (App)Codec.BOOL.optionalFieldOf("Locked", (Object)false).forGetter(Packed::locked), (App)ComponentSerialization.CODEC.optionalFieldOf("display").forGetter(Packed::display), (App)NumberFormatTypes.CODEC.optionalFieldOf("format").forGetter(Packed::numberFormat)).apply((Applicative)var0, Packed::new));

        public Packed(int var0, boolean var1, Optional<Component> var2, Optional<NumberFormat> var3) {
            this.value = var0;
            this.locked = var1;
            this.display = var2;
            this.numberFormat = var3;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Packed.class, "value;locked;display;numberFormat", "value", "locked", "display", "numberFormat"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Packed.class, "value;locked;display;numberFormat", "value", "locked", "display", "numberFormat"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Packed.class, "value;locked;display;numberFormat", "value", "locked", "display", "numberFormat"}, this, var0);
        }

        public int value() {
            return this.value;
        }

        public boolean locked() {
            return this.locked;
        }

        public Optional<Component> display() {
            return this.display;
        }

        public Optional<NumberFormat> numberFormat() {
            return this.numberFormat;
        }
    }
}

