/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.ticks;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.ticks.SavedTick;
import net.minecraft.world.ticks.ScheduledTick;
import net.minecraft.world.ticks.SerializableTickContainer;
import net.minecraft.world.ticks.TickContainerAccess;

public class ProtoChunkTicks<T>
implements SerializableTickContainer<T>,
TickContainerAccess<T> {
    private final List<SavedTick<T>> ticks = Lists.newArrayList();
    private final Set<SavedTick<?>> ticksPerPosition = new ObjectOpenCustomHashSet(SavedTick.UNIQUE_TICK_HASH);

    @Override
    public void schedule(ScheduledTick<T> var0) {
        SavedTick<T> var1 = new SavedTick<T>(var0.type(), var0.pos(), 0, var0.priority());
        this.schedule(var1);
    }

    @Override
    private void schedule(SavedTick<T> var0) {
        if (this.ticksPerPosition.add(var0)) {
            this.ticks.add(var0);
        }
    }

    @Override
    public boolean hasScheduledTick(BlockPos var0, T var1) {
        return this.ticksPerPosition.contains(SavedTick.probe(var1, var0));
    }

    @Override
    public int count() {
        return this.ticks.size();
    }

    @Override
    public List<SavedTick<T>> pack(long var0) {
        return this.ticks;
    }

    public List<SavedTick<T>> scheduledTicks() {
        return List.copyOf(this.ticks);
    }

    public static <T> ProtoChunkTicks<T> load(List<SavedTick<T>> var0) {
        ProtoChunkTicks<T> var1 = new ProtoChunkTicks<T>();
        var0.forEach(var1::schedule);
        return var1;
    }
}

