/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.timeline;

import java.util.Optional;
import java.util.function.LongSupplier;
import net.minecraft.util.KeyframeTrack;
import net.minecraft.util.KeyframeTrackSampler;
import net.minecraft.world.attribute.EnvironmentAttributeLayer;
import net.minecraft.world.attribute.LerpFunction;
import net.minecraft.world.attribute.modifier.AttributeModifier;
import org.jspecify.annotations.Nullable;

public class AttributeTrackSampler<Value, Argument>
implements EnvironmentAttributeLayer.TimeBased<Value> {
    private final AttributeModifier<Value, Argument> modifier;
    private final KeyframeTrackSampler<Argument> argumentSampler;
    private final LongSupplier dayTimeGetter;
    private int cachedTickId;
    private @Nullable Argument cachedArgument;

    public AttributeTrackSampler(Optional<Integer> var0, AttributeModifier<Value, Argument> var1, KeyframeTrack<Argument> var2, LerpFunction<Argument> var3, LongSupplier var4) {
        this.modifier = var1;
        this.dayTimeGetter = var4;
        this.argumentSampler = var2.bakeSampler(var0, var3);
    }

    @Override
    public Value applyTimeBased(Value var0, int var1) {
        if (this.cachedArgument == null || var1 != this.cachedTickId) {
            this.cachedTickId = var1;
            this.cachedArgument = this.argumentSampler.sample(this.dayTimeGetter.getAsLong());
        }
        return this.modifier.apply(var0, this.cachedArgument);
    }
}

