/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.timeline;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.KeyframeTrack;
import net.minecraft.util.Util;
import net.minecraft.world.attribute.EnvironmentAttribute;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.attribute.modifier.AttributeModifier;
import net.minecraft.world.level.Level;
import net.minecraft.world.timeline.AttributeTrack;
import net.minecraft.world.timeline.AttributeTrackSampler;

public class Timeline {
    public static final Codec<Holder<Timeline>> CODEC = RegistryFixedCodec.create(Registries.TIMELINE);
    private static final Codec<Map<EnvironmentAttribute<?>, AttributeTrack<?, ?>>> TRACKS_CODEC = Codec.dispatchedMap(EnvironmentAttributes.CODEC, Util.memoize(AttributeTrack::createCodec));
    public static final Codec<Timeline> DIRECT_CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("period_ticks").forGetter(var0 -> var0.periodTicks), (App)TRACKS_CODEC.optionalFieldOf("tracks", Map.of()).forGetter(var0 -> var0.tracks)).apply((Applicative)var02, Timeline::new)).validate(Timeline::validateInternal);
    public static final Codec<Timeline> NETWORK_CODEC = DIRECT_CODEC.xmap(Timeline::filterSyncableTracks, Timeline::filterSyncableTracks);
    private final Optional<Integer> periodTicks;
    private final Map<EnvironmentAttribute<?>, AttributeTrack<?, ?>> tracks;

    private static Timeline filterSyncableTracks(Timeline var0) {
        Map<EnvironmentAttribute<?>, AttributeTrack<?, ?>> var1 = Map.copyOf(Maps.filterKeys(var0.tracks, EnvironmentAttribute::isSyncable));
        return new Timeline(var0.periodTicks, var1);
    }

    Timeline(Optional<Integer> var0, Map<EnvironmentAttribute<?>, AttributeTrack<?, ?>> var1) {
        this.periodTicks = var0;
        this.tracks = var1;
    }

    private static DataResult<Timeline> validateInternal(Timeline var02) {
        if (var02.periodTicks.isEmpty()) {
            return DataResult.success((Object)var02);
        }
        int var12 = var02.periodTicks.get();
        DataResult var2 = DataResult.success((Object)var02);
        for (AttributeTrack<?, ?> var4 : var02.tracks.values()) {
            var2 = var2.apply2stable((var0, var1) -> var0, AttributeTrack.validatePeriod(var4, var12));
        }
        return var2;
    }

    public static Builder builder() {
        return new Builder();
    }

    public long getCurrentTicks(Level var0) {
        long var1 = this.getTotalTicks(var0);
        if (this.periodTicks.isEmpty()) {
            return var1;
        }
        return var1 % (long)this.periodTicks.get().intValue();
    }

    public long getTotalTicks(Level var0) {
        return var0.getDayTime();
    }

    public Optional<Integer> periodTicks() {
        return this.periodTicks;
    }

    public Set<EnvironmentAttribute<?>> attributes() {
        return this.tracks.keySet();
    }

    public <Value> AttributeTrackSampler<Value, ?> createTrackSampler(EnvironmentAttribute<Value> var0, LongSupplier var1) {
        AttributeTrack<?, ?> var2 = this.tracks.get(var0);
        if (var2 == null) {
            throw new IllegalStateException("Timeline has no track for " + String.valueOf(var0));
        }
        return var2.bakeSampler(var0, this.periodTicks, var1);
    }

    public static class Builder {
        private Optional<Integer> periodTicks = Optional.empty();
        private final ImmutableMap.Builder<EnvironmentAttribute<?>, AttributeTrack<?, ?>> tracks = ImmutableMap.builder();

        Builder() {
        }

        public Builder setPeriodTicks(int var0) {
            this.periodTicks = Optional.of(var0);
            return this;
        }

        public <Value, Argument> Builder addModifierTrack(EnvironmentAttribute<Value> var0, AttributeModifier<Value, Argument> var1, Consumer<KeyframeTrack.Builder<Argument>> var2) {
            var0.type().checkAllowedModifier(var1);
            KeyframeTrack.Builder var3 = new KeyframeTrack.Builder();
            var2.accept(var3);
            this.tracks.put(var0, new AttributeTrack<Value, Argument>(var1, var3.build()));
            return this;
        }

        public <Value> Builder addTrack(EnvironmentAttribute<Value> var0, Consumer<KeyframeTrack.Builder<Value>> var1) {
            return this.addModifierTrack(var0, AttributeModifier.override(), var1);
        }

        public Timeline build() {
            return new Timeline(this.periodTicks, (Map<EnvironmentAttribute<?>, AttributeTrack<?, ?>>)this.tracks.build());
        }
    }
}

