/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7;

import com.google.common.base.Preconditions;
import net.minecraft.core.registries.Registries;
import org.bukkit.GameEvent;
import org.bukkit.GameRule;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R7.CraftGameEvent;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.util.Handleable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftGameRule<T>
implements Handleable<net.minecraft.world.level.gamerules.GameRule<T>>,
GameRule<T> {
    private final NamespacedKey key;
    private final net.minecraft.world.level.gamerules.GameRule<T> handle;

    public static <T> GameRule<T> minecraftToBukkit(net.minecraft.world.level.gamerules.GameRule<T> minecraft) {
        return (GameRule)CraftRegistry.minecraftToBukkit(minecraft, Registries.GAME_RULE, Registry.GAME_RULE);
    }

    public static <T> net.minecraft.world.level.gamerules.GameRule<T> bukkitToMinecraft(GameRule<T> bukkit) {
        return (net.minecraft.world.level.gamerules.GameRule)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public CraftGameRule(NamespacedKey key, net.minecraft.world.level.gamerules.GameRule<T> handle) {
        this.key = key;
        this.handle = handle;
    }

    @Override
    public net.minecraft.world.level.gamerules.GameRule<T> getHandle() {
        return this.handle;
    }

    @NotNull
    public NamespacedKey getKey() {
        return this.getKeyOrThrow();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CraftGameEvent)) {
            return false;
        }
        return this.getKey().equals((Object)((GameEvent)other).getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String toString() {
        return "CraftGameRule{key=" + String.valueOf(this.key) + "}";
    }

    @NotNull
    public NamespacedKey getKeyOrThrow() {
        Preconditions.checkState((boolean)this.isRegistered(), (Object)"Cannot get key of this registry item, because it is not registered. Use #isRegistered() before calling this method.");
        return this.key;
    }

    @Nullable
    public NamespacedKey getKeyOrNull() {
        return this.key;
    }

    public boolean isRegistered() {
        return this.key != null;
    }

    public String getName() {
        return this.getKeyOrThrow().getKey();
    }

    public Class<T> getType() {
        return ((net.minecraft.world.level.gamerules.GameRule)this.getHandle()).valueClass();
    }
}

