/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.block;

import net.minecraft.world.level.block.entity.EnchantingTableBlockEntity;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.EnchantingTable;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftChatMessage;

public class CraftEnchantingTable
extends CraftBlockEntityState<EnchantingTableBlockEntity>
implements EnchantingTable {
    public CraftEnchantingTable(World world, EnchantingTableBlockEntity tileEntity) {
        super(world, tileEntity);
    }

    protected CraftEnchantingTable(CraftEnchantingTable state, Location location) {
        super(state, location);
    }

    public String getCustomName() {
        EnchantingTableBlockEntity enchant = (EnchantingTableBlockEntity)this.getSnapshot();
        return enchant.hasCustomName() ? CraftChatMessage.fromComponent(enchant.getCustomName()) : null;
    }

    public void setCustomName(String name) {
        ((EnchantingTableBlockEntity)this.getSnapshot()).setCustomName(CraftChatMessage.fromStringOrNull(name));
    }

    @Override
    protected void applyTo(EnchantingTableBlockEntity enchantingTable) {
        super.applyTo(enchantingTable);
        if (!((EnchantingTableBlockEntity)this.getSnapshot()).hasCustomName()) {
            enchantingTable.setCustomName(null);
        }
    }

    @Override
    public CraftEnchantingTable copy() {
        return new CraftEnchantingTable(this, null);
    }

    @Override
    public CraftEnchantingTable copy(Location location) {
        return new CraftEnchantingTable(this, location);
    }
}

