/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.block;

import com.google.common.base.Preconditions;
import net.minecraft.world.level.block.entity.SculkSensorBlockEntity;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.SculkSensor;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockEntityState;

public class CraftSculkSensor<T extends SculkSensorBlockEntity>
extends CraftBlockEntityState<T>
implements SculkSensor {
    public CraftSculkSensor(World world, T tileEntity) {
        super(world, tileEntity);
    }

    protected CraftSculkSensor(CraftSculkSensor<T> state, Location location) {
        super(state, location);
    }

    public int getLastVibrationFrequency() {
        return ((SculkSensorBlockEntity)this.getSnapshot()).getLastVibrationFrequency();
    }

    public void setLastVibrationFrequency(int lastVibrationFrequency) {
        Preconditions.checkArgument((0 <= lastVibrationFrequency && lastVibrationFrequency <= 15 ? 1 : 0) != 0, (Object)"Vibration frequency must be between 0-15");
        ((SculkSensorBlockEntity)this.getSnapshot()).lastVibrationFrequency = lastVibrationFrequency;
    }

    @Override
    public CraftSculkSensor<T> copy() {
        return new CraftSculkSensor<T>(this, null);
    }

    @Override
    public CraftSculkSensor<T> copy(Location location) {
        return new CraftSculkSensor<T>(this, location);
    }
}

