/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.damage;

import com.google.common.base.Preconditions;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageType;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.damage.CraftDamageEffect;
import org.bukkit.craftbukkit.v1_21_R7.registry.CraftRegistryItem;
import org.bukkit.damage.DamageEffect;
import org.bukkit.damage.DeathMessageType;

public class CraftDamageType
extends CraftRegistryItem<DamageType>
implements org.bukkit.damage.DamageType {
    public CraftDamageType(NamespacedKey key, Holder<DamageType> handle) {
        super(key, handle);
    }

    public String getTranslationKey() {
        return ((DamageType)this.getHandle()).msgId();
    }

    public org.bukkit.damage.DamageScaling getDamageScaling() {
        return CraftDamageType.damageScalingToBukkit(((DamageType)this.getHandle()).scaling());
    }

    public DamageEffect getDamageEffect() {
        return CraftDamageEffect.toBukkit(((DamageType)this.getHandle()).effects());
    }

    public DeathMessageType getDeathMessageType() {
        return CraftDamageType.deathMessageTypeToBukkit(((DamageType)this.getHandle()).deathMessageType());
    }

    public float getExhaustion() {
        return ((DamageType)this.getHandle()).exhaustion();
    }

    public NamespacedKey getKey() {
        return this.getKeyOrThrow();
    }

    public static DeathMessageType deathMessageTypeToBukkit(net.minecraft.world.damagesource.DeathMessageType deathMessageType) {
        return switch (deathMessageType) {
            case net.minecraft.world.damagesource.DeathMessageType.DEFAULT -> DeathMessageType.DEFAULT;
            case net.minecraft.world.damagesource.DeathMessageType.FALL_VARIANTS -> DeathMessageType.FALL_VARIANTS;
            case net.minecraft.world.damagesource.DeathMessageType.INTENTIONAL_GAME_DESIGN -> DeathMessageType.INTENTIONAL_GAME_DESIGN;
            default -> throw new IllegalArgumentException("NMS DeathMessageType." + String.valueOf(deathMessageType) + " cannot be converted to a Bukkit DeathMessageType.");
        };
    }

    public static net.minecraft.world.damagesource.DeathMessageType deathMessageTypeToNMS(DeathMessageType deathMessageType) {
        return switch (deathMessageType) {
            case DeathMessageType.DEFAULT -> net.minecraft.world.damagesource.DeathMessageType.DEFAULT;
            case DeathMessageType.FALL_VARIANTS -> net.minecraft.world.damagesource.DeathMessageType.FALL_VARIANTS;
            case DeathMessageType.INTENTIONAL_GAME_DESIGN -> net.minecraft.world.damagesource.DeathMessageType.INTENTIONAL_GAME_DESIGN;
            default -> throw new IllegalArgumentException("Bukkit DeathMessageType." + String.valueOf(deathMessageType) + " cannot be converted to a NMS DeathMessageType.");
        };
    }

    public static org.bukkit.damage.DamageScaling damageScalingToBukkit(DamageScaling damageScaling) {
        return switch (damageScaling) {
            case DamageScaling.ALWAYS -> org.bukkit.damage.DamageScaling.ALWAYS;
            case DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER -> org.bukkit.damage.DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER;
            case DamageScaling.NEVER -> org.bukkit.damage.DamageScaling.NEVER;
            default -> throw new IllegalArgumentException("NMS DamageScaling." + String.valueOf(damageScaling) + " cannot be converted to a Bukkit DamageScaling");
        };
    }

    public static DamageScaling damageScalingToNMS(org.bukkit.damage.DamageScaling damageScaling) {
        return switch (damageScaling) {
            case org.bukkit.damage.DamageScaling.ALWAYS -> DamageScaling.ALWAYS;
            case org.bukkit.damage.DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER -> DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER;
            case org.bukkit.damage.DamageScaling.NEVER -> DamageScaling.NEVER;
            default -> throw new IllegalArgumentException("Bukkit DamageScaling." + String.valueOf(damageScaling) + " cannot be converted to a NMS DamageScaling");
        };
    }

    public static org.bukkit.damage.DamageType minecraftHolderToBukkit(Holder<DamageType> minecraftHolder) {
        return CraftDamageType.minecraftToBukkit(minecraftHolder.value());
    }

    public static Holder<DamageType> bukkitToMinecraftHolder(org.bukkit.damage.DamageType bukkitDamageType) {
        Preconditions.checkArgument((bukkitDamageType != null ? 1 : 0) != 0);
        net.minecraft.core.Registry registry = CraftRegistry.getMinecraftRegistry(Registries.DAMAGE_TYPE);
        Holder<DamageType> holder = registry.wrapAsHolder(CraftDamageType.bukkitToMinecraft(bukkitDamageType));
        if (holder instanceof Holder.Reference) {
            Holder.Reference holder2 = (Holder.Reference)holder;
            return holder2;
        }
        throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkitDamageType) + ", this can happen if a plugin creates its own damage type with out properly registering it.");
    }

    public static DamageType bukkitToMinecraft(org.bukkit.damage.DamageType bukkitDamageType) {
        return (DamageType)CraftRegistry.bukkitToMinecraft(bukkitDamageType);
    }

    public static org.bukkit.damage.DamageType minecraftToBukkit(DamageType minecraftDamageType) {
        return (org.bukkit.damage.DamageType)CraftRegistry.minecraftToBukkit(minecraftDamageType, Registries.DAMAGE_TYPE, Registry.DAMAGE_TYPE);
    }
}

