/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import java.util.stream.Collectors;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.boat.AbstractBoat;
import org.bukkit.TreeSpecies;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftVehicle;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;

public abstract class CraftBoat
extends CraftVehicle
implements Boat {
    public CraftBoat(CraftServer server, AbstractBoat entity) {
        super(server, entity);
    }

    public TreeSpecies getWoodType() {
        return CraftBoat.getTreeSpecies(this.getHandle().getType());
    }

    public void setWoodType(TreeSpecies species) {
        throw new UnsupportedOperationException("Not supported - you must spawn a new entity to change boat type.");
    }

    public Boat.Type getBoatType() {
        return CraftBoat.boatTypeFromNms(this.getHandle().getType());
    }

    public void setBoatType(Boat.Type type) {
        throw new UnsupportedOperationException("Not supported - you must spawn a new entity to change boat type.");
    }

    public double getMaxSpeed() {
        return this.getHandle().maxSpeed;
    }

    public void setMaxSpeed(double speed) {
        if (speed >= 0.0) {
            this.getHandle().maxSpeed = speed;
        }
    }

    public double getOccupiedDeceleration() {
        return this.getHandle().occupiedDeceleration;
    }

    public void setOccupiedDeceleration(double speed) {
        if (speed >= 0.0) {
            this.getHandle().occupiedDeceleration = speed;
        }
    }

    public double getUnoccupiedDeceleration() {
        return this.getHandle().unoccupiedDeceleration;
    }

    public void setUnoccupiedDeceleration(double speed) {
        this.getHandle().unoccupiedDeceleration = speed;
    }

    public boolean getWorkOnLand() {
        return this.getHandle().landBoats;
    }

    public void setWorkOnLand(boolean workOnLand) {
        this.getHandle().landBoats = workOnLand;
    }

    public Boat.Status getStatus() {
        return CraftBoat.boatStatusFromNms(this.getHandle().status);
    }

    public boolean isLeashed() {
        return this.getHandle().getLeashHolder() != null;
    }

    public Entity getLeashHolder() throws IllegalStateException {
        Preconditions.checkState((boolean)this.isLeashed(), (Object)"Entity not leashed");
        return this.getHandle().getLeashHolder().getBukkitEntity();
    }

    private boolean unleash() {
        if (!this.isLeashed()) {
            return false;
        }
        this.getHandle().removeLeash();
        return true;
    }

    public boolean setLeashHolder(Entity holder) {
        if (this.getHandle().generation) {
            return false;
        }
        if (holder == null) {
            return this.unleash();
        }
        if (holder.isDead()) {
            return false;
        }
        this.unleash();
        this.getHandle().setLeashedTo(((CraftEntity)holder).getHandle(), true);
        return true;
    }

    @Override
    public AbstractBoat getHandle() {
        return (AbstractBoat)this.entity;
    }

    @Override
    public String toString() {
        return "CraftBoat{boatType=" + String.valueOf(this.getBoatType()) + ",status=" + String.valueOf(this.getStatus()) + ",passengers=" + this.getPassengers().stream().map(Entity::toString).collect(Collectors.joining("-", "{", "}")) + "}";
    }

    public static Boat.Type boatTypeFromNms(EntityType<?> boatType) {
        if (boatType == EntityType.OAK_BOAT || boatType == EntityType.OAK_CHEST_BOAT) {
            return Boat.Type.OAK;
        }
        if (boatType == EntityType.BIRCH_BOAT || boatType == EntityType.BIRCH_CHEST_BOAT) {
            return Boat.Type.BIRCH;
        }
        if (boatType == EntityType.ACACIA_BOAT || boatType == EntityType.ACACIA_CHEST_BOAT) {
            return Boat.Type.ACACIA;
        }
        if (boatType == EntityType.CHERRY_BOAT || boatType == EntityType.CHERRY_CHEST_BOAT) {
            return Boat.Type.CHERRY;
        }
        if (boatType == EntityType.JUNGLE_BOAT || boatType == EntityType.JUNGLE_CHEST_BOAT) {
            return Boat.Type.JUNGLE;
        }
        if (boatType == EntityType.SPRUCE_BOAT || boatType == EntityType.SPRUCE_CHEST_BOAT) {
            return Boat.Type.SPRUCE;
        }
        if (boatType == EntityType.DARK_OAK_BOAT || boatType == EntityType.DARK_OAK_CHEST_BOAT) {
            return Boat.Type.DARK_OAK;
        }
        if (boatType == EntityType.MANGROVE_BOAT || boatType == EntityType.MANGROVE_CHEST_BOAT) {
            return Boat.Type.MANGROVE;
        }
        if (boatType == EntityType.BAMBOO_RAFT || boatType == EntityType.BAMBOO_CHEST_RAFT) {
            return Boat.Type.BAMBOO;
        }
        throw new EnumConstantNotPresentException(Boat.Type.class, boatType.toString());
    }

    public static Boat.Status boatStatusFromNms(AbstractBoat.Status enumStatus) {
        return switch (enumStatus) {
            default -> throw new EnumConstantNotPresentException(Boat.Status.class, enumStatus.name());
            case AbstractBoat.Status.IN_AIR -> Boat.Status.IN_AIR;
            case AbstractBoat.Status.ON_LAND -> Boat.Status.ON_LAND;
            case AbstractBoat.Status.UNDER_WATER -> Boat.Status.UNDER_WATER;
            case AbstractBoat.Status.UNDER_FLOWING_WATER -> Boat.Status.UNDER_FLOWING_WATER;
            case AbstractBoat.Status.IN_WATER -> Boat.Status.IN_WATER;
        };
    }

    @Deprecated
    public static TreeSpecies getTreeSpecies(EntityType<?> boatType) {
        if (boatType == EntityType.SPRUCE_BOAT || boatType == EntityType.SPRUCE_CHEST_BOAT) {
            return TreeSpecies.REDWOOD;
        }
        if (boatType == EntityType.BIRCH_BOAT || boatType == EntityType.BIRCH_CHEST_BOAT) {
            return TreeSpecies.BIRCH;
        }
        if (boatType == EntityType.JUNGLE_BOAT || boatType == EntityType.JUNGLE_CHEST_BOAT) {
            return TreeSpecies.JUNGLE;
        }
        if (boatType == EntityType.ACACIA_BOAT || boatType == EntityType.ACACIA_CHEST_BOAT) {
            return TreeSpecies.ACACIA;
        }
        if (boatType == EntityType.DARK_OAK_BOAT || boatType == EntityType.DARK_OAK_CHEST_BOAT) {
            return TreeSpecies.DARK_OAK;
        }
        return TreeSpecies.GENERIC;
    }
}

