/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import java.util.Locale;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.EntityType;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.legacy.FieldRename;
import org.bukkit.craftbukkit.v1_21_R7.util.ApiVersion;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftNamespacedKey;

public class CraftEntityType {
    public static org.bukkit.entity.EntityType minecraftToBukkit(EntityType<?> minecraft) {
        Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
        net.minecraft.core.Registry registry = CraftRegistry.getMinecraftRegistry(Registries.ENTITY_TYPE);
        org.bukkit.entity.EntityType bukkit = (org.bukkit.entity.EntityType)Registry.ENTITY_TYPE.get(CraftNamespacedKey.fromMinecraft(registry.getResourceKey(minecraft).orElseThrow().identifier()));
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit;
    }

    public static EntityType<?> bukkitToMinecraft(org.bukkit.entity.EntityType bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return (EntityType)CraftRegistry.getMinecraftRegistry(Registries.ENTITY_TYPE).getOptional(CraftNamespacedKey.toMinecraft(bukkit.getKey())).orElseThrow();
    }

    public static Holder<EntityType<?>> bukkitToMinecraftHolder(org.bukkit.entity.EntityType bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        net.minecraft.core.Registry registry = CraftRegistry.getMinecraftRegistry(Registries.ENTITY_TYPE);
        Holder<EntityType<?>> holder = registry.wrapAsHolder(CraftEntityType.bukkitToMinecraft(bukkit));
        if (holder instanceof Holder.Reference) {
            Holder.Reference holder2 = (Holder.Reference)holder;
            return holder2;
        }
        throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own sound effect with out properly registering it.");
    }

    public static String bukkitToString(org.bukkit.entity.EntityType bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit.getKey().toString();
    }

    public static org.bukkit.entity.EntityType stringToBukkit(String string) {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0);
        string = FieldRename.convertEntityTypeName(ApiVersion.CURRENT, string);
        string = string.toLowerCase(Locale.ROOT);
        NamespacedKey key = NamespacedKey.fromString((String)string);
        return (org.bukkit.entity.EntityType)CraftRegistry.get(Registry.ENTITY_TYPE, key, ApiVersion.CURRENT);
    }
}

