/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundOpenScreenPacket;
import net.minecraft.network.protocol.game.ServerboundContainerClosePacket;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftAbstractHorse;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftVillager;
import org.bukkit.craftbukkit.v1_21_R7.entity.memory.CraftMemoryMapper;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftContainer;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventoryAbstractHorse;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventoryDoubleChest;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventoryLectern;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventoryPlayer;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMerchantCustom;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_21_R7.inventory.util.CraftMenus;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Firework;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Villager;
import org.bukkit.entity.model.PlayerModelPart;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MainHand;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.plugin.Plugin;

public class CraftHumanEntity
extends CraftLivingEntity
implements HumanEntity {
    private CraftInventoryPlayer inventory;
    private final CraftInventory enderChest;
    protected final PermissibleBase perm = new PermissibleBase((ServerOperator)this);
    private boolean op;
    private GameMode mode;

    public CraftHumanEntity(CraftServer server, Player entity) {
        super(server, entity);
        this.mode = server.getDefaultGameMode();
        this.inventory = new CraftInventoryPlayer(entity.getInventory());
        this.enderChest = new CraftInventory(entity.getEnderChestInventory());
    }

    public PlayerInventory getInventory() {
        return this.inventory;
    }

    @Override
    public EntityEquipment getEquipment() {
        return this.inventory;
    }

    public Inventory getEnderChest() {
        return this.enderChest;
    }

    public MainHand getMainHand() {
        return this.getHandle().getMainArm() == HumanoidArm.LEFT ? MainHand.LEFT : MainHand.RIGHT;
    }

    public boolean isModelPartShown(PlayerModelPart part) {
        Preconditions.checkArgument((part != null ? 1 : 0) != 0, (Object)"part cannot be null");
        net.minecraft.world.entity.player.PlayerModelPart nms = net.minecraft.world.entity.player.PlayerModelPart.valueOf(part.name());
        return this.getHandle().isModelPartShown(nms);
    }

    public ItemStack getItemInHand() {
        return this.getInventory().getItemInHand();
    }

    public void setItemInHand(ItemStack item) {
        this.getInventory().setItemInHand(item);
    }

    public ItemStack getItemOnCursor() {
        return CraftItemStack.asCraftMirror(this.getHandle().containerMenu.getCarried());
    }

    public void setItemOnCursor(ItemStack item) {
        net.minecraft.world.item.ItemStack stack = CraftItemStack.asNMSCopy(item);
        this.getHandle().containerMenu.setCarried(stack);
        if (this instanceof CraftPlayer) {
            this.getHandle().containerMenu.broadcastCarriedItem();
        }
    }

    public int getSleepTicks() {
        return this.getHandle().sleepCounter;
    }

    public boolean sleep(Location location, boolean force) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location needs to be in a world");
        Preconditions.checkArgument((boolean)location.getWorld().equals((Object)this.getWorld()), (Object)"Cannot sleep across worlds");
        BlockPos blockposition = CraftLocation.toBlockPosition(location);
        BlockState iblockdata = this.getHandle().level().getBlockState(blockposition);
        if (!(iblockdata.getBlock() instanceof BedBlock)) {
            return false;
        }
        if (this.getHandle().startSleepInBed(blockposition, force).left().isPresent()) {
            return false;
        }
        iblockdata = (BlockState)iblockdata.setValue(BedBlock.OCCUPIED, true);
        this.getHandle().level().setBlock(blockposition, iblockdata, 4);
        return true;
    }

    public void wakeup(boolean setSpawnLocation) {
        Preconditions.checkState((boolean)this.isSleeping(), (Object)"Cannot wakeup if not sleeping");
        this.getHandle().stopSleepInBed(true, setSpawnLocation);
    }

    public void startRiptideAttack(int duration, float damage, ItemStack attackItem) {
        Preconditions.checkArgument((duration > 0 ? 1 : 0) != 0, (Object)"Duration must be greater than 0");
        Preconditions.checkArgument((damage >= 0.0f ? 1 : 0) != 0, (Object)"Damage must not be negative");
        this.getHandle().startAutoSpinAttack(duration, damage, CraftItemStack.asNMSCopy(attackItem));
    }

    public Location getBedLocation() {
        Preconditions.checkState((boolean)this.isSleeping(), (Object)"Not sleeping");
        BlockPos bed = this.getHandle().getSleepingPos().get();
        return CraftLocation.toBukkit(bed, this.getWorld());
    }

    @Override
    public String getName() {
        return this.getHandle().getScoreboardName();
    }

    @Override
    public boolean isOp() {
        return this.op;
    }

    @Override
    public boolean isPermissionSet(String name) {
        return this.perm.isPermissionSet(name);
    }

    @Override
    public boolean isPermissionSet(Permission perm) {
        return this.perm.isPermissionSet(perm);
    }

    @Override
    public boolean hasPermission(String name) {
        return this.perm.hasPermission(name);
    }

    @Override
    public boolean hasPermission(Permission perm) {
        return this.perm.hasPermission(perm);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value) {
        return this.perm.addAttachment(plugin, name, value);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin) {
        return this.perm.addAttachment(plugin);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value, int ticks) {
        return this.perm.addAttachment(plugin, name, value, ticks);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, int ticks) {
        return this.perm.addAttachment(plugin, ticks);
    }

    @Override
    public void removeAttachment(PermissionAttachment attachment) {
        this.perm.removeAttachment(attachment);
    }

    @Override
    public void recalculatePermissions() {
        this.perm.recalculatePermissions();
    }

    @Override
    public void setOp(boolean value) {
        this.op = value;
        this.perm.recalculatePermissions();
    }

    @Override
    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        return this.perm.getEffectivePermissions();
    }

    public GameMode getGameMode() {
        return this.mode;
    }

    public void setGameMode(GameMode mode) {
        Preconditions.checkArgument((mode != null ? 1 : 0) != 0, (Object)"GameMode cannot be null");
        this.mode = mode;
    }

    @Override
    public Player getHandle() {
        return (Player)this.entity;
    }

    public void setHandle(Player entity) {
        super.setHandle(entity);
        this.inventory = new CraftInventoryPlayer(entity.getInventory());
    }

    @Override
    public String toString() {
        return "CraftHumanEntity{id=" + this.getEntityId() + "name=" + this.getName() + "}";
    }

    public InventoryView getOpenInventory() {
        return this.getHandle().containerMenu.getBukkitView();
    }

    public InventoryView openInventory(Inventory inventory) {
        InventoryHolder inventoryHolder;
        BlockEntity te;
        CraftInventory craft;
        if (!(this.getHandle() instanceof ServerPlayer)) {
            return null;
        }
        ServerPlayer player = (ServerPlayer)this.getHandle();
        AbstractContainerMenu formerContainer = this.getHandle().containerMenu;
        MenuProvider tileInventory = null;
        if (inventory instanceof CraftInventoryDoubleChest) {
            tileInventory = ((CraftInventoryDoubleChest)inventory).tile;
        } else if (inventory instanceof CraftInventoryLectern) {
            tileInventory = ((CraftInventoryLectern)inventory).tile;
        } else if (inventory instanceof CraftInventory && (craft = (CraftInventory)inventory).getInventory() instanceof MenuProvider) {
            tileInventory = (MenuProvider)((Object)craft.getInventory());
        }
        if (tileInventory instanceof MenuProvider && tileInventory instanceof BlockEntity && !(te = (BlockEntity)((Object)tileInventory)).hasLevel()) {
            te.setLevel(this.getHandle().level());
        }
        if (tileInventory instanceof MenuProvider) {
            this.getHandle().openMenu(tileInventory);
        } else if (inventory instanceof CraftInventoryAbstractHorse && (inventoryHolder = (craft = (CraftInventoryAbstractHorse)inventory).getInventory().getOwner()) instanceof CraftAbstractHorse) {
            CraftAbstractHorse horse = (CraftAbstractHorse)inventoryHolder;
            this.getHandle().openHorseInventory(horse.getHandle(), craft.getInventory());
        } else {
            MenuType container = CraftContainer.getNotchInventoryType(inventory);
            CraftHumanEntity.openCustomInventory(inventory, player, container);
        }
        if (this.getHandle().containerMenu == formerContainer) {
            return null;
        }
        this.getHandle().containerMenu.checkReachable = false;
        return this.getHandle().containerMenu.getBukkitView();
    }

    private static void openCustomInventory(Inventory inventory, ServerPlayer player, MenuType<?> windowType) {
        if (player.connection == null) {
            return;
        }
        Preconditions.checkArgument((windowType != null ? 1 : 0) != 0, (Object)"Unknown windowType");
        AbstractContainerMenu container = new CraftContainer(inventory, (Player)player, player.nextContainerCounter());
        container = CraftEventFactory.callInventoryOpenEvent(player, container);
        if (container == null) {
            return;
        }
        String title = container.getBukkitView().getTitle();
        player.connection.send(new ClientboundOpenScreenPacket(container.containerId, windowType, CraftChatMessage.fromString(title)[0]));
        player.containerMenu = container;
        player.initMenu(container);
    }

    public InventoryView openWorkbench(Location location, boolean force) {
        Block block;
        if (location == null) {
            location = this.getLocation();
        }
        if (!force && (block = location.getBlock()).getType() != Material.CRAFTING_TABLE) {
            return null;
        }
        this.getHandle().openMenu(Blocks.CRAFTING_TABLE.defaultBlockState().getMenuProvider(this.getHandle().level(), CraftLocation.toBlockPosition(location)));
        if (force) {
            this.getHandle().containerMenu.checkReachable = false;
        }
        return this.getHandle().containerMenu.getBukkitView();
    }

    public InventoryView openEnchanting(Location location, boolean force) {
        Block block;
        if (location == null) {
            location = this.getLocation();
        }
        if (!force && (block = location.getBlock()).getType() != Material.ENCHANTING_TABLE) {
            return null;
        }
        BlockPos pos = CraftLocation.toBlockPosition(location);
        this.getHandle().openMenu(Blocks.ENCHANTING_TABLE.defaultBlockState().getMenuProvider(this.getHandle().level(), pos));
        if (force) {
            this.getHandle().containerMenu.checkReachable = false;
        }
        return this.getHandle().containerMenu.getBukkitView();
    }

    public void openInventory(InventoryView inventory) {
        Preconditions.checkArgument((boolean)this.equals(inventory.getPlayer()), (Object)"InventoryView must belong to the opening player");
        if (!(this.getHandle() instanceof ServerPlayer)) {
            return;
        }
        if (((ServerPlayer)this.getHandle()).connection == null) {
            return;
        }
        if (this.getHandle().containerMenu != this.getHandle().inventoryMenu) {
            ((ServerPlayer)this.getHandle()).connection.handleContainerClose(new ServerboundContainerClosePacket(this.getHandle().containerMenu.containerId));
        }
        ServerPlayer player = (ServerPlayer)this.getHandle();
        AbstractContainerMenu container = inventory instanceof CraftInventoryView ? ((CraftInventoryView)inventory).getHandle() : new CraftContainer(inventory, this.getHandle(), player.nextContainerCounter());
        if ((container = CraftEventFactory.callInventoryOpenEvent(player, container)) == null) {
            return;
        }
        MenuType windowType = CraftContainer.getNotchInventoryType(inventory.getTopInventory());
        if (windowType == MenuType.MERCHANT) {
            CraftMenus.openMerchantMenu(player, (MerchantMenu)container);
            return;
        }
        String title = inventory.getTitle();
        player.connection.send(new ClientboundOpenScreenPacket(container.containerId, windowType, CraftChatMessage.fromString(title)[0]));
        player.containerMenu = container;
        player.initMenu(container);
    }

    public InventoryView openMerchant(Villager villager, boolean force) {
        Preconditions.checkNotNull((Object)villager, (Object)"villager cannot be null");
        return this.openMerchant((Merchant)villager, force);
    }

    public InventoryView openMerchant(Merchant merchant, boolean force) {
        Component name;
        net.minecraft.world.item.trading.Merchant mcMerchant;
        Preconditions.checkNotNull((Object)merchant, (Object)"merchant cannot be null");
        if (!force && merchant.isTrading()) {
            return null;
        }
        if (merchant.isTrading()) {
            merchant.getTrader().closeInventory();
        }
        int level = 1;
        if (merchant instanceof CraftAbstractVillager) {
            mcMerchant = ((CraftAbstractVillager)merchant).getHandle();
            name = ((CraftAbstractVillager)merchant).getHandle().getDisplayName();
            if (merchant instanceof CraftVillager) {
                level = ((CraftVillager)merchant).getHandle().getVillagerData().level();
            }
        } else if (merchant instanceof CraftMerchantCustom) {
            mcMerchant = ((CraftMerchantCustom)merchant).getMerchant();
            name = ((CraftMerchantCustom)merchant).getMerchant().getScoreboardDisplayName();
        } else {
            throw new IllegalArgumentException("Can't open merchant " + merchant.toString());
        }
        mcMerchant.setTradingPlayer(this.getHandle());
        mcMerchant.openTradingScreen(this.getHandle(), name, level);
        return this.getHandle().containerMenu.getBukkitView();
    }

    public void closeInventory() {
        this.getHandle().closeContainer();
    }

    public boolean isBlocking() {
        return this.getHandle().isBlocking();
    }

    public boolean isHandRaised() {
        return this.getHandle().isUsingItem();
    }

    public boolean setWindowProperty(InventoryView.Property prop, int value) {
        return false;
    }

    public int getEnchantmentSeed() {
        return this.getHandle().enchantmentSeed;
    }

    public void setEnchantmentSeed(int i) {
        this.getHandle().enchantmentSeed = i;
    }

    public int getExpToLevel() {
        return this.getHandle().getXpNeededForNextLevel();
    }

    public float getAttackCooldown() {
        return this.getHandle().getAttackStrengthScale(0.5f);
    }

    public boolean hasCooldown(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((boolean)material.isItem(), (String)"Material %s is not an item", (Object)material);
        return this.hasCooldown(new ItemStack(material));
    }

    public int getCooldown(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((boolean)material.isItem(), (String)"Material %s is not an item", (Object)material);
        return this.getCooldown(new ItemStack(material));
    }

    public void setCooldown(Material material, int ticks) {
        this.setCooldown(new ItemStack(material), ticks);
    }

    public boolean hasCooldown(ItemStack item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        return this.getHandle().getCooldowns().isOnCooldown(CraftItemStack.asNMSCopy(item));
    }

    public int getCooldown(ItemStack item) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Identifier group = this.getHandle().getCooldowns().getCooldownGroup(CraftItemStack.asNMSCopy(item));
        if (group == null) {
            return 0;
        }
        ItemCooldowns.CooldownInstance cooldown = this.getHandle().getCooldowns().cooldowns.get(group);
        return cooldown == null ? 0 : Math.max(0, cooldown.endTime() - this.getHandle().getCooldowns().tickCount);
    }

    public void setCooldown(ItemStack item, int ticks) {
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"Cannot have negative cooldown");
        this.getHandle().getCooldowns().addCooldown(CraftItemStack.asNMSCopy(item), ticks);
    }

    public boolean discoverRecipe(NamespacedKey recipe) {
        return this.discoverRecipes(Arrays.asList(recipe)) != 0;
    }

    public int discoverRecipes(Collection<NamespacedKey> recipes) {
        return this.getHandle().awardRecipes(this.bukkitKeysToMinecraftRecipes(recipes));
    }

    public boolean undiscoverRecipe(NamespacedKey recipe) {
        return this.undiscoverRecipes(Arrays.asList(recipe)) != 0;
    }

    public int undiscoverRecipes(Collection<NamespacedKey> recipes) {
        return this.getHandle().resetRecipes(this.bukkitKeysToMinecraftRecipes(recipes));
    }

    public boolean hasDiscoveredRecipe(NamespacedKey recipe) {
        return false;
    }

    public Set<NamespacedKey> getDiscoveredRecipes() {
        return ImmutableSet.of();
    }

    private Collection<RecipeHolder<?>> bukkitKeysToMinecraftRecipes(Collection<NamespacedKey> recipeKeys) {
        ArrayList recipes = new ArrayList();
        RecipeManager manager = this.getHandle().level().getServer().getRecipeManager();
        for (NamespacedKey recipeKey : recipeKeys) {
            Optional<RecipeHolder<?>> recipe = manager.byKey(CraftRecipe.toMinecraft(recipeKey));
            if (!recipe.isPresent()) continue;
            recipes.add(recipe.get());
        }
        return recipes;
    }

    public Entity getShoulderEntityLeft() {
        Player player = this.getHandle();
        if (!(player instanceof ServerPlayer)) {
            return null;
        }
        ServerPlayer handle = (ServerPlayer)player;
        if (!handle.getShoulderEntityLeft().isEmpty()) {
            net.minecraft.world.entity.Entity shoulder = handle.getEntityOnShoulder(handle.getShoulderEntityLeft());
            return shoulder == null ? null : shoulder.getBukkitEntity();
        }
        return null;
    }

    public void setShoulderEntityLeft(Entity entity) {
        Player player = this.getHandle();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer handle = (ServerPlayer)player;
        handle.setShoulderEntityLeft(entity == null ? new CompoundTag() : ((CraftEntity)entity).save());
        if (entity != null) {
            entity.remove();
        }
    }

    public Entity getShoulderEntityRight() {
        Player player = this.getHandle();
        if (!(player instanceof ServerPlayer)) {
            return null;
        }
        ServerPlayer handle = (ServerPlayer)player;
        if (!handle.getShoulderEntityRight().isEmpty()) {
            net.minecraft.world.entity.Entity shoulder = handle.getEntityOnShoulder(handle.getShoulderEntityRight());
            return shoulder == null ? null : shoulder.getBukkitEntity();
        }
        return null;
    }

    public void setShoulderEntityRight(Entity entity) {
        Player player = this.getHandle();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer handle = (ServerPlayer)player;
        handle.setShoulderEntityRight(entity == null ? new CompoundTag() : ((CraftEntity)entity).save());
        if (entity != null) {
            entity.remove();
        }
    }

    public boolean dropItem(boolean dropAll) {
        if (!(this.getHandle() instanceof ServerPlayer)) {
            return false;
        }
        return ((ServerPlayer)this.getHandle()).dropItem(dropAll) != null;
    }

    public float getExhaustion() {
        return this.getHandle().getFoodData().exhaustionLevel;
    }

    public void setExhaustion(float value) {
        this.getHandle().getFoodData().exhaustionLevel = value;
    }

    public float getSaturation() {
        return this.getHandle().getFoodData().saturationLevel;
    }

    public void setSaturation(float value) {
        this.getHandle().getFoodData().saturationLevel = value;
    }

    public int getFoodLevel() {
        return this.getHandle().getFoodData().foodLevel;
    }

    public void setFoodLevel(int value) {
        this.getHandle().getFoodData().foodLevel = value;
    }

    public int getSaturatedRegenRate() {
        return this.getHandle().getFoodData().saturatedRegenRate;
    }

    public void setSaturatedRegenRate(int i) {
        this.getHandle().getFoodData().saturatedRegenRate = i;
    }

    public int getUnsaturatedRegenRate() {
        return this.getHandle().getFoodData().unsaturatedRegenRate;
    }

    public void setUnsaturatedRegenRate(int i) {
        this.getHandle().getFoodData().unsaturatedRegenRate = i;
    }

    public int getStarvationRate() {
        return this.getHandle().getFoodData().starvationRate;
    }

    public void setStarvationRate(int i) {
        this.getHandle().getFoodData().starvationRate = i;
    }

    public Location getLastDeathLocation() {
        return this.getHandle().getLastDeathLocation().map(CraftMemoryMapper::fromNms).orElse(null);
    }

    public void setLastDeathLocation(Location location) {
        if (location == null) {
            this.getHandle().setLastDeathLocation(Optional.empty());
        } else {
            this.getHandle().setLastDeathLocation(Optional.of(CraftMemoryMapper.toNms(location)));
        }
    }

    public Firework fireworkBoost(ItemStack fireworkItemStack) {
        Preconditions.checkArgument((fireworkItemStack != null ? 1 : 0) != 0, (Object)"fireworkItemStack must not be null");
        Preconditions.checkArgument((fireworkItemStack.getType() == Material.FIREWORK_ROCKET ? 1 : 0) != 0, (String)"fireworkItemStack must be of type %s", (Object)Material.FIREWORK_ROCKET);
        FireworkRocketEntity fireworks = new FireworkRocketEntity(this.getHandle().level(), CraftItemStack.asNMSCopy(fireworkItemStack), this.getHandle());
        boolean success = this.getHandle().level().addFreshEntity(fireworks, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return success ? (Firework)fireworks.getBukkitEntity() : null;
    }

    @Override
    public Entity copy() {
        throw new UnsupportedOperationException("Cannot copy human entities");
    }

    @Override
    public Entity copy(Location location) {
        throw new UnsupportedOperationException("Cannot copy human entities");
    }
}

