/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Pose;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R7.profile.CraftPlayerProfile;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftChatMessage;
import org.bukkit.entity.Mannequin;
import org.bukkit.entity.model.PlayerModelPart;
import org.bukkit.inventory.MainHand;
import org.bukkit.profile.PlayerProfile;

public class CraftMannequin
extends CraftLivingEntity
implements Mannequin {
    public CraftMannequin(CraftServer server, net.minecraft.world.entity.decoration.Mannequin entity) {
        super(server, entity);
    }

    @Override
    public String toString() {
        return "CraftMannequin";
    }

    @Override
    public net.minecraft.world.entity.decoration.Mannequin getHandle() {
        return (net.minecraft.world.entity.decoration.Mannequin)super.getHandle();
    }

    public MainHand getMainHand() {
        return this.getHandle().getMainArm() == HumanoidArm.LEFT ? MainHand.LEFT : MainHand.RIGHT;
    }

    public void setMainHand(MainHand hand) {
        Preconditions.checkArgument((hand != null ? 1 : 0) != 0, (Object)"hand cannot be null");
        this.getHandle().setMainArm(hand == MainHand.LEFT ? HumanoidArm.LEFT : HumanoidArm.RIGHT);
    }

    public boolean isModelPartShown(PlayerModelPart part) {
        Preconditions.checkArgument((part != null ? 1 : 0) != 0, (Object)"part cannot be null");
        net.minecraft.world.entity.player.PlayerModelPart nms = net.minecraft.world.entity.player.PlayerModelPart.valueOf(part.name());
        return this.getHandle().isModelPartShown(nms);
    }

    public void setModelPartShown(PlayerModelPart part, boolean shown) {
        Preconditions.checkArgument((part != null ? 1 : 0) != 0, (Object)"part cannot be null");
        net.minecraft.world.entity.player.PlayerModelPart nms = net.minecraft.world.entity.player.PlayerModelPart.valueOf(part.name());
        byte flags = this.getHandle().getEntityData().get(Avatar.DATA_PLAYER_MODE_CUSTOMISATION);
        flags = shown ? (byte)(flags | nms.getMask()) : (byte)(flags & ~nms.getMask());
        this.getHandle().getEntityData().set(Avatar.DATA_PLAYER_MODE_CUSTOMISATION, flags);
    }

    public PlayerProfile getPlayerProfile() {
        return this.getHandle().getProfile().equals(net.minecraft.world.entity.decoration.Mannequin.DEFAULT_PROFILE) ? null : new CraftPlayerProfile(this.getHandle().getProfile());
    }

    public void setPlayerProfile(PlayerProfile profile) {
        if (profile instanceof CraftPlayerProfile) {
            CraftPlayerProfile craftPlayerProfile = (CraftPlayerProfile)profile;
            this.getHandle().setProfile(craftPlayerProfile.buildResolvableProfile());
        } else {
            this.getHandle().setProfile(net.minecraft.world.entity.decoration.Mannequin.DEFAULT_PROFILE);
        }
    }

    public void setPose(org.bukkit.entity.Pose pose) {
        Preconditions.checkArgument((pose != null ? 1 : 0) != 0, (Object)"pose cannot be null");
        Pose nmsPose = Pose.values()[pose.ordinal()];
        Preconditions.checkArgument((boolean)net.minecraft.world.entity.decoration.Mannequin.VALID_POSES.contains(nmsPose));
        this.getHandle().setPose(nmsPose);
    }

    public boolean isImmovable() {
        return this.getHandle().getImmovable();
    }

    public void setImmovable(boolean immovable) {
        this.getHandle().setImmovable(immovable);
    }

    public String getDescripion() {
        Component description = this.getHandle().description;
        return description != null ? CraftChatMessage.fromComponent(description) : null;
    }

    public void setDescription(String description) {
        if (description != null) {
            this.getHandle().setDescription(CraftChatMessage.fromStringOrNull(description));
        } else {
            this.getHandle().setDescription(net.minecraft.world.entity.decoration.Mannequin.DEFAULT_DESCRIPTION);
        }
    }

    public boolean isHideDescription() {
        return this.getHandle().hideDescription;
    }

    public void setHideDescription(boolean hide) {
        this.getHandle().setHideDescription(hide);
    }
}

