/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.pig.PigVariant;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_21_R7.registry.CraftRegistryItem;
import org.bukkit.entity.Pig;

public class CraftPig
extends CraftAnimals
implements Pig {
    public CraftPig(CraftServer server, net.minecraft.world.entity.animal.pig.Pig entity) {
        super(server, entity);
    }

    public boolean hasSaddle() {
        return this.getHandle().isSaddled();
    }

    public void setSaddle(boolean saddled) {
        this.getHandle().setItemSlot(EquipmentSlot.SADDLE, saddled ? new ItemStack(Items.SADDLE) : ItemStack.EMPTY);
    }

    public int getBoostTicks() {
        return this.getHandle().steering.boosting ? this.getHandle().steering.boostTimeTotal() : 0;
    }

    public void setBoostTicks(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks must be >= 0");
        this.getHandle().steering.setBoostTicks(ticks);
    }

    public int getCurrentBoostTicks() {
        return this.getHandle().steering.boosting ? this.getHandle().steering.boostTime : 0;
    }

    public void setCurrentBoostTicks(int ticks) {
        if (!this.getHandle().steering.boosting) {
            return;
        }
        int max = this.getHandle().steering.boostTimeTotal();
        Preconditions.checkArgument((ticks >= 0 && ticks <= max ? 1 : 0) != 0, (String)"boost ticks must not exceed 0 or %d (inclusive)", (int)max);
        this.getHandle().steering.boostTime = ticks;
    }

    public Material getSteerMaterial() {
        return Material.CARROT_ON_A_STICK;
    }

    public Pig.Variant getVariant() {
        return CraftVariant.minecraftHolderToBukkit(this.getHandle().getVariant());
    }

    public void setVariant(Pig.Variant variant) {
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"variant");
        this.getHandle().setVariant(CraftVariant.bukkitToMinecraftHolder(variant));
    }

    @Override
    public net.minecraft.world.entity.animal.pig.Pig getHandle() {
        return (net.minecraft.world.entity.animal.pig.Pig)this.entity;
    }

    @Override
    public String toString() {
        return "CraftPig";
    }

    public static class CraftVariant
    extends CraftRegistryItem<PigVariant>
    implements Pig.Variant {
        public static Pig.Variant minecraftToBukkit(PigVariant minecraft) {
            return (Pig.Variant)CraftRegistry.minecraftToBukkit(minecraft, Registries.PIG_VARIANT, Registry.PIG_VARIANT);
        }

        public static Pig.Variant minecraftHolderToBukkit(Holder<PigVariant> minecraft) {
            return CraftVariant.minecraftToBukkit(minecraft.value());
        }

        public static PigVariant bukkitToMinecraft(Pig.Variant bukkit) {
            return (PigVariant)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static Holder<PigVariant> bukkitToMinecraftHolder(Pig.Variant bukkit) {
            return CraftRegistry.bukkitToMinecraftHolder(bukkit, Registries.PIG_VARIANT);
        }

        public CraftVariant(NamespacedKey key, Holder<PigVariant> handle) {
            super(key, handle);
        }

        public NamespacedKey getKey() {
            return this.getKeyOrThrow();
        }
    }
}

