/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.monster.zombie.Zombie;
import net.minecraft.world.entity.npc.villager.VillagerProfession;
import net.minecraft.world.entity.npc.villager.VillagerType;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_21_R7.registry.CraftOldEnumRegistryItem;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R7.util.Handleable;
import org.bukkit.entity.Villager;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTransformEvent;

public class CraftVillager
extends CraftAbstractVillager
implements Villager {
    public CraftVillager(CraftServer server, net.minecraft.world.entity.npc.villager.Villager entity) {
        super(server, entity);
    }

    @Override
    public net.minecraft.world.entity.npc.villager.Villager getHandle() {
        return (net.minecraft.world.entity.npc.villager.Villager)this.entity;
    }

    @Override
    public String toString() {
        return "CraftVillager";
    }

    @Override
    public void remove() {
        this.getHandle().releaseAllPois();
        super.remove();
    }

    public Villager.Profession getProfession() {
        return CraftProfession.minecraftHolderToBukkit(this.getHandle().getVillagerData().profession());
    }

    public void setProfession(Villager.Profession profession) {
        Preconditions.checkArgument((profession != null ? 1 : 0) != 0, (Object)"Profession cannot be null");
        this.getHandle().setVillagerData(this.getHandle().getVillagerData().withProfession(CraftProfession.bukkitToMinecraftHolder(profession)));
    }

    public Villager.Type getVillagerType() {
        return CraftType.minecraftHolderToBukkit(this.getHandle().getVillagerData().type());
    }

    public void setVillagerType(Villager.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Type cannot be null");
        this.getHandle().setVillagerData(this.getHandle().getVillagerData().withType(CraftType.bukkitToMinecraftHolder(type)));
    }

    public int getVillagerLevel() {
        return this.getHandle().getVillagerData().level();
    }

    public void setVillagerLevel(int level) {
        Preconditions.checkArgument((1 <= level && level <= 5 ? 1 : 0) != 0, (String)"level (%s) must be between [1, 5]", (int)level);
        this.getHandle().setVillagerData(this.getHandle().getVillagerData().withLevel(level));
    }

    public int getVillagerExperience() {
        return this.getHandle().getVillagerXp();
    }

    public void setVillagerExperience(int experience) {
        Preconditions.checkArgument((experience >= 0 ? 1 : 0) != 0, (String)"Experience (%s) must be positive", (int)experience);
        this.getHandle().setVillagerXp(experience);
    }

    public boolean sleep(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location needs to be in a world");
        Preconditions.checkArgument((boolean)location.getWorld().equals((Object)this.getWorld()), (Object)"Cannot sleep across worlds");
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot sleep during world generation");
        BlockPos position = CraftLocation.toBlockPosition(location);
        BlockState iblockdata = this.getHandle().level().getBlockState(position);
        if (!(iblockdata.getBlock() instanceof BedBlock)) {
            return false;
        }
        this.getHandle().startSleeping(position);
        return true;
    }

    public void wakeup() {
        Preconditions.checkState((boolean)this.isSleeping(), (Object)"Cannot wakeup if not sleeping");
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot wakeup during world generation");
        this.getHandle().stopSleeping();
    }

    public void shakeHead() {
        this.getHandle().setUnhappy();
    }

    public ZombieVillager zombify() {
        net.minecraft.world.entity.monster.zombie.ZombieVillager entityzombievillager = Zombie.convertVillagerToZombieVillager(this.getHandle().level().getMinecraftWorld(), this.getHandle(), this.getHandle().blockPosition(), this.isSilent(), EntityTransformEvent.TransformReason.INFECTION, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return entityzombievillager != null ? (ZombieVillager)entityzombievillager.getBukkitEntity() : null;
    }

    public int getReputation(UUID uuid, Villager.ReputationType reputationType) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID cannot be null");
        Preconditions.checkArgument((reputationType != null ? 1 : 0) != 0, (Object)"Reputation type cannot be null");
        return this.getHandle().getGossips().getReputation(uuid, Predicate.isEqual(CraftReputationType.bukkitToMinecraft(reputationType)), false);
    }

    public int getWeightedReputation(UUID uuid, Villager.ReputationType reputationType) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID cannot be null");
        Preconditions.checkArgument((reputationType != null ? 1 : 0) != 0, (Object)"Reputation type cannot be null");
        return this.getHandle().getGossips().getReputation(uuid, Predicate.isEqual(CraftReputationType.bukkitToMinecraft(reputationType)), true);
    }

    public int getReputation(UUID uuid) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID cannot be null");
        return this.getHandle().getGossips().getReputation(uuid, (GossipType reputationType) -> true);
    }

    public void addReputation(UUID uuid, Villager.ReputationType reputationType, int amount) {
        this.addReputation(uuid, reputationType, amount, Villager.ReputationEvent.UNSPECIFIED);
    }

    public void addReputation(UUID uuid, Villager.ReputationType reputationType, int amount, Villager.ReputationEvent changeReason) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID cannot be null");
        Preconditions.checkArgument((reputationType != null ? 1 : 0) != 0, (Object)"Reputation type cannot be null");
        Preconditions.checkArgument((changeReason != null ? 1 : 0) != 0, (Object)"Change reason cannot be null");
        this.getHandle().getGossips().add(uuid, CraftReputationType.bukkitToMinecraft(reputationType), amount, changeReason);
    }

    public void removeReputation(UUID uuid, Villager.ReputationType reputationType, int amount) {
        this.removeReputation(uuid, reputationType, amount, Villager.ReputationEvent.UNSPECIFIED);
    }

    public void removeReputation(UUID uuid, Villager.ReputationType reputationType, int amount, Villager.ReputationEvent changeReason) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID cannot be null");
        Preconditions.checkArgument((reputationType != null ? 1 : 0) != 0, (Object)"Reputation type cannot be null");
        Preconditions.checkArgument((changeReason != null ? 1 : 0) != 0, (Object)"Change reason cannot be null");
        this.getHandle().getGossips().remove(uuid, CraftReputationType.bukkitToMinecraft(reputationType), amount, changeReason);
    }

    public void setReputation(UUID uuid, Villager.ReputationType reputationType, int amount) {
        this.setReputation(uuid, reputationType, amount, Villager.ReputationEvent.UNSPECIFIED);
    }

    public void setReputation(UUID uuid, Villager.ReputationType reputationType, int amount, Villager.ReputationEvent changeReason) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID cannot be null");
        Preconditions.checkArgument((reputationType != null ? 1 : 0) != 0, (Object)"Reputation type cannot be null");
        Preconditions.checkArgument((changeReason != null ? 1 : 0) != 0, (Object)"Change reason cannot be null");
        this.getHandle().getGossips().set(uuid, CraftReputationType.bukkitToMinecraft(reputationType), amount, changeReason);
    }

    public void setGossipDecayTime(long ticks) {
        this.getHandle().gossipDecayInterval = ticks;
    }

    public long getGossipDecayTime() {
        return this.getHandle().gossipDecayInterval;
    }

    public static class CraftProfession
    extends CraftOldEnumRegistryItem<Villager.Profession, VillagerProfession>
    implements Villager.Profession {
        private static int count = 0;

        public static Villager.Profession minecraftToBukkit(VillagerProfession minecraft) {
            return (Villager.Profession)CraftRegistry.minecraftToBukkit(minecraft, Registries.VILLAGER_PROFESSION, Registry.VILLAGER_PROFESSION);
        }

        public static Villager.Profession minecraftHolderToBukkit(Holder<VillagerProfession> minecraft) {
            return CraftProfession.minecraftToBukkit(minecraft.value());
        }

        public static VillagerProfession bukkitToMinecraft(Villager.Profession bukkit) {
            return (VillagerProfession)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static Holder<VillagerProfession> bukkitToMinecraftHolder(Villager.Profession bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            net.minecraft.core.Registry registry = CraftRegistry.getMinecraftRegistry(Registries.VILLAGER_PROFESSION);
            Holder<VillagerProfession> holder = registry.wrapAsHolder(CraftProfession.bukkitToMinecraft(bukkit));
            if (holder instanceof Holder.Reference) {
                Holder.Reference holder2 = (Holder.Reference)holder;
                return holder2;
            }
            throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own villager profession without properly registering it.");
        }

        public CraftProfession(NamespacedKey key, Holder<VillagerProfession> handle) {
            super(key, handle, count++);
        }

        public NamespacedKey getKey() {
            return this.getKeyOrThrow();
        }
    }

    public static class CraftType
    extends CraftOldEnumRegistryItem<Villager.Type, VillagerType>
    implements Villager.Type {
        private static int count = 0;

        public static Villager.Type minecraftToBukkit(VillagerType minecraft) {
            return (Villager.Type)CraftRegistry.minecraftToBukkit(minecraft, Registries.VILLAGER_TYPE, Registry.VILLAGER_TYPE);
        }

        public static Villager.Type minecraftHolderToBukkit(Holder<VillagerType> minecraft) {
            return CraftType.minecraftToBukkit(minecraft.value());
        }

        public static VillagerType bukkitToMinecraft(Villager.Type bukkit) {
            return (VillagerType)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static Holder<VillagerType> bukkitToMinecraftHolder(Villager.Type bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            net.minecraft.core.Registry registry = CraftRegistry.getMinecraftRegistry(Registries.VILLAGER_TYPE);
            Holder<VillagerType> holder = registry.wrapAsHolder(CraftType.bukkitToMinecraft(bukkit));
            if (holder instanceof Holder.Reference) {
                Holder.Reference holder2 = (Holder.Reference)holder;
                return holder2;
            }
            throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own villager type without properly registering it.");
        }

        public CraftType(NamespacedKey key, Holder<VillagerType> handle) {
            super(key, handle, count++);
        }

        public NamespacedKey getKey() {
            return this.getKeyOrThrow();
        }
    }

    public static class CraftReputationType
    implements Villager.ReputationType,
    Handleable<GossipType> {
        public static final Map<String, CraftReputationType> BY_ID = Stream.of(GossipType.values()).collect(Collectors.toMap(reputationType -> reputationType.id, CraftReputationType::new));
        private final GossipType handle;

        public CraftReputationType(GossipType handle) {
            this.handle = handle;
        }

        @Override
        public GossipType getHandle() {
            return this.handle;
        }

        public int getMaxValue() {
            return this.handle.max;
        }

        public int getWeight() {
            return this.handle.weight;
        }

        public static GossipType bukkitToMinecraft(Villager.ReputationType bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            return ((CraftReputationType)bukkit).getHandle();
        }

        public static Villager.ReputationType minecraftToBukkit(GossipType minecraft) {
            Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
            return switch (minecraft) {
                default -> throw new MatchException(null, null);
                case GossipType.MAJOR_NEGATIVE -> Villager.ReputationType.MAJOR_NEGATIVE;
                case GossipType.MINOR_NEGATIVE -> Villager.ReputationType.MINOR_NEGATIVE;
                case GossipType.MINOR_POSITIVE -> Villager.ReputationType.MINOR_POSITIVE;
                case GossipType.MAJOR_POSITIVE -> Villager.ReputationType.MAJOR_POSITIVE;
                case GossipType.TRADING -> Villager.ReputationType.TRADING;
            };
        }
    }

    public static class CraftReputationEvent
    implements Villager.ReputationEvent,
    Handleable<ReputationEventType> {
        private static final Map<String, Villager.ReputationEvent> ALL = Maps.newHashMap();
        private final ReputationEventType handle;

        public CraftReputationEvent(ReputationEventType handle) {
            this.handle = handle;
            ALL.put(handle.toString(), this);
        }

        @Override
        public ReputationEventType getHandle() {
            return this.handle;
        }

        public static ReputationEventType bukkitToMinecraft(Villager.ReputationEvent bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            return ((CraftReputationEvent)bukkit).getHandle();
        }

        public static Villager.ReputationEvent minecraftToBukkit(ReputationEventType minecraft) {
            Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
            Villager.ReputationEvent bukkit = ALL.get(minecraft.toString());
            return bukkit == null ? new CraftReputationEvent(minecraft) : bukkit;
        }
    }
}

