/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.help;

import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.MultipleCommandAlias;
import org.bukkit.help.HelpTopic;

public class MultipleCommandAliasHelpTopic
extends HelpTopic {
    private final MultipleCommandAlias alias;

    public MultipleCommandAliasHelpTopic(MultipleCommandAlias alias) {
        this.alias = alias;
        this.name = "/" + alias.getLabel();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < alias.getCommands().length; ++i) {
            if (i != 0) {
                sb.append(String.valueOf(ChatColor.GOLD) + " > " + String.valueOf(ChatColor.WHITE));
            }
            sb.append("/");
            sb.append(alias.getCommands()[i].getLabel());
        }
        this.shortText = sb.toString();
        this.fullText = String.valueOf(ChatColor.GOLD) + "Alias for: " + String.valueOf(ChatColor.WHITE) + this.getShortText();
    }

    public boolean canSee(CommandSender sender) {
        if (this.amendedPermission == null) {
            if (sender instanceof ConsoleCommandSender) {
                return true;
            }
            for (Command command : this.alias.getCommands()) {
                if (command.testPermissionSilent(sender)) continue;
                return false;
            }
            return true;
        }
        return sender.hasPermission(this.amendedPermission);
    }
}

