/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.inventory;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import org.bukkit.craftbukkit.v1_21_R7.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;

public class CraftEntityEquipment
implements EntityEquipment {
    private final CraftLivingEntity entity;

    public CraftEntityEquipment(CraftLivingEntity entity) {
        this.entity = entity;
    }

    public void setItem(org.bukkit.inventory.EquipmentSlot slot, ItemStack item) {
        this.setItem(slot, item, false);
    }

    public void setItem(org.bukkit.inventory.EquipmentSlot slot, ItemStack item, boolean silent) {
        Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"slot must not be null");
        EquipmentSlot nmsSlot = CraftEquipmentSlot.getNMS(slot);
        this.setEquipment(nmsSlot, item, silent);
    }

    public ItemStack getItem(org.bukkit.inventory.EquipmentSlot slot) {
        Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"slot must not be null");
        EquipmentSlot nmsSlot = CraftEquipmentSlot.getNMS(slot);
        return this.getEquipment(nmsSlot);
    }

    public ItemStack getItemInMainHand() {
        return this.getEquipment(EquipmentSlot.MAINHAND);
    }

    public void setItemInMainHand(ItemStack item) {
        this.setItemInMainHand(item, false);
    }

    public void setItemInMainHand(ItemStack item, boolean silent) {
        this.setEquipment(EquipmentSlot.MAINHAND, item, silent);
    }

    public ItemStack getItemInOffHand() {
        return this.getEquipment(EquipmentSlot.OFFHAND);
    }

    public void setItemInOffHand(ItemStack item) {
        this.setItemInOffHand(item, false);
    }

    public void setItemInOffHand(ItemStack item, boolean silent) {
        this.setEquipment(EquipmentSlot.OFFHAND, item, silent);
    }

    public ItemStack getItemInHand() {
        return this.getItemInMainHand();
    }

    public void setItemInHand(ItemStack stack) {
        this.setItemInMainHand(stack);
    }

    public ItemStack getHelmet() {
        return this.getEquipment(EquipmentSlot.HEAD);
    }

    public void setHelmet(ItemStack helmet) {
        this.setHelmet(helmet, false);
    }

    public void setHelmet(ItemStack helmet, boolean silent) {
        this.setEquipment(EquipmentSlot.HEAD, helmet, silent);
    }

    public ItemStack getChestplate() {
        return this.getEquipment(EquipmentSlot.CHEST);
    }

    public void setChestplate(ItemStack chestplate) {
        this.setChestplate(chestplate, false);
    }

    public void setChestplate(ItemStack chestplate, boolean silent) {
        this.setEquipment(EquipmentSlot.CHEST, chestplate, silent);
    }

    public ItemStack getLeggings() {
        return this.getEquipment(EquipmentSlot.LEGS);
    }

    public void setLeggings(ItemStack leggings) {
        this.setLeggings(leggings, false);
    }

    public void setLeggings(ItemStack leggings, boolean silent) {
        this.setEquipment(EquipmentSlot.LEGS, leggings, silent);
    }

    public ItemStack getBoots() {
        return this.getEquipment(EquipmentSlot.FEET);
    }

    public void setBoots(ItemStack boots) {
        this.setBoots(boots, false);
    }

    public void setBoots(ItemStack boots, boolean silent) {
        this.setEquipment(EquipmentSlot.FEET, boots, silent);
    }

    public ItemStack[] getArmorContents() {
        ItemStack[] armor = new ItemStack[]{this.getEquipment(EquipmentSlot.FEET), this.getEquipment(EquipmentSlot.LEGS), this.getEquipment(EquipmentSlot.CHEST), this.getEquipment(EquipmentSlot.HEAD)};
        return armor;
    }

    public void setArmorContents(ItemStack[] items) {
        this.setEquipment(EquipmentSlot.FEET, items.length >= 1 ? items[0] : null, false);
        this.setEquipment(EquipmentSlot.LEGS, items.length >= 2 ? items[1] : null, false);
        this.setEquipment(EquipmentSlot.CHEST, items.length >= 3 ? items[2] : null, false);
        this.setEquipment(EquipmentSlot.HEAD, items.length >= 4 ? items[3] : null, false);
    }

    private ItemStack getEquipment(EquipmentSlot slot) {
        return CraftItemStack.asBukkitCopy(this.entity.getHandle().getItemBySlot(slot));
    }

    private void setEquipment(EquipmentSlot slot, ItemStack stack, boolean silent) {
        this.entity.getHandle().setItemSlot(slot, CraftItemStack.asNMSCopy(stack), silent);
    }

    public void clear() {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            this.setEquipment(slot, null, false);
        }
    }

    public Entity getHolder() {
        return this.entity;
    }

    public float getItemInHandDropChance() {
        return this.getItemInMainHandDropChance();
    }

    public void setItemInHandDropChance(float chance) {
        this.setItemInMainHandDropChance(chance);
    }

    public float getItemInMainHandDropChance() {
        return this.getDropChance(EquipmentSlot.MAINHAND);
    }

    public void setItemInMainHandDropChance(float chance) {
        this.setDropChance(EquipmentSlot.MAINHAND, chance);
    }

    public float getItemInOffHandDropChance() {
        return this.getDropChance(EquipmentSlot.OFFHAND);
    }

    public void setItemInOffHandDropChance(float chance) {
        this.setDropChance(EquipmentSlot.OFFHAND, chance);
    }

    public float getHelmetDropChance() {
        return this.getDropChance(EquipmentSlot.HEAD);
    }

    public void setHelmetDropChance(float chance) {
        this.setDropChance(EquipmentSlot.HEAD, chance);
    }

    public float getChestplateDropChance() {
        return this.getDropChance(EquipmentSlot.CHEST);
    }

    public void setChestplateDropChance(float chance) {
        this.setDropChance(EquipmentSlot.CHEST, chance);
    }

    public float getLeggingsDropChance() {
        return this.getDropChance(EquipmentSlot.LEGS);
    }

    public void setLeggingsDropChance(float chance) {
        this.setDropChance(EquipmentSlot.LEGS, chance);
    }

    public float getBootsDropChance() {
        return this.getDropChance(EquipmentSlot.FEET);
    }

    public void setBootsDropChance(float chance) {
        this.setDropChance(EquipmentSlot.FEET, chance);
    }

    private void setDropChance(EquipmentSlot slot, float chance) {
        Preconditions.checkArgument((boolean)(this.entity.getHandle() instanceof Mob), (Object)"Cannot set drop chance for non-Mob entity");
        ((Mob)this.entity.getHandle()).setDropChance(slot, chance);
    }

    private float getDropChance(EquipmentSlot slot) {
        if (!(this.entity.getHandle() instanceof Mob)) {
            return 1.0f;
        }
        return ((Mob)this.entity.getHandle()).getDropChances().byEquipment(slot);
    }
}

