/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.inventory.components;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.block.Block;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R7.inventory.SerializableMeta;
import org.bukkit.craftbukkit.v1_21_R7.inventory.components.CraftHolderUtil;
import org.bukkit.craftbukkit.v1_21_R7.tag.CraftBlockTag;
import org.bukkit.inventory.meta.components.ToolComponent;

@SerializableAs(value="Tool")
public final class CraftToolComponent
implements ToolComponent {
    private Tool handle;

    public CraftToolComponent(Tool tool) {
        this.handle = tool;
    }

    public CraftToolComponent(CraftToolComponent tool) {
        this.handle = tool.handle;
    }

    public CraftToolComponent(Map<String, Object> map) {
        Float speed = SerializableMeta.getObject(Float.class, map, "default-mining-speed", false);
        Integer damage = SerializableMeta.getObject(Integer.class, map, "damage-per-block", false);
        Boolean canDestroy = SerializableMeta.getObject(Boolean.class, map, "can-destroy-blocks-in-creative", true);
        ImmutableList.Builder rules = ImmutableList.builder();
        Iterable rawRuleList = SerializableMeta.getObject(Iterable.class, map, "rules", true);
        if (rawRuleList != null) {
            for (Object obj : rawRuleList) {
                Preconditions.checkArgument((boolean)(obj instanceof ToolComponent.ToolRule), (String)"Object (%s) in rule list is not valid", obj.getClass());
                CraftToolRule rule = new CraftToolRule((ToolComponent.ToolRule)obj);
                if (rule.handle.blocks().size() <= 0) continue;
                rules.add((Object)rule);
            }
        }
        this.handle = new Tool(rules.build().stream().map(CraftToolRule::new).map(CraftToolRule::getHandle).toList(), speed.floatValue(), damage, canDestroy != null ? canDestroy : true);
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("default-mining-speed", Float.valueOf(this.getDefaultMiningSpeed()));
        result.put("damage-per-block", this.getDamagePerBlock());
        result.put("can-destroy-blocks-in-creative", this.canDestroyBlocksInCreative());
        result.put("rules", this.getRules());
        return result;
    }

    public Tool getHandle() {
        return this.handle;
    }

    public float getDefaultMiningSpeed() {
        return this.handle.defaultMiningSpeed();
    }

    public void setDefaultMiningSpeed(float speed) {
        this.handle = new Tool(this.handle.rules(), speed, this.handle.damagePerBlock(), this.handle.canDestroyBlocksInCreative());
    }

    public int getDamagePerBlock() {
        return this.handle.damagePerBlock();
    }

    public void setDamagePerBlock(int damage) {
        Preconditions.checkArgument((damage >= 0 ? 1 : 0) != 0, (String)"damage must be >= 0, was %d", (int)damage);
        this.handle = new Tool(this.handle.rules(), this.handle.defaultMiningSpeed(), damage, this.handle.canDestroyBlocksInCreative());
    }

    public boolean canDestroyBlocksInCreative() {
        return this.handle.canDestroyBlocksInCreative();
    }

    public void setCanDestroyBlocksInCreative(boolean destroy) {
        this.handle = new Tool(this.handle.rules(), this.handle.defaultMiningSpeed(), this.handle.damagePerBlock(), destroy);
    }

    public List<ToolComponent.ToolRule> getRules() {
        return this.handle.rules().stream().map(CraftToolRule::new).collect(Collectors.toList());
    }

    public void setRules(List<ToolComponent.ToolRule> rules) {
        Preconditions.checkArgument((rules != null ? 1 : 0) != 0, (Object)"rules must not be null");
        this.handle = new Tool(rules.stream().map(CraftToolRule::new).map(CraftToolRule::getHandle).toList(), this.handle.defaultMiningSpeed(), this.handle.damagePerBlock(), this.handle.canDestroyBlocksInCreative());
    }

    public ToolComponent.ToolRule addRule(Material block, Float speed, Boolean correctForDrops) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"block must not be null");
        Preconditions.checkArgument((boolean)block.isBlock(), (String)"block must be a block type, given %s", (Object)block.getKey());
        Holder.Reference<Block> nmsBlock = CraftBlockType.bukkitToMinecraft(block).builtInRegistryHolder();
        return this.addRule(HolderSet.direct(nmsBlock), speed, correctForDrops);
    }

    public ToolComponent.ToolRule addRule(Collection<Material> blocks, Float speed, Boolean correctForDrops) {
        ArrayList<Holder.Reference<Block>> nmsBlocks = new ArrayList<Holder.Reference<Block>>(blocks.size());
        for (Material material : blocks) {
            Preconditions.checkArgument((boolean)material.isBlock(), (String)"blocks contains non-block type: %s", (Object)material.getKey());
            nmsBlocks.add(CraftBlockType.bukkitToMinecraft(material).builtInRegistryHolder());
        }
        return this.addRule(HolderSet.direct(nmsBlocks), speed, correctForDrops);
    }

    public ToolComponent.ToolRule addRule(Tag<Material> tag, Float speed, Boolean correctForDrops) {
        Preconditions.checkArgument((boolean)(tag instanceof CraftBlockTag), (Object)"tag must be a block tag");
        return this.addRule(((CraftBlockTag)tag).getHandle(), speed, correctForDrops);
    }

    private ToolComponent.ToolRule addRule(HolderSet<Block> blocks, Float speed, Boolean correctForDrops) {
        Tool.Rule rule = new Tool.Rule(blocks, Optional.ofNullable(speed), Optional.ofNullable(correctForDrops));
        ArrayList<Tool.Rule> rules = new ArrayList<Tool.Rule>(this.handle.rules().size() + 1);
        rules.addAll(this.handle.rules());
        rules.add(rule);
        this.handle = new Tool(rules, this.handle.defaultMiningSpeed(), this.handle.damagePerBlock(), this.handle.canDestroyBlocksInCreative());
        return new CraftToolRule(rule);
    }

    public boolean removeRule(ToolComponent.ToolRule rule) {
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (Object)"rule must not be null");
        ArrayList<Tool.Rule> rules = new ArrayList<Tool.Rule>(this.handle.rules());
        boolean removed = rules.remove(((CraftToolRule)rule).handle);
        this.handle = new Tool(rules, this.handle.defaultMiningSpeed(), this.handle.damagePerBlock(), this.handle.canDestroyBlocksInCreative());
        return removed;
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + Objects.hashCode(this.handle);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftToolComponent other = (CraftToolComponent)obj;
        return Objects.equals(this.handle, other.handle);
    }

    public String toString() {
        return "CraftToolComponent{handle=" + String.valueOf(this.handle) + "}";
    }

    @SerializableAs(value="ToolRule")
    public static class CraftToolRule
    implements ToolComponent.ToolRule {
        private Tool.Rule handle;

        public CraftToolRule(Tool.Rule handle) {
            this.handle = handle;
        }

        public CraftToolRule(ToolComponent.ToolRule bukkit) {
            Tool.Rule toCopy = ((CraftToolRule)bukkit).handle;
            this.handle = new Tool.Rule(toCopy.blocks(), toCopy.speed(), toCopy.correctForDrops());
        }

        public CraftToolRule(Map<String, Object> map) {
            Float speed = SerializableMeta.getObject(Float.class, map, "speed", true);
            Boolean correct = SerializableMeta.getObject(Boolean.class, map, "correct-for-drops", true);
            HolderSet<Block> blocks = CraftHolderUtil.parse(SerializableMeta.getObject(Object.class, map, "blocks", false), Registries.BLOCK, BuiltInRegistries.BLOCK);
            this.handle = new Tool.Rule(blocks, Optional.ofNullable(speed), Optional.ofNullable(correct));
        }

        public Map<String, Object> serialize() {
            Boolean correct;
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            CraftHolderUtil.serialize(result, "blocks", this.handle.blocks());
            Float speed = this.getSpeed();
            if (speed != null) {
                result.put("speed", speed);
            }
            if ((correct = this.isCorrectForDrops()) != null) {
                result.put("correct-for-drops", correct);
            }
            return result;
        }

        public Tool.Rule getHandle() {
            return this.handle;
        }

        public Collection<Material> getBlocks() {
            return this.handle.blocks().stream().map(Holder::value).map(CraftBlockType::minecraftToBukkit).collect(Collectors.toList());
        }

        public void setBlocks(Material block) {
            Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"block must not be null");
            Preconditions.checkArgument((boolean)block.isBlock(), (String)"block must be a block type, given %s", (Object)block.getKey());
            this.handle = new Tool.Rule(HolderSet.direct(CraftBlockType.bukkitToMinecraft(block).builtInRegistryHolder()), this.handle.speed(), this.handle.correctForDrops());
        }

        public void setBlocks(Collection<Material> blocks) {
            Preconditions.checkArgument((blocks != null ? 1 : 0) != 0, (Object)"blocks must not be null");
            for (Material material : blocks) {
                Preconditions.checkArgument((boolean)material.isBlock(), (String)"blocks contains non-block type: %s", (Object)material.getKey());
            }
            this.handle = new Tool.Rule(HolderSet.direct(blocks.stream().map(CraftBlockType::bukkitToMinecraft).map(Block::builtInRegistryHolder).collect(Collectors.toList())), this.handle.speed(), this.handle.correctForDrops());
        }

        public void setBlocks(Tag<Material> tag) {
            Preconditions.checkArgument((boolean)(tag instanceof CraftBlockTag), (Object)"tag must be a block tag");
            this.handle = new Tool.Rule(((CraftBlockTag)tag).getHandle(), this.handle.speed(), this.handle.correctForDrops());
        }

        public Float getSpeed() {
            return this.handle.speed().orElse(null);
        }

        public void setSpeed(Float speed) {
            this.handle = new Tool.Rule(this.handle.blocks(), Optional.ofNullable(speed), this.handle.correctForDrops());
        }

        public Boolean isCorrectForDrops() {
            return this.handle.correctForDrops().orElse(null);
        }

        public void setCorrectForDrops(Boolean correct) {
            this.handle = new Tool.Rule(this.handle.blocks(), this.handle.speed(), Optional.ofNullable(correct));
        }

        public int hashCode() {
            int hash = 5;
            hash = 97 * hash + Objects.hashCode(this.handle);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CraftToolRule other = (CraftToolRule)obj;
            return Objects.equals(this.handle, other.handle);
        }

        public String toString() {
            return "CraftToolRule{handle=" + String.valueOf(this.handle) + "}";
        }
    }
}

