/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.profile;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.players.NameAndId;
import net.minecraft.util.Util;
import net.minecraft.world.item.component.ResolvableProfile;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.configuration.ConfigSerializationUtil;
import org.bukkit.craftbukkit.v1_21_R7.profile.CraftPlayerSkinPatch;
import org.bukkit.craftbukkit.v1_21_R7.profile.CraftPlayerTextures;
import org.bukkit.craftbukkit.v1_21_R7.profile.CraftProfileProperty;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerSkinPatch;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.ApiStatus;

@SerializableAs(value="PlayerProfile")
public final class CraftPlayerProfile
implements PlayerProfile {
    private final UUID uniqueId;
    private final String name;
    private final Multimap<String, Property> properties = LinkedListMultimap.create();
    private final CraftPlayerTextures textures = new CraftPlayerTextures(this);
    private CraftPlayerSkinPatch skinPatch = new CraftPlayerSkinPatch();

    @Nullable
    public static Property getProperty(@Nonnull GameProfile profile, String propertyName) {
        return (Property)Iterables.getFirst((Iterable)profile.properties().get((Object)propertyName), null);
    }

    private CraftPlayerProfile(UUID uniqueId, String name, boolean applyPreconditions) {
        if (applyPreconditions) {
            Preconditions.checkArgument((uniqueId != null || !StringUtils.isBlank((String)name) ? 1 : 0) != 0, (Object)"uniqueId is null or name is blank");
        }
        this.uniqueId = uniqueId;
        this.name = name;
    }

    public CraftPlayerProfile(UUID uniqueId, String name) {
        this(uniqueId, name, true);
    }

    public CraftPlayerProfile(NameAndId nameandid) {
        this(nameandid.id(), nameandid.name());
    }

    @ApiStatus.Internal
    public CraftPlayerProfile(@Nonnull ResolvableProfile resolvableProfile) {
        this(resolvableProfile.partialProfile(), false);
        this.skinPatch = new CraftPlayerSkinPatch(resolvableProfile.skinPatch());
    }

    public CraftPlayerProfile(@Nonnull GameProfile gameProfile) {
        this(gameProfile, true);
    }

    private CraftPlayerProfile(@Nonnull GameProfile gameProfile, boolean applyPreconditions) {
        this(gameProfile.id(), gameProfile.name(), applyPreconditions);
        this.properties.putAll((Multimap)gameProfile.properties());
    }

    private CraftPlayerProfile(@Nonnull CraftPlayerProfile other) {
        this(other.uniqueId, other.name);
        this.properties.putAll(other.properties);
        this.textures.copyFrom(other.textures);
        this.skinPatch = new CraftPlayerSkinPatch(other.skinPatch);
    }

    public UUID getUniqueId() {
        return Objects.equals(this.uniqueId, Util.NIL_UUID) ? null : this.uniqueId;
    }

    public String getName() {
        return StringUtils.isBlank((String)this.name) ? null : this.name;
    }

    @Nullable
    Property getProperty(String propertyName) {
        return (Property)Iterables.getFirst((Iterable)this.properties.get((Object)propertyName), null);
    }

    void setProperty(String propertyName, @Nullable Property property) {
        this.removeProperty(propertyName);
        if (property != null) {
            this.properties.put((Object)property.name(), (Object)property);
        }
    }

    void removeProperty(String propertyName) {
        this.properties.removeAll((Object)propertyName);
    }

    void rebuildDirtyProperties() {
        this.textures.rebuildPropertyIfDirty();
    }

    public CraftPlayerTextures getTextures() {
        return this.textures;
    }

    public void setTextures(@Nullable PlayerTextures textures) {
        if (textures == null) {
            this.textures.clear();
        } else {
            this.textures.copyFrom(textures);
        }
    }

    public PlayerSkinPatch getSkinPatch() {
        return this.skinPatch;
    }

    public void setSkinPatch(PlayerSkinPatch patch) {
        this.skinPatch = patch == null ? new CraftPlayerSkinPatch() : new CraftPlayerSkinPatch(patch);
    }

    public boolean isComplete() {
        return this.getUniqueId() != null && this.getName() != null && !this.textures.isEmpty();
    }

    public CompletableFuture<PlayerProfile> update() {
        return CompletableFuture.supplyAsync(this::getUpdatedProfile, Util.backgroundExecutor());
    }

    private CraftPlayerProfile getUpdatedProfile() {
        ProfileResult newProfile;
        DedicatedServer server = ((CraftServer)Bukkit.getServer()).getServer();
        GameProfile profile = this.buildGameProfile();
        if (profile.id().equals(Util.NIL_UUID)) {
            profile = server.services().nameToIdCache().get(profile.name()).map(resolved -> new GameProfile(resolved.id(), resolved.name())).orElse(profile);
        }
        if (!profile.id().equals(Util.NIL_UUID) && (newProfile = server.services().sessionService().fetchProfile(profile.id(), true)) != null) {
            profile = newProfile.profile();
        }
        return new CraftPlayerProfile(profile);
    }

    @Nonnull
    public ResolvableProfile buildResolvableProfile() {
        this.rebuildDirtyProperties();
        if (!this.textures.isEmpty()) {
            return new ResolvableProfile.Static((Either<GameProfile, ResolvableProfile.Partial>)Either.left((Object)this.buildGameProfile()), this.skinPatch.toMinecraft());
        }
        if (this.getUniqueId() != null) {
            return new ResolvableProfile.Dynamic((Either<String, UUID>)Either.right((Object)this.getUniqueId()), this.skinPatch.toMinecraft());
        }
        if (this.getName() != null) {
            return new ResolvableProfile.Dynamic((Either<String, UUID>)Either.left((Object)this.getName()), this.skinPatch.toMinecraft());
        }
        throw new IllegalArgumentException("The skull profile is missing a name, UUID and textures!");
    }

    @Nonnull
    public GameProfile buildGameProfile() {
        this.rebuildDirtyProperties();
        GameProfile profile = new GameProfile(this.uniqueId != null ? this.uniqueId : Util.NIL_UUID, this.name != null ? this.name : "", new PropertyMap(this.properties));
        return profile;
    }

    @Nonnull
    public NameAndId buildNameAndId() {
        return new NameAndId(this.uniqueId, this.name);
    }

    public String toString() {
        this.rebuildDirtyProperties();
        StringBuilder builder = new StringBuilder();
        builder.append("CraftPlayerProfile [uniqueId=");
        builder.append(this.uniqueId);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", properties=");
        builder.append(this.properties);
        builder.append(", skinPatch=");
        builder.append(this.skinPatch);
        builder.append("]");
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CraftPlayerProfile)) {
            return false;
        }
        CraftPlayerProfile other = (CraftPlayerProfile)obj;
        if (!Objects.equals(this.uniqueId, other.uniqueId)) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        this.rebuildDirtyProperties();
        other.rebuildDirtyProperties();
        if (!Objects.equals(this.properties, other.properties)) {
            return false;
        }
        return Objects.equals(this.skinPatch, other.skinPatch);
    }

    public int hashCode() {
        this.rebuildDirtyProperties();
        int result = 1;
        result = 31 * result + Objects.hashCode(this.uniqueId);
        result = 31 * result + Objects.hashCode(this.name);
        result = 31 * result + Objects.hashCode(this.properties);
        result = 31 * result + Objects.hashCode(this.skinPatch);
        return result;
    }

    public CraftPlayerProfile clone() {
        return new CraftPlayerProfile(this);
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (this.uniqueId != null) {
            map.put("uniqueId", this.uniqueId.toString());
        }
        if (this.name != null) {
            map.put("name", this.name);
        }
        this.rebuildDirtyProperties();
        if (!this.properties.isEmpty()) {
            ArrayList propertiesData = new ArrayList();
            this.properties.forEach((propertyName, property) -> propertiesData.add(CraftProfileProperty.serialize(property)));
            map.put("properties", propertiesData);
        }
        if (!this.skinPatch.isEmpty()) {
            map.put("patch", this.skinPatch);
        }
        return map;
    }

    public static CraftPlayerProfile deserialize(Map<String, Object> map) {
        PlayerSkinPatch patch;
        UUID uniqueId = ConfigSerializationUtil.getUuid(map, "uniqueId", true);
        String name = ConfigSerializationUtil.getString(map, "name", true);
        CraftPlayerProfile profile = new CraftPlayerProfile(uniqueId, name);
        if (map.containsKey("properties")) {
            for (Object propertyData : (List)map.get("properties")) {
                Preconditions.checkArgument((boolean)(propertyData instanceof Map), (String)"Property data (%s) is not a valid Map", propertyData);
                Property property = CraftProfileProperty.deserialize((Map)propertyData);
                profile.properties.put((Object)property.name(), (Object)property);
            }
        }
        if ((patch = ConfigSerializationUtil.getObject(PlayerSkinPatch.class, map, "patch", true)) != null) {
            profile.skinPatch = new CraftPlayerSkinPatch(patch);
        }
        return profile;
    }
}

