/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootContext;
import org.bukkit.loot.LootTable;

public class CraftLootTable
implements LootTable {
    private final fof handle;
    private final NamespacedKey key;

    public static LootTable minecraftToBukkit(amo minecraft) {
        return minecraft == null ? null : Bukkit.getLootTable((NamespacedKey)CraftNamespacedKey.fromMinecraft(minecraft));
    }

    public static LootTable minecraftToBukkit(amt<fof> minecraft) {
        return minecraft == null ? null : Bukkit.getLootTable((NamespacedKey)CraftLootTable.minecraftToBukkitKey(minecraft));
    }

    public static NamespacedKey minecraftToBukkitKey(amt<fof> minecraft) {
        return minecraft == null ? null : CraftNamespacedKey.fromMinecraft(minecraft.a());
    }

    public static amt<fof> bukkitToMinecraft(LootTable table) {
        return table == null ? null : CraftLootTable.bukkitKeyToMinecraft(table.getKey());
    }

    public static amt<fof> bukkitKeyToMinecraft(NamespacedKey key) {
        return key == null ? null : amt.a(mj.bG, CraftNamespacedKey.toMinecraft(key));
    }

    public CraftLootTable(NamespacedKey key, fof handle) {
        this.handle = handle;
        this.key = key;
    }

    public fof getHandle() {
        return this.handle;
    }

    public Collection<ItemStack> populateLoot(Random random, LootContext context) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"LootContext cannot be null");
        fod nmsContext = this.convertContext(context, random);
        ObjectArrayList<dlt> nmsItems = this.handle.a(nmsContext);
        ArrayList<ItemStack> bukkit = new ArrayList<ItemStack>(nmsItems.size());
        for (dlt item : nmsItems) {
            if (item.f()) continue;
            bukkit.add(CraftItemStack.asBukkitCopy(item));
        }
        return bukkit;
    }

    public void fillInventory(Inventory inventory, Random random, LootContext context) {
        Preconditions.checkArgument((inventory != null ? 1 : 0) != 0, (Object)"Inventory cannot be null");
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"LootContext cannot be null");
        fod nmsContext = this.convertContext(context, random);
        CraftInventory craftInventory = (CraftInventory)inventory;
        ccv handle = craftInventory.getInventory();
        this.getHandle().fillInventory(handle, nmsContext, random.nextLong(), true);
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    private fod convertContext(LootContext context, Random random) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"LootContext cannot be null");
        Location loc = context.getLocation();
        Preconditions.checkArgument((loc.getWorld() != null ? 1 : 0) != 0, (Object)"LootContext.getLocation#getWorld cannot be null");
        axf handle = ((CraftWorld)loc.getWorld()).getHandle();
        fod.a builder = new fod.a(handle);
        if (random != null) {
            // empty if block
        }
        this.setMaybe(builder, fqx.h, CraftLocation.toVec3D(loc));
        if (this.getHandle() != fof.f) {
            if (context.getLootedEntity() != null) {
                cgk nmsLootedEntity = ((CraftEntity)context.getLootedEntity()).getHandle();
                this.setMaybe(builder, fqx.a, nmsLootedEntity);
                this.setMaybe(builder, fqx.e, handle.as().p());
                this.setMaybe(builder, fqx.h, nmsLootedEntity.dI());
            }
            if (context.getKiller() != null) {
                ddm nmsKiller = ((CraftHumanEntity)context.getKiller()).getHandle();
                this.setMaybe(builder, fqx.f, nmsKiller);
                this.setMaybe(builder, fqx.e, handle.as().a(nmsKiller));
                this.setMaybe(builder, fqx.d, nmsKiller);
                this.setMaybe(builder, fqx.k, nmsKiller.gb());
            }
        }
        bhw.a nmsBuilder = new bhw.a();
        for (bhv<?> param : this.getHandle().a().a()) {
            nmsBuilder.a(param);
        }
        for (bhv<?> param : this.getHandle().a().b()) {
            if (this.getHandle().a().a().contains(param)) continue;
            nmsBuilder.b(param);
        }
        return builder.a(this.getHandle().a());
    }

    private <T> void setMaybe(fod.a builder, bhv<T> param, T value) {
        if (this.getHandle().a().a().contains(param) || this.getHandle().a().b().contains(param)) {
            builder.a(param, value);
        }
    }

    public static LootContext convertContext(fnz info) {
        CraftEntity killer;
        ftm position = info.c(fqx.h);
        if (position == null) {
            position = info.c(fqx.a).dI();
        }
        Location location = CraftLocation.toBukkit(position, (World)info.d().getWorld());
        LootContext.Builder contextBuilder = new LootContext.Builder(location);
        if (info.a(fqx.f) && (killer = info.c(fqx.f).getBukkitEntity()) instanceof CraftHumanEntity) {
            contextBuilder.killer((HumanEntity)((CraftHumanEntity)killer));
        }
        if (info.a(fqx.a)) {
            contextBuilder.lootedEntity((Entity)info.c(fqx.a).getBukkitEntity());
        }
        contextBuilder.luck(info.c());
        return contextBuilder.build();
    }

    public String toString() {
        return this.getKey().toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LootTable)) {
            return false;
        }
        LootTable table = (LootTable)obj;
        return table.getKey().equals((Object)this.getKey());
    }
}

