/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.Vibration;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.legacy.FieldRename;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftNamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

public abstract class CraftParticle<D>
implements Keyed {
    private static final Registry<CraftParticle<?>> CRAFT_PARTICLE_REGISTRY = new CraftParticleRegistry(CraftRegistry.getMinecraftRegistry(mj.ag));
    private final NamespacedKey key;
    private final lx<?> particle;
    private final Class<D> clazz;

    public static Particle minecraftToBukkit(lx<?> minecraft) {
        Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
        jq registry = CraftRegistry.getMinecraftRegistry(mj.ag);
        Particle bukkit = (Particle)Registry.PARTICLE_TYPE.get(CraftNamespacedKey.fromMinecraft(registry.d(minecraft).orElseThrow().a()));
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit;
    }

    public static lx<?> bukkitToMinecraft(Particle bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return (lx)CraftRegistry.getMinecraftRegistry(mj.ag).b(CraftNamespacedKey.toMinecraft(bukkit.getKey())).orElseThrow();
    }

    public static <D> lw createParticleParam(Particle particle, D data) {
        CraftParticle craftParticle;
        Preconditions.checkArgument((particle != null ? 1 : 0) != 0, (Object)"particle cannot be null");
        data = CraftParticle.convertLegacy(data);
        if (particle.getDataType() != Void.class) {
            Preconditions.checkArgument((data != null ? 1 : 0) != 0, (String)"missing required data %s", (Object)particle.getDataType());
        }
        if (data != null) {
            Preconditions.checkArgument((boolean)particle.getDataType().isInstance(data), (String)"data (%s) should be %s", data.getClass(), (Object)particle.getDataType());
        }
        Preconditions.checkArgument(((craftParticle = (CraftParticle)CRAFT_PARTICLE_REGISTRY.get(particle.getKey())) != null ? 1 : 0) != 0);
        return craftParticle.createParticleParam(data);
    }

    public static <T> T convertLegacy(T object) {
        if (object instanceof MaterialData) {
            MaterialData mat = (MaterialData)object;
            return (T)CraftBlockData.fromData(CraftMagicNumbers.getBlock(mat));
        }
        return object;
    }

    public CraftParticle(NamespacedKey key, lx<?> particle, Class<D> clazz) {
        this.key = key;
        this.particle = particle;
        this.clazz = clazz;
    }

    public lx<?> getHandle() {
        return this.particle;
    }

    public abstract lw createParticleParam(D var1);

    public NamespacedKey getKey() {
        return this.key;
    }

    public static class CraftParticleRegistry
    extends CraftRegistry<CraftParticle<?>, lx<?>> {
        private static final Map<NamespacedKey, BiFunction<NamespacedKey, lx<?>, CraftParticle<?>>> PARTICLE_MAP = new HashMap();
        private static final BiFunction<NamespacedKey, lx<?>, CraftParticle<?>> VOID_FUNCTION = (name, particle) -> new CraftParticle<Void>(name, particle, Void.class){

            @Override
            public lw createParticleParam(Void data) {
                return (md)this.getHandle();
            }
        };

        private static void add(String name, BiFunction<NamespacedKey, lx<?>, CraftParticle<?>> function) {
            PARTICLE_MAP.put(NamespacedKey.fromString((String)name), function);
        }

        public CraftParticleRegistry(jq<lx<?>> minecraftRegistry) {
            super(CraftParticle.class, minecraftRegistry, null, FieldRename.PARTICLE_TYPE_RENAME);
        }

        @Override
        public CraftParticle<?> createBukkit(NamespacedKey namespacedKey, jd<lx<?>> particle) {
            if (particle == null) {
                return null;
            }
            BiFunction<NamespacedKey, lx<?>, CraftParticle<?>> function = PARTICLE_MAP.getOrDefault(namespacedKey, VOID_FUNCTION);
            return function.apply(namespacedKey, particle.a());
        }

        static {
            BiFunction<NamespacedKey, lx<?>, CraftParticle<?>> dustOptionsFunction = (name, particle) -> new CraftParticle<Particle.DustOptions>(name, particle, Particle.DustOptions.class){

                @Override
                public lw createParticleParam(Particle.DustOptions data) {
                    Color color = data.getColor();
                    return new ls(color.asRGB(), data.getSize());
                }
            };
            BiFunction<NamespacedKey, lx<?>, CraftParticle<?>> itemStackFunction = (name, particle) -> new CraftParticle<ItemStack>(name, particle, ItemStack.class){

                @Override
                public lw createParticleParam(ItemStack data) {
                    return new lu(this.getHandle(), CraftItemStack.asNMSCopy(data));
                }
            };
            BiFunction<NamespacedKey, lx<?>, CraftParticle<?>> blockDataFunction = (name, particle) -> new CraftParticle<BlockData>(name, particle, BlockData.class){

                @Override
                public lw createParticleParam(BlockData data) {
                    return new lp(this.getHandle(), ((CraftBlockData)data).getState());
                }
            };
            BiFunction<NamespacedKey, lx<?>, CraftParticle<?>> dustTransitionFunction = (name, particle) -> new CraftParticle<Particle.DustTransition>(name, particle, Particle.DustTransition.class){

                @Override
                public lw createParticleParam(Particle.DustTransition data) {
                    Color from = data.getColor();
                    Color to2 = data.getToColor();
                    return new lr(from.asRGB(), to2.asRGB(), data.getSize());
                }
            };
            BiFunction<NamespacedKey, lx<?>, CraftParticle<?>> vibrationFunction = (name, particle) -> new CraftParticle<Vibration>(name, particle, Vibration.class){

                @Override
                public lw createParticleParam(Vibration data) {
                    eto source;
                    if (data.getDestination() instanceof Vibration.Destination.BlockDestination) {
                        Location destination = ((Vibration.Destination.BlockDestination)data.getDestination()).getLocation();
                        source = new etg(CraftLocation.toBlockPosition(destination));
                    } else if (data.getDestination() instanceof Vibration.Destination.EntityDestination) {
                        cgk destination = ((CraftEntity)((Vibration.Destination.EntityDestination)data.getDestination()).getEntity()).getHandle();
                        source = new eti(destination, destination.dk());
                    } else {
                        throw new IllegalArgumentException("Unknown vibration destination " + String.valueOf(data.getDestination()));
                    }
                    return new mg(source, data.getArrivalTime());
                }
            };
            BiFunction<NamespacedKey, lx<?>, CraftParticle<?>> sculkChargeFunction = (name, particle) -> new CraftParticle<Float>(name, particle, Float.class){

                @Override
                public lw createParticleParam(Float data) {
                    return new mb(data.floatValue());
                }
            };
            BiFunction<NamespacedKey, lx<?>, CraftParticle<?>> powerParticleFunction = (name, particle) -> new CraftParticle<Float>(name, particle, Float.class){

                @Override
                public lw createParticleParam(Float data) {
                    return lz.a(this.getHandle(), data.floatValue());
                }
            };
            BiFunction<NamespacedKey, lx<?>, CraftParticle<?>> integerFunction = (name, particle) -> new CraftParticle<Integer>(name, particle, Integer.class){

                @Override
                public lw createParticleParam(Integer data) {
                    return new mc(data);
                }
            };
            BiFunction<NamespacedKey, lx<?>, CraftParticle<?>> colorFunction = (name, particle) -> new CraftParticle<Color>(name, particle, Color.class){

                @Override
                public lw createParticleParam(Color color) {
                    return lq.a((lx<lq>)particle, color.asARGB());
                }
            };
            BiFunction<NamespacedKey, lx<?>, CraftParticle<?>> trailFunction = (name, particle) -> new CraftParticle<Particle.Trail>(name, particle, Particle.Trail.class){

                @Override
                public lw createParticleParam(Particle.Trail data) {
                    return new mf(CraftLocation.toVec3D(data.getTarget()), data.getColor().asRGB(), data.getDuration());
                }
            };
            BiFunction<NamespacedKey, lx<?>, CraftParticle<?>> spellFunction = (name, particle) -> new CraftParticle<Particle.Spell>(name, particle, Particle.Spell.class){

                @Override
                public lw createParticleParam(Particle.Spell data) {
                    return me.a(this.getHandle(), data.getColor().asARGB(), data.getPower());
                }
            };
            CraftParticleRegistry.add("dust", dustOptionsFunction);
            CraftParticleRegistry.add("item", itemStackFunction);
            CraftParticleRegistry.add("block", blockDataFunction);
            CraftParticleRegistry.add("falling_dust", blockDataFunction);
            CraftParticleRegistry.add("dust_color_transition", dustTransitionFunction);
            CraftParticleRegistry.add("vibration", vibrationFunction);
            CraftParticleRegistry.add("sculk_charge", sculkChargeFunction);
            CraftParticleRegistry.add("dragon_breath", powerParticleFunction);
            CraftParticleRegistry.add("shriek", integerFunction);
            CraftParticleRegistry.add("block_marker", blockDataFunction);
            CraftParticleRegistry.add("entity_effect", colorFunction);
            CraftParticleRegistry.add("tinted_leaves", colorFunction);
            CraftParticleRegistry.add("flash", colorFunction);
            CraftParticleRegistry.add("dust_pillar", blockDataFunction);
            CraftParticleRegistry.add("block_crumble", blockDataFunction);
            CraftParticleRegistry.add("trail", trailFunction);
            CraftParticleRegistry.add("effect", spellFunction);
            CraftParticleRegistry.add("instant_effect", spellFunction);
        }
    }
}

