/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemType;
import org.bukkit.entity.EntityType;

public enum CraftStatistic {
    DAMAGE_DEALT(bdk.I),
    DAMAGE_TAKEN(bdk.L),
    DEATHS(bdk.P),
    MOB_KILLS(bdk.Q),
    PLAYER_KILLS(bdk.S),
    FISH_CAUGHT(bdk.T),
    ANIMALS_BRED(bdk.R),
    LEAVE_GAME(bdk.j),
    JUMP(bdk.G),
    DROP_COUNT(bdk.H),
    DROP(amo.b("dropped")),
    PICKUP(amo.b("picked_up")),
    PLAY_ONE_MINUTE(bdk.k),
    TOTAL_WORLD_TIME(bdk.l),
    WALK_ONE_CM(bdk.p),
    WALK_ON_WATER_ONE_CM(bdk.s),
    FALL_ONE_CM(bdk.t),
    SNEAK_TIME(bdk.o),
    CLIMB_ONE_CM(bdk.u),
    FLY_ONE_CM(bdk.v),
    WALK_UNDER_WATER_ONE_CM(bdk.w),
    MINECART_ONE_CM(bdk.x),
    BOAT_ONE_CM(bdk.y),
    PIG_ONE_CM(bdk.z),
    HAPPY_GHAST_ONE_CM(bdk.A),
    HORSE_ONE_CM(bdk.B),
    SPRINT_ONE_CM(bdk.r),
    CROUCH_ONE_CM(bdk.q),
    AVIATE_ONE_CM(bdk.C),
    MINE_BLOCK(amo.b("mined")),
    USE_ITEM(amo.b("used")),
    BREAK_ITEM(amo.b("broken")),
    CRAFT_ITEM(amo.b("crafted")),
    KILL_ENTITY(amo.b("killed")),
    ENTITY_KILLED_BY(amo.b("killed_by")),
    TIME_SINCE_DEATH(bdk.m),
    TALKED_TO_VILLAGER(bdk.U),
    TRADED_WITH_VILLAGER(bdk.V),
    CAKE_SLICES_EATEN(bdk.W),
    CAULDRON_FILLED(bdk.X),
    CAULDRON_USED(bdk.Y),
    ARMOR_CLEANED(bdk.Z),
    BANNER_CLEANED(bdk.aa),
    BREWINGSTAND_INTERACTION(bdk.ac),
    BEACON_INTERACTION(bdk.ad),
    DROPPER_INSPECTED(bdk.ae),
    HOPPER_INSPECTED(bdk.af),
    DISPENSER_INSPECTED(bdk.ag),
    NOTEBLOCK_PLAYED(bdk.ah),
    NOTEBLOCK_TUNED(bdk.ai),
    FLOWER_POTTED(bdk.aj),
    TRAPPED_CHEST_TRIGGERED(bdk.ak),
    ENDERCHEST_OPENED(bdk.al),
    ITEM_ENCHANTED(bdk.am),
    RECORD_PLAYED(bdk.an),
    FURNACE_INTERACTION(bdk.ao),
    CRAFTING_TABLE_INTERACTION(bdk.ap),
    CHEST_OPENED(bdk.aq),
    SLEEP_IN_BED(bdk.ar),
    SHULKER_BOX_OPENED(bdk.as),
    TIME_SINCE_REST(bdk.n),
    SWIM_ONE_CM(bdk.D),
    DAMAGE_DEALT_ABSORBED(bdk.J),
    DAMAGE_DEALT_RESISTED(bdk.K),
    DAMAGE_BLOCKED_BY_SHIELD(bdk.M),
    DAMAGE_ABSORBED(bdk.N),
    DAMAGE_RESISTED(bdk.O),
    CLEAN_SHULKER_BOX(bdk.ab),
    OPEN_BARREL(bdk.at),
    INTERACT_WITH_BLAST_FURNACE(bdk.au),
    INTERACT_WITH_SMOKER(bdk.av),
    INTERACT_WITH_LECTERN(bdk.aw),
    INTERACT_WITH_CAMPFIRE(bdk.ax),
    INTERACT_WITH_CARTOGRAPHY_TABLE(bdk.ay),
    INTERACT_WITH_LOOM(bdk.az),
    INTERACT_WITH_STONECUTTER(bdk.aA),
    BELL_RING(bdk.aB),
    RAID_TRIGGER(bdk.aC),
    RAID_WIN(bdk.aD),
    INTERACT_WITH_ANVIL(bdk.aE),
    INTERACT_WITH_GRINDSTONE(bdk.aF),
    TARGET_HIT(bdk.aG),
    INTERACT_WITH_SMITHING_TABLE(bdk.aH),
    STRIDER_ONE_CM(bdk.E),
    NAUTILUS_ONE_CM(bdk.F);

    private final amo minecraftKey;
    private final Statistic bukkit;
    private static final BiMap<amo, Statistic> statistics;

    private CraftStatistic(amo minecraftKey) {
        this.minecraftKey = minecraftKey;
        this.bukkit = Statistic.valueOf((String)this.name());
        Preconditions.checkState((this.bukkit != null ? 1 : 0) != 0, (String)"Bukkit statistic %s does not exist", (Object)this.name());
    }

    public static Statistic getBukkitStatistic(bdh<?> statistic) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"NMS Statistic cannot be null");
        jq<?> statRegistry = statistic.a().b();
        amo nmsKey = mi.w.b(statistic.a());
        if (statRegistry == mi.l) {
            nmsKey = (amo)statistic.b();
        }
        return (Statistic)statistics.get((Object)nmsKey);
    }

    public static bdh getNMSStatistic(Statistic bukkit) {
        Preconditions.checkArgument((bukkit.getType() == Statistic.Type.UNTYPED ? 1 : 0) != 0, (Object)"This method only accepts untyped statistics");
        bdh<amo> nms = bdk.i.b((amo)statistics.inverse().get((Object)bukkit));
        Preconditions.checkArgument((nms != null ? 1 : 0) != 0, (String)"NMS Statistic %s does not exist", (Object)bukkit);
        return nms;
    }

    public static bdh getMaterialStatistic(Statistic stat, Material material) {
        Statistic.Type type = stat.getType();
        switch (type) {
            case BLOCK: {
                Preconditions.checkArgument((boolean)material.isBlock(), (String)"statistic type is BLOCK but got non-block Material, %s", (Object)material);
                if (stat != Statistic.MINE_BLOCK) break;
                return bdk.a.b(CraftBlockType.bukkitToMinecraft(material));
            }
            case ITEM: {
                Preconditions.checkArgument((boolean)material.isItem(), (String)"statistic type is ITEM but got non-item Material, %s", (Object)material);
                if (stat == Statistic.CRAFT_ITEM) {
                    return bdk.b.b(CraftItemType.bukkitToMinecraft(material));
                }
                if (stat == Statistic.USE_ITEM) {
                    return bdk.c.b(CraftItemType.bukkitToMinecraft(material));
                }
                if (stat == Statistic.BREAK_ITEM) {
                    return bdk.d.b(CraftItemType.bukkitToMinecraft(material));
                }
                if (stat == Statistic.PICKUP) {
                    return bdk.e.b(CraftItemType.bukkitToMinecraft(material));
                }
                if (stat != Statistic.DROP) break;
                return bdk.f.b(CraftItemType.bukkitToMinecraft(material));
            }
            default: {
                throw new IllegalArgumentException("statistic type must be either BLOCK or ITEM, given " + String.valueOf(type));
            }
        }
        throw new IllegalArgumentException("Unknwon material statistic " + String.valueOf(stat));
    }

    public static bdh getEntityStatistic(Statistic stat, EntityType entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"EntityType cannot be null");
        if (entity.getName() != null) {
            cgu<?> nmsEntity = CraftEntityType.bukkitToMinecraft(entity);
            if (stat == Statistic.KILL_ENTITY) {
                return bdk.g.b(nmsEntity);
            }
            if (stat == Statistic.ENTITY_KILLED_BY) {
                return bdk.h.b(nmsEntity);
            }
        }
        return null;
    }

    public static EntityType getEntityTypeFromStatistic(bdh<cgu<?>> statistic) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"NMS Statistic cannot be null");
        return CraftEntityType.minecraftToBukkit(statistic.b());
    }

    public static Material getMaterialFromStatistic(bdh<?> statistic) {
        Object obj = statistic.b();
        if (obj instanceof dlp) {
            dlp statisticItemValue = (dlp)obj;
            return CraftItemType.minecraftToBukkit(statisticItemValue);
        }
        obj = statistic.b();
        if (obj instanceof dzq) {
            dzq statisticBlockValue = (dzq)obj;
            return CraftBlockType.minecraftToBukkit(statisticBlockValue);
        }
        return null;
    }

    public static void incrementStatistic(bdg manager, Statistic statistic, axg player) {
        CraftStatistic.incrementStatistic(manager, statistic, 1, player);
    }

    public static void decrementStatistic(bdg manager, Statistic statistic, axg player) {
        CraftStatistic.decrementStatistic(manager, statistic, 1, player);
    }

    public static int getStatistic(bdg manager, Statistic statistic) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.UNTYPED ? 1 : 0) != 0, (Object)"Must supply additional parameter for this statistic");
        return manager.a(CraftStatistic.getNMSStatistic(statistic));
    }

    public static void incrementStatistic(bdg manager, Statistic statistic, int amount, axg player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, CraftStatistic.getStatistic(manager, statistic) + amount, player);
    }

    public static void decrementStatistic(bdg manager, Statistic statistic, int amount, axg player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, CraftStatistic.getStatistic(manager, statistic) - amount, player);
    }

    public static void setStatistic(bdg manager, Statistic statistic, int newValue, axg player) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.UNTYPED ? 1 : 0) != 0, (Object)"Must supply additional parameter for this statistic");
        Preconditions.checkArgument((newValue >= 0 ? 1 : 0) != 0, (Object)"Value must be greater than or equal to 0");
        bdh nmsStatistic = CraftStatistic.getNMSStatistic(statistic);
        manager.a(null, nmsStatistic, newValue);
        if (player != null) {
            player.A().getCraftServer().getScoreboardManager().forAllObjectives(nmsStatistic, player, score -> score.a(newValue));
        }
    }

    public static void incrementStatistic(bdg manager, Statistic statistic, Material material, axg player) {
        CraftStatistic.incrementStatistic(manager, statistic, material, 1, player);
    }

    public static void decrementStatistic(bdg manager, Statistic statistic, Material material, axg player) {
        CraftStatistic.decrementStatistic(manager, statistic, material, 1, player);
    }

    public static int getStatistic(bdg manager, Statistic statistic, Material material) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.BLOCK || statistic.getType() == Statistic.Type.ITEM ? 1 : 0) != 0, (Object)"This statistic does not take a Material parameter");
        bdh nmsStatistic = CraftStatistic.getMaterialStatistic(statistic, material);
        Preconditions.checkArgument((nmsStatistic != null ? 1 : 0) != 0, (String)"The supplied Material %s does not have a corresponding statistic", (Object)material);
        return manager.a(nmsStatistic);
    }

    public static void incrementStatistic(bdg manager, Statistic statistic, Material material, int amount, axg player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, material, CraftStatistic.getStatistic(manager, statistic, material) + amount, player);
    }

    public static void decrementStatistic(bdg manager, Statistic statistic, Material material, int amount, axg player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, material, CraftStatistic.getStatistic(manager, statistic, material) - amount, player);
    }

    public static void setStatistic(bdg manager, Statistic statistic, Material material, int newValue, axg player) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((newValue >= 0 ? 1 : 0) != 0, (Object)"Value must be greater than or equal to 0");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.BLOCK || statistic.getType() == Statistic.Type.ITEM ? 1 : 0) != 0, (Object)"This statistic does not take a Material parameter");
        bdh nmsStatistic = CraftStatistic.getMaterialStatistic(statistic, material);
        Preconditions.checkArgument((nmsStatistic != null ? 1 : 0) != 0, (String)"The supplied Material %s does not have a corresponding statistic", (Object)material);
        manager.a(null, nmsStatistic, newValue);
        if (player != null) {
            player.A().getCraftServer().getScoreboardManager().forAllObjectives(nmsStatistic, player, score -> score.a(newValue));
        }
    }

    public static void incrementStatistic(bdg manager, Statistic statistic, EntityType entityType, axg player) {
        CraftStatistic.incrementStatistic(manager, statistic, entityType, 1, player);
    }

    public static void decrementStatistic(bdg manager, Statistic statistic, EntityType entityType, axg player) {
        CraftStatistic.decrementStatistic(manager, statistic, entityType, 1, player);
    }

    public static int getStatistic(bdg manager, Statistic statistic, EntityType entityType) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((entityType != null ? 1 : 0) != 0, (Object)"EntityType cannot be null");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.ENTITY ? 1 : 0) != 0, (Object)"This statistic does not take an EntityType parameter");
        bdh nmsStatistic = CraftStatistic.getEntityStatistic(statistic, entityType);
        Preconditions.checkArgument((nmsStatistic != null ? 1 : 0) != 0, (String)"The supplied EntityType %s does not have a corresponding statistic", (Object)entityType);
        return manager.a(nmsStatistic);
    }

    public static void incrementStatistic(bdg manager, Statistic statistic, EntityType entityType, int amount, axg player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, entityType, CraftStatistic.getStatistic(manager, statistic, entityType) + amount, player);
    }

    public static void decrementStatistic(bdg manager, Statistic statistic, EntityType entityType, int amount, axg player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, entityType, CraftStatistic.getStatistic(manager, statistic, entityType) - amount, player);
    }

    public static void setStatistic(bdg manager, Statistic statistic, EntityType entityType, int newValue, axg player) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((entityType != null ? 1 : 0) != 0, (Object)"EntityType cannot be null");
        Preconditions.checkArgument((newValue >= 0 ? 1 : 0) != 0, (Object)"Value must be greater than or equal to 0");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.ENTITY ? 1 : 0) != 0, (Object)"This statistic does not take an EntityType parameter");
        bdh nmsStatistic = CraftStatistic.getEntityStatistic(statistic, entityType);
        Preconditions.checkArgument((nmsStatistic != null ? 1 : 0) != 0, (String)"The supplied EntityType %s does not have a corresponding statistic", (Object)entityType);
        manager.a(null, nmsStatistic, newValue);
        if (player != null) {
            player.A().getCraftServer().getScoreboardManager().forAllObjectives(nmsStatistic, player, score -> score.a(newValue));
        }
    }

    static {
        ImmutableBiMap.Builder statisticBuilder = ImmutableBiMap.builder();
        for (CraftStatistic statistic : CraftStatistic.values()) {
            statisticBuilder.put((Object)statistic.minecraftKey, (Object)statistic.bukkit);
        }
        statistics = statisticBuilder.build();
    }
}

