/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.block;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.spawner.SpawnRule;
import org.bukkit.block.spawner.SpawnerEntry;
import org.bukkit.craftbukkit.v1_21_R7.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R7.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntitySnapshot;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntityType;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.EquipmentSlot;

public class CraftCreatureSpawner
extends CraftBlockEntityState<emw>
implements CreatureSpawner {
    public CraftCreatureSpawner(World world, emw tileEntity) {
        super(world, tileEntity);
    }

    protected CraftCreatureSpawner(CraftCreatureSpawner state, Location location) {
        super(state, location);
    }

    public EntityType getSpawnedType() {
        dxi spawnData = ((emw)this.getSnapshot()).c().m;
        if (spawnData == null) {
            return null;
        }
        Optional<cgu<?>> type = spawnData.a().a("id", cgu.a);
        return type.map(CraftEntityType::minecraftToBukkit).orElse(null);
    }

    public void setSpawnedType(EntityType entityType) {
        if (entityType == null) {
            ((emw)this.getSnapshot()).c().l = cbn.a();
            ((emw)this.getSnapshot()).c().m = new dxi();
            return;
        }
        Preconditions.checkArgument((entityType != EntityType.UNKNOWN ? 1 : 0) != 0, (String)"Can't spawn EntityType %s from mob spawners!", (Object)entityType);
        bgr rand = this.isPlaced() ? this.getWorldHandle().G_() : bgr.a();
        ((emw)this.getSnapshot()).a(CraftEntityType.bukkitToMinecraft(entityType), rand);
    }

    public EntitySnapshot getSpawnedEntity() {
        dxi spawnData = ((emw)this.getSnapshot()).c().m;
        if (spawnData == null) {
            return null;
        }
        return CraftEntitySnapshot.create(spawnData.a());
    }

    public void setSpawnedEntity(EntitySnapshot snapshot) {
        CraftCreatureSpawner.setSpawnedEntity(((emw)this.getSnapshot()).c(), snapshot, null, null);
    }

    public void setSpawnedEntity(SpawnerEntry spawnerEntry) {
        Preconditions.checkArgument((spawnerEntry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        CraftCreatureSpawner.setSpawnedEntity(((emw)this.getSnapshot()).c(), spawnerEntry.getSnapshot(), spawnerEntry.getSpawnRule(), spawnerEntry.getEquipment());
    }

    public static void setSpawnedEntity(dvp spawner, EntitySnapshot snapshot, SpawnRule spawnRule, SpawnerEntry.Equipment equipment) {
        spawner.l = cbn.a();
        if (snapshot == null) {
            spawner.m = new dxi();
            return;
        }
        uz compoundTag = ((CraftEntitySnapshot)snapshot).getData();
        spawner.m = new dxi(compoundTag, Optional.ofNullable(CraftCreatureSpawner.toMinecraftRule(spawnRule)), CraftCreatureSpawner.getEquipment(equipment));
    }

    public void addPotentialSpawn(EntitySnapshot snapshot, int weight, SpawnRule spawnRule) {
        CraftCreatureSpawner.addPotentialSpawn(((emw)this.getSnapshot()).c(), snapshot, weight, spawnRule, null);
    }

    public static void addPotentialSpawn(dvp spawner, EntitySnapshot snapshot, int weight, SpawnRule spawnRule, SpawnerEntry.Equipment equipment) {
        Preconditions.checkArgument((snapshot != null ? 1 : 0) != 0, (Object)"Snapshot cannot be null");
        uz compoundTag = ((CraftEntitySnapshot)snapshot).getData();
        cbn.a<dxi> builder = cbn.b();
        spawner.l.d().forEach(entry -> builder.a((dxi)entry.a(), entry.b()));
        builder.a(new dxi(compoundTag, Optional.ofNullable(CraftCreatureSpawner.toMinecraftRule(spawnRule)), CraftCreatureSpawner.getEquipment(equipment)), weight);
        spawner.l = builder.a();
    }

    public void addPotentialSpawn(SpawnerEntry spawnerEntry) {
        Preconditions.checkArgument((spawnerEntry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        this.addPotentialSpawn(spawnerEntry.getSnapshot(), spawnerEntry.getSpawnWeight(), spawnerEntry.getSpawnRule());
    }

    public void setPotentialSpawns(Collection<SpawnerEntry> entries) {
        CraftCreatureSpawner.setPotentialSpawns(((emw)this.getSnapshot()).c(), entries);
    }

    public static void setPotentialSpawns(dvp spawner, Collection<SpawnerEntry> entries) {
        Preconditions.checkArgument((entries != null ? 1 : 0) != 0, (Object)"Entries cannot be null");
        cbn.a<dxi> builder = cbn.b();
        for (SpawnerEntry spawnerEntry : entries) {
            uz compoundTag = ((CraftEntitySnapshot)spawnerEntry.getSnapshot()).getData();
            builder.a(new dxi(compoundTag, Optional.ofNullable(CraftCreatureSpawner.toMinecraftRule(spawnerEntry.getSpawnRule())), CraftCreatureSpawner.getEquipment(spawnerEntry.getEquipment())), spawnerEntry.getSpawnWeight());
        }
        spawner.l = builder.a();
    }

    public List<SpawnerEntry> getPotentialSpawns() {
        return CraftCreatureSpawner.getPotentialSpawns(((emw)this.getSnapshot()).c());
    }

    public static List<SpawnerEntry> getPotentialSpawns(dvp spawner) {
        ArrayList<SpawnerEntry> entries = new ArrayList<SpawnerEntry>();
        for (cbm<dxi> entry : spawner.l.d()) {
            CraftEntitySnapshot snapshot = CraftEntitySnapshot.create(entry.a().a());
            if (snapshot == null) continue;
            SpawnRule rule = entry.a().e().map(CraftCreatureSpawner::fromMinecraftRule).orElse(null);
            entries.add(new SpawnerEntry((EntitySnapshot)snapshot, entry.b(), rule, CraftCreatureSpawner.getEquipment(entry.a().f())));
        }
        return entries;
    }

    public static dxi.a toMinecraftRule(SpawnRule rule) {
        if (rule == null) {
            return null;
        }
        return new dxi.a(new bfz<Integer>(rule.getMinBlockLight(), rule.getMaxBlockLight()), new bfz<Integer>(rule.getMinSkyLight(), rule.getMaxSkyLight()));
    }

    public static SpawnRule fromMinecraftRule(dxi.a rule) {
        bfz<Integer> blockLight = rule.a();
        bfz<Integer> skyLight = rule.b();
        return new SpawnRule(blockLight.b().intValue(), blockLight.b().intValue(), skyLight.a().intValue(), skyLight.b().intValue());
    }

    public String getCreatureTypeName() {
        dxi spawnData = ((emw)this.getSnapshot()).c().m;
        if (spawnData == null) {
            return null;
        }
        Optional<cgu<?>> type = spawnData.a().a("id", cgu.a);
        return type.map(CraftEntityType::minecraftToBukkit).map(CraftEntityType::bukkitToString).orElse(null);
    }

    public void setCreatureTypeByName(String creatureType) {
        EntityType type = CraftEntityType.stringToBukkit(creatureType);
        if (type == null) {
            this.setSpawnedType(null);
            return;
        }
        this.setSpawnedType(type);
    }

    public int getDelay() {
        return ((emw)this.getSnapshot()).c().k;
    }

    public void setDelay(int delay) {
        ((emw)this.getSnapshot()).c().k = delay;
    }

    public int getMinSpawnDelay() {
        return ((emw)this.getSnapshot()).c().p;
    }

    public void setMinSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay <= this.getMaxSpawnDelay() ? 1 : 0) != 0, (Object)"Minimum Spawn Delay must be less than or equal to Maximum Spawn Delay");
        ((emw)this.getSnapshot()).c().p = spawnDelay;
    }

    public int getMaxSpawnDelay() {
        return ((emw)this.getSnapshot()).c().q;
    }

    public void setMaxSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay > 0 ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than 0.");
        Preconditions.checkArgument((spawnDelay >= this.getMinSpawnDelay() ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than or equal to Minimum Spawn Delay");
        ((emw)this.getSnapshot()).c().q = spawnDelay;
    }

    public int getMaxNearbyEntities() {
        return ((emw)this.getSnapshot()).c().t;
    }

    public void setMaxNearbyEntities(int maxNearbyEntities) {
        ((emw)this.getSnapshot()).c().t = maxNearbyEntities;
    }

    public int getSpawnCount() {
        return ((emw)this.getSnapshot()).c().r;
    }

    public void setSpawnCount(int count) {
        ((emw)this.getSnapshot()).c().r = count;
    }

    public int getRequiredPlayerRange() {
        return ((emw)this.getSnapshot()).c().u;
    }

    public void setRequiredPlayerRange(int requiredPlayerRange) {
        ((emw)this.getSnapshot()).c().u = requiredPlayerRange;
    }

    public int getSpawnRange() {
        return ((emw)this.getSnapshot()).c().v;
    }

    public void setSpawnRange(int spawnRange) {
        ((emw)this.getSnapshot()).c().v = spawnRange;
    }

    @Override
    public CraftCreatureSpawner copy() {
        return new CraftCreatureSpawner(this, null);
    }

    @Override
    public CraftCreatureSpawner copy(Location location) {
        return new CraftCreatureSpawner(this, location);
    }

    public static Optional<cgx> getEquipment(SpawnerEntry.Equipment bukkit) {
        if (bukkit == null) {
            return Optional.empty();
        }
        return Optional.of(new cgx(CraftLootTable.bukkitToMinecraft(bukkit.getEquipmentLootTable()), bukkit.getDropChances().entrySet().stream().collect(Collectors.toMap(entry -> CraftEquipmentSlot.getNMS((EquipmentSlot)entry.getKey()), Map.Entry::getValue))));
    }

    public static SpawnerEntry.Equipment getEquipment(Optional<cgx> optional) {
        return optional.map(nms -> new SpawnerEntry.Equipment(CraftLootTable.minecraftToBukkit(nms.a()), new HashMap<EquipmentSlot, Float>(nms.b().entrySet().stream().collect(Collectors.toMap(entry -> CraftEquipmentSlot.getSlot((cgv)entry.getKey()), Map.Entry::getValue))))).orElse(null);
    }
}

