/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.block;

import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.SkullType;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Skull;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Rotatable;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R7.profile.CraftPlayerProfile;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftNamespacedKey;
import org.bukkit.profile.PlayerProfile;
import org.jetbrains.annotations.Nullable;

public class CraftSkull
extends CraftBlockEntityState<emu>
implements Skull {
    private static final int MAX_OWNER_LENGTH = 16;
    private doy profile;

    public CraftSkull(World world, emu tileEntity) {
        super(world, tileEntity);
    }

    protected CraftSkull(CraftSkull state, Location location) {
        super(state, location);
    }

    @Override
    public void load(emu skull) {
        super.load(skull);
        doy owner = skull.a();
        if (owner != null) {
            this.profile = owner;
        }
    }

    public boolean hasOwner() {
        return this.profile != null;
    }

    public String getOwner() {
        return this.hasOwner() ? (String)this.profile.d().orElse(null) : null;
    }

    public boolean setOwner(String name) {
        if (name == null || name.length() > 16) {
            return false;
        }
        bbx profile = MinecraftServer.getServer().ar().f().a(name).orElse(null);
        if (profile == null) {
            return false;
        }
        this.profile = doy.a(new GameProfile(profile.a(), profile.b()));
        return true;
    }

    public OfflinePlayer getOwningPlayer() {
        if (this.hasOwner()) {
            if (!this.profile.b().id().equals(bhs.e)) {
                return Bukkit.getOfflinePlayer((UUID)this.profile.b().id());
            }
            if (this.profile.d().filter(s2 -> !s2.isEmpty()).isPresent()) {
                return Bukkit.getOfflinePlayer((String)this.profile.d().get());
            }
        }
        return null;
    }

    public void setOwningPlayer(OfflinePlayer player) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        if (player instanceof CraftPlayer) {
            CraftPlayer craftPlayer = (CraftPlayer)player;
            this.profile = doy.a(craftPlayer.getProfile());
        } else {
            this.profile = doy.a(new GameProfile(player.getUniqueId(), player.getName() == null ? "" : player.getName()));
        }
    }

    public PlayerProfile getOwnerProfile() {
        if (!this.hasOwner()) {
            return null;
        }
        return new CraftPlayerProfile(this.profile);
    }

    public void setOwnerProfile(PlayerProfile profile) {
        this.profile = profile == null ? null : ((CraftPlayerProfile)profile).buildResolvableProfile();
    }

    public NamespacedKey getNoteBlockSound() {
        amo key = ((emu)this.getSnapshot()).c();
        return key != null ? CraftNamespacedKey.fromMinecraft(key) : null;
    }

    public void setNoteBlockSound(@Nullable NamespacedKey namespacedKey) {
        if (namespacedKey == null) {
            ((emu)this.getSnapshot()).e = null;
            return;
        }
        ((emu)this.getSnapshot()).e = CraftNamespacedKey.toMinecraft(namespacedKey);
    }

    public BlockFace getRotation() {
        BlockFace blockFace;
        BlockData blockData = this.getBlockData();
        if (blockData instanceof Rotatable) {
            Rotatable rotatable = (Rotatable)blockData;
            blockFace = rotatable.getRotation();
        } else {
            blockFace = ((Directional)blockData).getFacing();
        }
        return blockFace;
    }

    public void setRotation(BlockFace rotation) {
        BlockData blockData = this.getBlockData();
        if (blockData instanceof Rotatable) {
            ((Rotatable)blockData).setRotation(rotation);
        } else {
            ((Directional)blockData).setFacing(rotation);
        }
        this.setBlockData(blockData);
    }

    public SkullType getSkullType() {
        switch (this.getType()) {
            case SKELETON_SKULL: 
            case SKELETON_WALL_SKULL: {
                return SkullType.SKELETON;
            }
            case WITHER_SKELETON_SKULL: 
            case WITHER_SKELETON_WALL_SKULL: {
                return SkullType.WITHER;
            }
            case ZOMBIE_HEAD: 
            case ZOMBIE_WALL_HEAD: {
                return SkullType.ZOMBIE;
            }
            case PIGLIN_HEAD: 
            case PIGLIN_WALL_HEAD: {
                return SkullType.PIGLIN;
            }
            case PLAYER_HEAD: 
            case PLAYER_WALL_HEAD: {
                return SkullType.PLAYER;
            }
            case CREEPER_HEAD: 
            case CREEPER_WALL_HEAD: {
                return SkullType.CREEPER;
            }
            case DRAGON_HEAD: 
            case DRAGON_WALL_HEAD: {
                return SkullType.DRAGON;
            }
        }
        throw new IllegalArgumentException("Unknown SkullType for " + String.valueOf(this.getType()));
    }

    public void setSkullType(SkullType skullType) {
        throw new UnsupportedOperationException("Must change block type");
    }

    @Override
    protected void applyTo(emu skull) {
        super.applyTo(skull);
        if (this.getSkullType() == SkullType.PLAYER) {
            skull.d = this.hasOwner() ? this.profile : null;
        }
    }

    @Override
    public CraftSkull copy() {
        return new CraftSkull(this, null);
    }

    @Override
    public CraftSkull copy(Location location) {
        return new CraftSkull(this, location);
    }
}

