/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.block.data;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.SoundGroup;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.BlockSupport;
import org.bukkit.block.BlockType;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.structure.Mirror;
import org.bukkit.block.structure.StructureRotation;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.CraftSoundGroup;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockSupport;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R7.block.data.CraftBlockStateEnum;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftAmethystCluster;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftAnvil;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftBamboo;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftBanner;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftBannerWall;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftBarrel;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftBarrier;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftBed;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftBeehive;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftBeetroot;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftBell;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftBigDripleaf;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftBigDripleafStem;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftBlastFurnace;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftBrewingStand;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftBrushable;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftBubbleColumn;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftButtonAbstract;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCactus;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCake;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCalibratedSculkSensor;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCampfire;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCandle;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCandleCake;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCarrots;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCaveVines;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCaveVinesPlant;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCeilingHangingSign;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftChain;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftChest;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftChestTrapped;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftChiseledBookShelf;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftChorusFlower;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftChorusFruit;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCobbleWall;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCocoa;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCommand;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftComposter;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftConduit;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCopperBulb;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCopperChest;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCopperGolemStatue;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCoralDead;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCoralFan;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCoralFanAbstract;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCoralFanWall;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCoralFanWallAbstract;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCoralPlant;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCrafter;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCreakingHeart;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftCrops;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftDaylightDetector;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftDecoratedPot;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftDirtSnow;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftDispenser;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftDoor;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftDriedGhast;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftDropper;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftEndRod;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftEnderChest;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftEnderPortalFrame;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftFence;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftFenceGate;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftFire;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftFloorSign;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftFlowerBed;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftFluids;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftFurnaceFurace;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftGlazedTerracotta;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftGlowLichen;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftGrass;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftGrindstone;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftHangingMoss;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftHangingRoots;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftHay;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftHeavyCore;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftHopper;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftHugeMushroom;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftIceFrost;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftInfestedRotatedPillar;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftIronBars;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftJigsaw;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftJukeBox;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftKelp;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftLadder;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftLantern;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftLayeredCauldron;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftLeafLitter;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftLectern;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftLever;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftLight;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftLightningRod;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftLoom;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftMangroveLeaves;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftMangrovePropagule;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftMangroveRoots;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftMinecartDetector;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftMinecartTrack;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftMossyCarpet;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftMultiface;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftMycel;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftNetherWart;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftNote;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftObserver;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftPiglinWallSkull;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftPiston;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftPistonExtension;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftPistonMoving;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftPitcherCrop;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftPointedDripstone;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftPortal;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftPotatoes;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftPoweredRail;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftPressurePlateBinary;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftPressurePlateWeighted;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftPumpkinCarved;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftRedstoneComparator;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftRedstoneLamp;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftRedstoneOre;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftRedstoneTorch;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftRedstoneTorchWall;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftRedstoneWire;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftReed;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftRepeater;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftRespawnAnchor;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftRotatable;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftSapling;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftScaffolding;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftSculkCatalyst;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftSculkSensor;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftSculkShrieker;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftSculkVein;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftSeaPickle;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftShelf;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftShulkerBox;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftSkull;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftSkullPlayer;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftSkullPlayerWall;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftSkullWall;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftSmallDripleaf;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftSmoker;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftSnifferEgg;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftSnow;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftSoil;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftStainedGlassPane;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftStairs;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftStem;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftStemAttached;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftStepAbstract;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftStonecutter;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftStructure;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftSweetBerryBush;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftTNT;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftTallPlant;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftTallPlantFlower;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftTallSeagrass;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftTarget;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftTest;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftTintedParticleLeaves;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftTorchWall;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftTorchflowerCrop;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftTrapdoor;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftTrialSpawner;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftTripwire;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftTripwireHook;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftTurtleEgg;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftTwistingVines;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftUntintedParticleLeaves;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftVault;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftVine;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftWallHangingSign;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftWallSign;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftWaterloggedTransparent;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftWeatheringCopperBars;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftWeatheringCopperBulb;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftWeatheringCopperChain;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftWeatheringCopperChest;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftWeatheringCopperDoor;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftWeatheringCopperGolemStatue;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftWeatheringCopperGrate;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftWeatheringCopperSlab;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftWeatheringCopperStair;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftWeatheringCopperTrapDoor;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftWeatheringLantern;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftWeatheringLightningRod;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftWeepingVines;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftWitherSkull;
import org.bukkit.craftbukkit.v1_21_R7.block.impl.CraftWitherSkullWall;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CraftBlockData
implements BlockData {
    private eoh state;
    private Map<epk<?>, Comparable<?>> parsedStates;
    private static final Map<Class<? extends dzq>, Function<eoh, CraftBlockData>> MAP = new HashMap<Class<? extends dzq>, Function<eoh, CraftBlockData>>();

    protected CraftBlockData() {
        throw new AssertionError((Object)"Template Constructor");
    }

    protected CraftBlockData(eoh state) {
        this.state = state;
    }

    public Material getMaterial() {
        return CraftBlockType.minecraftToBukkit(this.state.b());
    }

    public eoh getState() {
        return this.state;
    }

    protected <N extends Enum<N>, B extends Enum<B>> B get(CraftBlockStateEnum<N, B> nms) {
        return nms.toBukkit((Enum)this.state.c(nms.nms()));
    }

    protected <N extends Enum<N>, B extends Enum<B>> Set<B> getValues(CraftBlockStateEnum<N, B> nms) {
        return nms.getValues();
    }

    protected <N extends Enum<N>, B extends Enum<B>> void set(CraftBlockStateEnum<N, B> nms, B bukkit) {
        this.parsedStates = null;
        this.state = (eoh)this.state.b(nms.nms(), nms.toNMS(bukkit));
    }

    public BlockData merge(BlockData data) {
        CraftBlockData craft = (CraftBlockData)data;
        Preconditions.checkArgument((craft.parsedStates != null ? 1 : 0) != 0, (Object)"Data not created via string parsing");
        Preconditions.checkArgument((this.state.b() == craft.state.b() ? 1 : 0) != 0, (String)"States have different types (got %s, expected %s)", (Object)data, (Object)this);
        CraftBlockData clone = (CraftBlockData)this.clone();
        clone.parsedStates = null;
        for (epk<?> parsed : craft.parsedStates.keySet()) {
            clone.state = (eoh)clone.state.b(parsed, craft.state.c(parsed));
        }
        return clone;
    }

    public boolean matches(BlockData data) {
        if (data == null) {
            return false;
        }
        if (!(data instanceof CraftBlockData)) {
            return false;
        }
        CraftBlockData craft = (CraftBlockData)data;
        if (this.state.b() != craft.state.b()) {
            return false;
        }
        boolean exactMatch = this.equals(data);
        if (!exactMatch && craft.parsedStates != null) {
            return this.merge(data).equals((Object)this);
        }
        return exactMatch;
    }

    protected <T extends Comparable<T>> T get(epk<T> ibs) {
        return this.state.c(ibs);
    }

    public <T extends Comparable<T>, V extends T> void set(epk<T> ibs, V v2) {
        this.parsedStates = null;
        this.state = (eoh)this.state.b(ibs, v2);
    }

    public String getAsString() {
        return this.toString(this.state.G());
    }

    public String getAsString(boolean hideUnspecified) {
        return hideUnspecified && this.parsedStates != null ? this.toString(this.parsedStates) : this.getAsString();
    }

    public BlockData clone() {
        try {
            return (BlockData)super.clone();
        }
        catch (CloneNotSupportedException ex2) {
            throw new AssertionError("Clone not supported", ex2);
        }
    }

    public String toString() {
        return "CraftBlockData{" + this.getAsString() + "}";
    }

    public String toString(Map<epk<?>, Comparable<?>> states) {
        StringBuilder stateString = new StringBuilder(mi.e.b(this.state.b()).toString());
        if (!states.isEmpty()) {
            stateString.append('[');
            stateString.append(states.entrySet().stream().map(eoj.a).collect(Collectors.joining(",")));
            stateString.append(']');
        }
        return stateString.toString();
    }

    public Map<String, String> toStates(boolean hideUnspecified) {
        return hideUnspecified && this.parsedStates != null ? CraftBlockData.toStates(this.parsedStates) : CraftBlockData.toStates(this.state.G());
    }

    private static Map<String, String> toStates(Map<epk<?>, Comparable<?>> states) {
        HashMap<String, String> compound = new HashMap<String, String>();
        for (Map.Entry<epk<?>, Comparable<?>> entry : states.entrySet()) {
            epk<?> iblockstate = entry.getKey();
            compound.put(iblockstate.f(), iblockstate.b(entry.getValue()));
        }
        return compound;
    }

    public boolean equals(Object obj) {
        return obj instanceof CraftBlockData && this.state.equals(((CraftBlockData)obj).state);
    }

    public int hashCode() {
        return this.state.hashCode();
    }

    protected static eoy getBoolean(String name) {
        throw new AssertionError((Object)"Template Method");
    }

    protected static eoy getBoolean(String name, boolean optional) {
        throw new AssertionError((Object)"Template Method");
    }

    protected static <B extends Enum<B>> CraftBlockStateEnum<?, B> getEnum(String name, Class<? extends Enum<B>> bukkit) {
        throw new AssertionError((Object)"Template Method");
    }

    protected static eph getInteger(String name) {
        throw new AssertionError((Object)"Template Method");
    }

    protected static eoy getBoolean(Class<? extends dzq> block, String name) {
        return (eoy)CraftBlockData.getState(block, name, false);
    }

    protected static eoy getBoolean(Class<? extends dzq> block, String name, boolean optional) {
        return (eoy)CraftBlockData.getState(block, name, optional);
    }

    protected static <B extends Enum<B>> CraftBlockStateEnum<?, B> getEnum(Class<? extends dzq> block, String name, Class<B> bukkit) {
        return new CraftBlockStateEnum((epf)CraftBlockData.getState(block, name, false), bukkit);
    }

    protected static eph getInteger(Class<? extends dzq> block, String name) {
        return (eph)CraftBlockData.getState(block, name, false);
    }

    private static epk<?> getState(Class<? extends dzq> block, String name, boolean optional) {
        epk<?> state = null;
        for (dzq instance : mi.e) {
            if (instance.getClass() != block) continue;
            if (state == null) {
                state = instance.l().a(name);
                continue;
            }
            epk<?> newState = instance.l().a(name);
            Preconditions.checkState((state == newState ? 1 : 0) != 0, (String)"State mistmatch %s,%s", state, newState);
        }
        Preconditions.checkState((optional || state != null ? 1 : 0) != 0, (String)"Null state for %s,%s", block, (Object)name);
        return state;
    }

    protected static int getMin(eph state) {
        return state.b;
    }

    protected static int getMax(eph state) {
        return state.c;
    }

    private static void register(Class<? extends dzq> nms, Function<eoh, CraftBlockData> bukkit) {
        Preconditions.checkState((MAP.put(nms, bukkit) == null ? 1 : 0) != 0, (String)"Duplicate mapping %s->%s", nms, bukkit);
    }

    public static CraftBlockData newData(BlockType blockType, String data) {
        eoh blockData;
        dzq block = blockType == null ? null : (dzq)((CraftBlockType)blockType).getHandle();
        Map<epk<?>, Comparable<?>> parsed = null;
        if (data != null) {
            try {
                if (block != null) {
                    data = String.valueOf(mi.e.b(block)) + (String)data;
                }
                StringReader reader = new StringReader((String)data);
                ga.a arg2 = ga.a(CraftRegistry.getMinecraftRegistry(mj.i), reader, false);
                Preconditions.checkArgument((!reader.canRead() ? 1 : 0) != 0, (Object)("Spurious trailing data: " + (String)data));
                blockData = arg2.a();
                parsed = arg2.b();
            }
            catch (CommandSyntaxException ex2) {
                throw new IllegalArgumentException("Could not parse data: " + (String)data, ex2);
            }
        } else {
            blockData = block.m();
        }
        CraftBlockData craft = CraftBlockData.fromData(blockData);
        craft.parsedStates = parsed;
        return craft;
    }

    public static CraftBlockData fromData(eoh data) {
        return (CraftBlockData)MAP.getOrDefault(data.b().getClass(), (Function<eoh, CraftBlockData>)((Function)CraftBlockData::new)).apply((Object)data);
    }

    public SoundGroup getSoundGroup() {
        return CraftSoundGroup.getSoundGroup(this.state.A());
    }

    public int getLightEmission() {
        return this.state.k();
    }

    public boolean isOccluding() {
        return this.state.t();
    }

    public boolean requiresCorrectToolForDrops() {
        return this.state.C();
    }

    public boolean isPreferredTool(ItemStack tool) {
        Preconditions.checkArgument((tool != null ? 1 : 0) != 0, (Object)"tool must not be null");
        dlt nms = CraftItemStack.asNMSCopy(tool);
        return CraftBlockData.isPreferredTool(this.state, nms);
    }

    public static boolean isPreferredTool(eoh iblockdata, dlt nmsItem) {
        return !iblockdata.C() || nmsItem.b(iblockdata);
    }

    public PistonMoveReaction getPistonMoveReaction() {
        return PistonMoveReaction.getById((int)this.state.r().ordinal());
    }

    public boolean isSupported(Block block) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"block must not be null");
        CraftBlock craftBlock = (CraftBlock)block;
        return this.state.a((dwr)craftBlock.getCraftWorld().getHandle(), craftBlock.getPosition());
    }

    public boolean isSupported(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location must not be null");
        CraftWorld world = (CraftWorld)location.getWorld();
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"location must not have a null world");
        is position = CraftLocation.toBlockPosition(location);
        return this.state.a((dwr)world.getHandle(), position);
    }

    public boolean isFaceSturdy(BlockFace face, BlockSupport support) {
        Preconditions.checkArgument((face != null ? 1 : 0) != 0, (Object)"face must not be null");
        Preconditions.checkArgument((support != null ? 1 : 0) != 0, (Object)"support must not be null");
        return this.state.a((dvt)dwf.a, is.c, CraftBlock.blockFaceToNotch(face), CraftBlockSupport.toNMS(support));
    }

    public Color getMapColor() {
        return Color.fromRGB((int)this.state.a(null, null).ak);
    }

    public Material getPlacementMaterial() {
        return CraftItemType.minecraftToBukkit(this.state.b().h());
    }

    public void rotate(StructureRotation rotation) {
        this.state = this.state.a(egm.valueOf(rotation.name()));
    }

    public void mirror(Mirror mirror) {
        this.state = this.state.a(eev.valueOf(mirror.name()));
    }

    public void copyTo(BlockData blockData) {
        CraftBlockData other = (CraftBlockData)blockData;
        eoh nms = other.state;
        for (epk<?> property : this.state.b().l().d()) {
            if (!nms.b(property)) continue;
            nms = this.copyProperty(this.state, nms, property);
        }
        other.state = nms;
    }

    private <T extends Comparable<T>> eoh copyProperty(eoh source, eoh target, epk<T> property) {
        return (eoh)target.b(property, source.c(property));
    }

    @NotNull
    public BlockState createBlockState() {
        return CraftBlockStates.getBlockState(this.state, null);
    }

    static {
        CraftBlockData.register(dyp.class, (Function<eoh, CraftBlockData>)((Function)CraftAmethystCluster::new));
        CraftBlockData.register(dzn.class, (Function<eoh, CraftBlockData>)((Function)CraftBigDripleaf::new));
        CraftBlockData.register(dzo.class, (Function<eoh, CraftBlockData>)((Function)CraftBigDripleafStem::new));
        CraftBlockData.register(dyq.class, (Function<eoh, CraftBlockData>)((Function)CraftAnvil::new));
        CraftBlockData.register(dyu.class, (Function<eoh, CraftBlockData>)((Function)CraftBamboo::new));
        CraftBlockData.register(dyv.class, (Function<eoh, CraftBlockData>)((Function)CraftBanner::new));
        CraftBlockData.register(eji.class, (Function<eoh, CraftBlockData>)((Function)CraftBannerWall::new));
        CraftBlockData.register(dyw.class, (Function<eoh, CraftBlockData>)((Function)CraftBarrel::new));
        CraftBlockData.register(dyx.class, (Function<eoh, CraftBlockData>)((Function)CraftBarrier::new));
        CraftBlockData.register(dzj.class, (Function<eoh, CraftBlockData>)((Function)CraftBed::new));
        CraftBlockData.register(dzk.class, (Function<eoh, CraftBlockData>)((Function)CraftBeehive::new));
        CraftBlockData.register(dzl.class, (Function<eoh, CraftBlockData>)((Function)CraftBeetroot::new));
        CraftBlockData.register(dzm.class, (Function<eoh, CraftBlockData>)((Function)CraftBell::new));
        CraftBlockData.register(dzp.class, (Function<eoh, CraftBlockData>)((Function)CraftBlastFurnace::new));
        CraftBlockData.register(dzv.class, (Function<eoh, CraftBlockData>)((Function)CraftBrewingStand::new));
        CraftBlockData.register(dzx.class, (Function<eoh, CraftBlockData>)((Function)CraftBubbleColumn::new));
        CraftBlockData.register(eab.class, (Function<eoh, CraftBlockData>)((Function)CraftButtonAbstract::new));
        CraftBlockData.register(eac.class, (Function<eoh, CraftBlockData>)((Function)CraftCactus::new));
        CraftBlockData.register(eae.class, (Function<eoh, CraftBlockData>)((Function)CraftCake::new));
        CraftBlockData.register(eag.class, (Function<eoh, CraftBlockData>)((Function)CraftCampfire::new));
        CraftBlockData.register(eak.class, (Function<eoh, CraftBlockData>)((Function)CraftCarrots::new));
        CraftBlockData.register(eas.class, (Function<eoh, CraftBlockData>)((Function)CraftChain::new));
        CraftBlockData.register(eau.class, (Function<eoh, CraftBlockData>)((Function)CraftChest::new));
        CraftBlockData.register(eix.class, (Function<eoh, CraftBlockData>)((Function)CraftChestTrapped::new));
        CraftBlockData.register(eaw.class, (Function<eoh, CraftBlockData>)((Function)CraftChorusFlower::new));
        CraftBlockData.register(eax.class, (Function<eoh, CraftBlockData>)((Function)CraftChorusFruit::new));
        CraftBlockData.register(ejj.class, (Function<eoh, CraftBlockData>)((Function)CraftCobbleWall::new));
        CraftBlockData.register(eay.class, (Function<eoh, CraftBlockData>)((Function)CraftCocoa::new));
        CraftBlockData.register(eba.class, (Function<eoh, CraftBlockData>)((Function)CraftCommand::new));
        CraftBlockData.register(ebc.class, (Function<eoh, CraftBlockData>)((Function)CraftComposter::new));
        CraftBlockData.register(ebe.class, (Function<eoh, CraftBlockData>)((Function)CraftConduit::new));
        CraftBlockData.register(dyz.class, (Function<eoh, CraftBlockData>)((Function)CraftCoralDead::new));
        CraftBlockData.register(ebj.class, (Function<eoh, CraftBlockData>)((Function)CraftCoralFan::new));
        CraftBlockData.register(dyy.class, (Function<eoh, CraftBlockData>)((Function)CraftCoralFanAbstract::new));
        CraftBlockData.register(ebl.class, (Function<eoh, CraftBlockData>)((Function)CraftCoralFanWall::new));
        CraftBlockData.register(dzb.class, (Function<eoh, CraftBlockData>)((Function)CraftCoralFanWallAbstract::new));
        CraftBlockData.register(ebk.class, (Function<eoh, CraftBlockData>)((Function)CraftCoralPlant::new));
        CraftBlockData.register(ebp.class, (Function<eoh, CraftBlockData>)((Function)CraftCrops::new));
        CraftBlockData.register(ebs.class, (Function<eoh, CraftBlockData>)((Function)CraftDaylightDetector::new));
        CraftBlockData.register(ehp.class, (Function<eoh, CraftBlockData>)((Function)CraftDirtSnow::new));
        CraftBlockData.register(eby.class, (Function<eoh, CraftBlockData>)((Function)CraftDispenser::new));
        CraftBlockData.register(ebz.class, (Function<eoh, CraftBlockData>)((Function)CraftDoor::new));
        CraftBlockData.register(ecf.class, (Function<eoh, CraftBlockData>)((Function)CraftDropper::new));
        CraftBlockData.register(ecl.class, (Function<eoh, CraftBlockData>)((Function)CraftEndRod::new));
        CraftBlockData.register(ecm.class, (Function<eoh, CraftBlockData>)((Function)CraftEnderChest::new));
        CraftBlockData.register(eck.class, (Function<eoh, CraftBlockData>)((Function)CraftEnderPortalFrame::new));
        CraftBlockData.register(ect.class, (Function<eoh, CraftBlockData>)((Function)CraftFence::new));
        CraftBlockData.register(ecu.class, (Function<eoh, CraftBlockData>)((Function)CraftFenceGate::new));
        CraftBlockData.register(ecv.class, (Function<eoh, CraftBlockData>)((Function)CraftFire::new));
        CraftBlockData.register(eia.class, (Function<eoh, CraftBlockData>)((Function)CraftFloorSign::new));
        CraftBlockData.register(eeo.class, (Function<eoh, CraftBlockData>)((Function)CraftFluids::new));
        CraftBlockData.register(edd.class, (Function<eoh, CraftBlockData>)((Function)CraftFurnaceFurace::new));
        CraftBlockData.register(edf.class, (Function<eoh, CraftBlockData>)((Function)CraftGlazedTerracotta::new));
        CraftBlockData.register(edh.class, (Function<eoh, CraftBlockData>)((Function)CraftGrass::new));
        CraftBlockData.register(edi.class, (Function<eoh, CraftBlockData>)((Function)CraftGrindstone::new));
        CraftBlockData.register(edp.class, (Function<eoh, CraftBlockData>)((Function)CraftHay::new));
        CraftBlockData.register(eds.class, (Function<eoh, CraftBlockData>)((Function)CraftHopper::new));
        CraftBlockData.register(edu.class, (Function<eoh, CraftBlockData>)((Function)CraftHugeMushroom::new));
        CraftBlockData.register(edb.class, (Function<eoh, CraftBlockData>)((Function)CraftIceFrost::new));
        CraftBlockData.register(edy.class, (Function<eoh, CraftBlockData>)((Function)CraftIronBars::new));
        CraftBlockData.register(edz.class, (Function<eoh, CraftBlockData>)((Function)CraftJigsaw::new));
        CraftBlockData.register(eea.class, (Function<eoh, CraftBlockData>)((Function)CraftJukeBox::new));
        CraftBlockData.register(eeb.class, (Function<eoh, CraftBlockData>)((Function)CraftKelp::new));
        CraftBlockData.register(eed.class, (Function<eoh, CraftBlockData>)((Function)CraftLadder::new));
        CraftBlockData.register(eee.class, (Function<eoh, CraftBlockData>)((Function)CraftLantern::new));
        CraftBlockData.register(eej.class, (Function<eoh, CraftBlockData>)((Function)CraftLectern::new));
        CraftBlockData.register(eel.class, (Function<eoh, CraftBlockData>)((Function)CraftLever::new));
        CraftBlockData.register(eeq.class, (Function<eoh, CraftBlockData>)((Function)CraftLoom::new));
        CraftBlockData.register(ebu.class, (Function<eoh, CraftBlockData>)((Function)CraftMinecartDetector::new));
        CraftBlockData.register(efy.class, (Function<eoh, CraftBlockData>)((Function)CraftMinecartTrack::new));
        CraftBlockData.register(efc.class, (Function<eoh, CraftBlockData>)((Function)CraftMycel::new));
        CraftBlockData.register(efg.class, (Function<eoh, CraftBlockData>)((Function)CraftNetherWart::new));
        CraftBlockData.register(efi.class, (Function<eoh, CraftBlockData>)((Function)CraftNote::new));
        CraftBlockData.register(efk.class, (Function<eoh, CraftBlockData>)((Function)CraftObserver::new));
        CraftBlockData.register(efd.class, (Function<eoh, CraftBlockData>)((Function)CraftPortal::new));
        CraftBlockData.register(efs.class, (Function<eoh, CraftBlockData>)((Function)CraftPotatoes::new));
        CraftBlockData.register(efv.class, (Function<eoh, CraftBlockData>)((Function)CraftPoweredRail::new));
        CraftBlockData.register(efw.class, (Function<eoh, CraftBlockData>)((Function)CraftPressurePlateBinary::new));
        CraftBlockData.register(eki.class, (Function<eoh, CraftBlockData>)((Function)CraftPressurePlateWeighted::new));
        CraftBlockData.register(eam.class, (Function<eoh, CraftBlockData>)((Function)CraftPumpkinCarved::new));
        CraftBlockData.register(ebb.class, (Function<eoh, CraftBlockData>)((Function)CraftRedstoneComparator::new));
        CraftBlockData.register(egc.class, (Function<eoh, CraftBlockData>)((Function)CraftRedstoneLamp::new));
        CraftBlockData.register(ega.class, (Function<eoh, CraftBlockData>)((Function)CraftRedstoneOre::new));
        CraftBlockData.register(egd.class, (Function<eoh, CraftBlockData>)((Function)CraftRedstoneTorch::new));
        CraftBlockData.register(ege.class, (Function<eoh, CraftBlockData>)((Function)CraftRedstoneTorchWall::new));
        CraftBlockData.register(egb.class, (Function<eoh, CraftBlockData>)((Function)CraftRedstoneWire::new));
        CraftBlockData.register(eif.class, (Function<eoh, CraftBlockData>)((Function)CraftReed::new));
        CraftBlockData.register(egg.class, (Function<eoh, CraftBlockData>)((Function)CraftRepeater::new));
        CraftBlockData.register(egh.class, (Function<eoh, CraftBlockData>)((Function)CraftRespawnAnchor::new));
        CraftBlockData.register(egl.class, (Function<eoh, CraftBlockData>)((Function)CraftRotatable::new));
        CraftBlockData.register(ego.class, (Function<eoh, CraftBlockData>)((Function)CraftSapling::new));
        CraftBlockData.register(egp.class, (Function<eoh, CraftBlockData>)((Function)CraftScaffolding::new));
        CraftBlockData.register(egx.class, (Function<eoh, CraftBlockData>)((Function)CraftSeaPickle::new));
        CraftBlockData.register(ehd.class, (Function<eoh, CraftBlockData>)((Function)CraftShulkerBox::new));
        CraftBlockData.register(ehh.class, (Function<eoh, CraftBlockData>)((Function)CraftSkull::new));
        CraftBlockData.register(efo.class, (Function<eoh, CraftBlockData>)((Function)CraftSkullPlayer::new));
        CraftBlockData.register(efp.class, (Function<eoh, CraftBlockData>)((Function)CraftSkullPlayerWall::new));
        CraftBlockData.register(ejm.class, (Function<eoh, CraftBlockData>)((Function)CraftSkullWall::new));
        CraftBlockData.register(ehm.class, (Function<eoh, CraftBlockData>)((Function)CraftSmoker::new));
        CraftBlockData.register(eho.class, (Function<eoh, CraftBlockData>)((Function)CraftSnow::new));
        CraftBlockData.register(ecs.class, (Function<eoh, CraftBlockData>)((Function)CraftSoil::new));
        CraftBlockData.register(ehy.class, (Function<eoh, CraftBlockData>)((Function)CraftStainedGlassPane::new));
        CraftBlockData.register(ehz.class, (Function<eoh, CraftBlockData>)((Function)CraftStairs::new));
        CraftBlockData.register(eib.class, (Function<eoh, CraftBlockData>)((Function)CraftStem::new));
        CraftBlockData.register(dyr.class, (Function<eoh, CraftBlockData>)((Function)CraftStemAttached::new));
        CraftBlockData.register(ehi.class, (Function<eoh, CraftBlockData>)((Function)CraftStepAbstract::new));
        CraftBlockData.register(eic.class, (Function<eoh, CraftBlockData>)((Function)CraftStonecutter::new));
        CraftBlockData.register(eid.class, (Function<eoh, CraftBlockData>)((Function)CraftStructure::new));
        CraftBlockData.register(eii.class, (Function<eoh, CraftBlockData>)((Function)CraftSweetBerryBush::new));
        CraftBlockData.register(eis.class, (Function<eoh, CraftBlockData>)((Function)CraftTNT::new));
        CraftBlockData.register(ecb.class, (Function<eoh, CraftBlockData>)((Function)CraftTallPlant::new));
        CraftBlockData.register(eik.class, (Function<eoh, CraftBlockData>)((Function)CraftTallPlantFlower::new));
        CraftBlockData.register(ein.class, (Function<eoh, CraftBlockData>)((Function)CraftTarget::new));
        CraftBlockData.register(ejn.class, (Function<eoh, CraftBlockData>)((Function)CraftTorchWall::new));
        CraftBlockData.register(eiw.class, (Function<eoh, CraftBlockData>)((Function)CraftTrapdoor::new));
        CraftBlockData.register(eiz.class, (Function<eoh, CraftBlockData>)((Function)CraftTripwire::new));
        CraftBlockData.register(eja.class, (Function<eoh, CraftBlockData>)((Function)CraftTripwireHook::new));
        CraftBlockData.register(ejb.class, (Function<eoh, CraftBlockData>)((Function)CraftTurtleEgg::new));
        CraftBlockData.register(ejc.class, (Function<eoh, CraftBlockData>)((Function)CraftTwistingVines::new));
        CraftBlockData.register(ejh.class, (Function<eoh, CraftBlockData>)((Function)CraftVine::new));
        CraftBlockData.register(ejl.class, (Function<eoh, CraftBlockData>)((Function)CraftWallSign::new));
        CraftBlockData.register(ekg.class, (Function<eoh, CraftBlockData>)((Function)CraftWeepingVines::new));
        CraftBlockData.register(ekl.class, (Function<eoh, CraftBlockData>)((Function)CraftWitherSkull::new));
        CraftBlockData.register(ekm.class, (Function<eoh, CraftBlockData>)((Function)CraftWitherSkullWall::new));
        CraftBlockData.register(dzw.class, (Function<eoh, CraftBlockData>)((Function)CraftBrushable::new));
        CraftBlockData.register(eaf.class, (Function<eoh, CraftBlockData>)((Function)CraftCalibratedSculkSensor::new));
        CraftBlockData.register(eah.class, (Function<eoh, CraftBlockData>)((Function)CraftCandle::new));
        CraftBlockData.register(eai.class, (Function<eoh, CraftBlockData>)((Function)CraftCandleCake::new));
        CraftBlockData.register(eap.class, (Function<eoh, CraftBlockData>)((Function)CraftCaveVines::new));
        CraftBlockData.register(eaq.class, (Function<eoh, CraftBlockData>)((Function)CraftCaveVinesPlant::new));
        CraftBlockData.register(ear.class, (Function<eoh, CraftBlockData>)((Function)CraftCeilingHangingSign::new));
        CraftBlockData.register(eav.class, (Function<eoh, CraftBlockData>)((Function)CraftChiseledBookShelf::new));
        CraftBlockData.register(ebf.class, (Function<eoh, CraftBlockData>)((Function)CraftCopperBulb::new));
        CraftBlockData.register(ebg.class, (Function<eoh, CraftBlockData>)((Function)CraftCopperChest::new));
        CraftBlockData.register(ebh.class, (Function<eoh, CraftBlockData>)((Function)CraftCopperGolemStatue::new));
        CraftBlockData.register(ebm.class, (Function<eoh, CraftBlockData>)((Function)CraftCrafter::new));
        CraftBlockData.register(ebo.class, (Function<eoh, CraftBlockData>)((Function)CraftCreakingHeart::new));
        CraftBlockData.register(ebt.class, (Function<eoh, CraftBlockData>)((Function)CraftDecoratedPot::new));
        CraftBlockData.register(ecd.class, (Function<eoh, CraftBlockData>)((Function)CraftDriedGhast::new));
        CraftBlockData.register(ecx.class, (Function<eoh, CraftBlockData>)((Function)CraftFlowerBed::new));
        CraftBlockData.register(edg.class, (Function<eoh, CraftBlockData>)((Function)CraftGlowLichen::new));
        CraftBlockData.register(edn.class, (Function<eoh, CraftBlockData>)((Function)CraftHangingMoss::new));
        CraftBlockData.register(edo.class, (Function<eoh, CraftBlockData>)((Function)CraftHangingRoots::new));
        CraftBlockData.register(edq.class, (Function<eoh, CraftBlockData>)((Function)CraftHeavyCore::new));
        CraftBlockData.register(edx.class, (Function<eoh, CraftBlockData>)((Function)CraftInfestedRotatedPillar::new));
        CraftBlockData.register(eeg.class, (Function<eoh, CraftBlockData>)((Function)CraftLayeredCauldron::new));
        CraftBlockData.register(eeh.class, (Function<eoh, CraftBlockData>)((Function)CraftLeafLitter::new));
        CraftBlockData.register(eem.class, (Function<eoh, CraftBlockData>)((Function)CraftLight::new));
        CraftBlockData.register(een.class, (Function<eoh, CraftBlockData>)((Function)CraftLightningRod::new));
        CraftBlockData.register(ees.class, (Function<eoh, CraftBlockData>)((Function)CraftMangroveLeaves::new));
        CraftBlockData.register(eet.class, (Function<eoh, CraftBlockData>)((Function)CraftMangrovePropagule::new));
        CraftBlockData.register(eeu.class, (Function<eoh, CraftBlockData>)((Function)CraftMangroveRoots::new));
        CraftBlockData.register(eew.class, (Function<eoh, CraftBlockData>)((Function)CraftMossyCarpet::new));
        CraftBlockData.register(eey.class, (Function<eoh, CraftBlockData>)((Function)CraftMultiface::new));
        CraftBlockData.register(efl.class, (Function<eoh, CraftBlockData>)((Function)CraftPiglinWallSkull::new));
        CraftBlockData.register(efn.class, (Function<eoh, CraftBlockData>)((Function)CraftPitcherCrop::new));
        CraftBlockData.register(efq.class, (Function<eoh, CraftBlockData>)((Function)CraftPointedDripstone::new));
        CraftBlockData.register(egs.class, (Function<eoh, CraftBlockData>)((Function)CraftSculkCatalyst::new));
        CraftBlockData.register(egt.class, (Function<eoh, CraftBlockData>)((Function)CraftSculkSensor::new));
        CraftBlockData.register(egu.class, (Function<eoh, CraftBlockData>)((Function)CraftSculkShrieker::new));
        CraftBlockData.register(egw.class, (Function<eoh, CraftBlockData>)((Function)CraftSculkVein::new));
        CraftBlockData.register(ehb.class, (Function<eoh, CraftBlockData>)((Function)CraftShelf::new));
        CraftBlockData.register(ehk.class, (Function<eoh, CraftBlockData>)((Function)CraftSmallDripleaf::new));
        CraftBlockData.register(ehn.class, (Function<eoh, CraftBlockData>)((Function)CraftSnifferEgg::new));
        CraftBlockData.register(eim.class, (Function<eoh, CraftBlockData>)((Function)CraftTallSeagrass::new));
        CraftBlockData.register(eio.class, (Function<eoh, CraftBlockData>)((Function)CraftTest::new));
        CraftBlockData.register(eir.class, (Function<eoh, CraftBlockData>)((Function)CraftTintedParticleLeaves::new));
        CraftBlockData.register(eiu.class, (Function<eoh, CraftBlockData>)((Function)CraftTorchflowerCrop::new));
        CraftBlockData.register(eiy.class, (Function<eoh, CraftBlockData>)((Function)CraftTrialSpawner::new));
        CraftBlockData.register(eje.class, (Function<eoh, CraftBlockData>)((Function)CraftUntintedParticleLeaves::new));
        CraftBlockData.register(ejf.class, (Function<eoh, CraftBlockData>)((Function)CraftVault::new));
        CraftBlockData.register(ejk.class, (Function<eoh, CraftBlockData>)((Function)CraftWallHangingSign::new));
        CraftBlockData.register(ejp.class, (Function<eoh, CraftBlockData>)((Function)CraftWaterloggedTransparent::new));
        CraftBlockData.register(ejr.class, (Function<eoh, CraftBlockData>)((Function)CraftWeatheringCopperBars::new));
        CraftBlockData.register(ejt.class, (Function<eoh, CraftBlockData>)((Function)CraftWeatheringCopperBulb::new));
        CraftBlockData.register(eju.class, (Function<eoh, CraftBlockData>)((Function)CraftWeatheringCopperChain::new));
        CraftBlockData.register(ejv.class, (Function<eoh, CraftBlockData>)((Function)CraftWeatheringCopperChest::new));
        CraftBlockData.register(ejw.class, (Function<eoh, CraftBlockData>)((Function)CraftWeatheringCopperDoor::new));
        CraftBlockData.register(ejy.class, (Function<eoh, CraftBlockData>)((Function)CraftWeatheringCopperGolemStatue::new));
        CraftBlockData.register(ejz.class, (Function<eoh, CraftBlockData>)((Function)CraftWeatheringCopperGrate::new));
        CraftBlockData.register(eka.class, (Function<eoh, CraftBlockData>)((Function)CraftWeatheringCopperSlab::new));
        CraftBlockData.register(ekb.class, (Function<eoh, CraftBlockData>)((Function)CraftWeatheringCopperStair::new));
        CraftBlockData.register(ekc.class, (Function<eoh, CraftBlockData>)((Function)CraftWeatheringCopperTrapDoor::new));
        CraftBlockData.register(ekd.class, (Function<eoh, CraftBlockData>)((Function)CraftWeatheringLantern::new));
        CraftBlockData.register(eke.class, (Function<eoh, CraftBlockData>)((Function)CraftWeatheringLightningRod::new));
        CraftBlockData.register(eny.class, (Function<eoh, CraftBlockData>)((Function)CraftPiston::new));
        CraftBlockData.register(enz.class, (Function<eoh, CraftBlockData>)((Function)CraftPistonExtension::new));
        CraftBlockData.register(enx.class, (Function<eoh, CraftBlockData>)((Function)CraftPistonMoving::new));
    }
}

