/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.block.data.type;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.RedstoneWire;
import org.bukkit.craftbukkit.v1_21_R7.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R7.block.data.CraftBlockStateEnum;

public abstract class CraftRedstoneWire
extends CraftBlockData
implements RedstoneWire {
    private static final CraftBlockStateEnum<?, RedstoneWire.Connection> NORTH = CraftRedstoneWire.getEnum("north", RedstoneWire.Connection.class);
    private static final CraftBlockStateEnum<?, RedstoneWire.Connection> EAST = CraftRedstoneWire.getEnum("east", RedstoneWire.Connection.class);
    private static final CraftBlockStateEnum<?, RedstoneWire.Connection> SOUTH = CraftRedstoneWire.getEnum("south", RedstoneWire.Connection.class);
    private static final CraftBlockStateEnum<?, RedstoneWire.Connection> WEST = CraftRedstoneWire.getEnum("west", RedstoneWire.Connection.class);

    public RedstoneWire.Connection getFace(BlockFace face) {
        switch (face) {
            case NORTH: {
                return this.get(NORTH);
            }
            case EAST: {
                return this.get(EAST);
            }
            case SOUTH: {
                return this.get(SOUTH);
            }
            case WEST: {
                return this.get(WEST);
            }
        }
        throw new IllegalArgumentException("Cannot have face " + String.valueOf(face));
    }

    public void setFace(BlockFace face, RedstoneWire.Connection connection) {
        switch (face) {
            case NORTH: {
                this.set(NORTH, connection);
                break;
            }
            case EAST: {
                this.set(EAST, connection);
                break;
            }
            case SOUTH: {
                this.set(SOUTH, connection);
                break;
            }
            case WEST: {
                this.set(WEST, connection);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot have face " + String.valueOf(face));
            }
        }
    }

    public Set<BlockFace> getAllowedFaces() {
        return ImmutableSet.of((Object)BlockFace.NORTH, (Object)BlockFace.EAST, (Object)BlockFace.SOUTH, (Object)BlockFace.WEST);
    }
}

