/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.command;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.util.Waitable;
import org.bukkit.event.Event;
import org.bukkit.event.server.TabCompleteEvent;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;

public class ConsoleCommandCompleter
implements Completer {
    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        final CraftServer server = (CraftServer)Bukkit.getServer();
        if (server == null) {
            return;
        }
        final String buffer = line.line();
        Waitable<List<String>> waitable = new Waitable<List<String>>(this){

            @Override
            protected List<String> evaluate() {
                List offers = server.getCommandMap().tabComplete((CommandSender)server.getConsoleSender(), buffer);
                TabCompleteEvent tabEvent = new TabCompleteEvent((CommandSender)server.getConsoleSender(), buffer, offers == null ? Collections.EMPTY_LIST : offers);
                server.getPluginManager().callEvent((Event)tabEvent);
                return tabEvent.isCancelled() ? Collections.EMPTY_LIST : tabEvent.getCompletions();
            }
        };
        server.getServer().processQueue.add(waitable);
        try {
            List offers = (List)waitable.get();
            if (offers == null) {
                return;
            }
            offers.stream().map(Candidate::new).forEach(candidate -> candidates.add((Candidate)candidate));
        }
        catch (ExecutionException e2) {
            server.getLogger().log(Level.WARNING, "Unhandled exception when tab completing", e2);
        }
        catch (InterruptedException e3) {
            Thread.currentThread().interrupt();
        }
    }
}

