/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.damage;

import com.google.common.base.Preconditions;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.damage.CraftDamageEffect;
import org.bukkit.craftbukkit.v1_21_R7.registry.CraftRegistryItem;
import org.bukkit.damage.DamageEffect;
import org.bukkit.damage.DamageScaling;
import org.bukkit.damage.DamageType;
import org.bukkit.damage.DeathMessageType;

public class CraftDamageType
extends CraftRegistryItem<cez>
implements DamageType {
    public CraftDamageType(NamespacedKey key, jd<cez> handle) {
        super(key, handle);
    }

    public String getTranslationKey() {
        return ((cez)this.getHandle()).a();
    }

    public DamageScaling getDamageScaling() {
        return CraftDamageType.damageScalingToBukkit(((cez)this.getHandle()).b());
    }

    public DamageEffect getDamageEffect() {
        return CraftDamageEffect.toBukkit(((cez)this.getHandle()).d());
    }

    public DeathMessageType getDeathMessageType() {
        return CraftDamageType.deathMessageTypeToBukkit(((cez)this.getHandle()).e());
    }

    public float getExhaustion() {
        return ((cez)this.getHandle()).c();
    }

    public NamespacedKey getKey() {
        return this.getKeyOrThrow();
    }

    public static DeathMessageType deathMessageTypeToBukkit(cfb deathMessageType) {
        return switch (deathMessageType) {
            case cfb.a -> DeathMessageType.DEFAULT;
            case cfb.b -> DeathMessageType.FALL_VARIANTS;
            case cfb.c -> DeathMessageType.INTENTIONAL_GAME_DESIGN;
            default -> throw new IllegalArgumentException("NMS DeathMessageType." + String.valueOf(deathMessageType) + " cannot be converted to a Bukkit DeathMessageType.");
        };
    }

    public static cfb deathMessageTypeToNMS(DeathMessageType deathMessageType) {
        return switch (deathMessageType) {
            case DeathMessageType.DEFAULT -> cfb.a;
            case DeathMessageType.FALL_VARIANTS -> cfb.b;
            case DeathMessageType.INTENTIONAL_GAME_DESIGN -> cfb.c;
            default -> throw new IllegalArgumentException("Bukkit DeathMessageType." + String.valueOf(deathMessageType) + " cannot be converted to a NMS DeathMessageType.");
        };
    }

    public static DamageScaling damageScalingToBukkit(cew damageScaling) {
        return switch (damageScaling) {
            case cew.c -> DamageScaling.ALWAYS;
            case cew.b -> DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER;
            case cew.a -> DamageScaling.NEVER;
            default -> throw new IllegalArgumentException("NMS DamageScaling." + String.valueOf(damageScaling) + " cannot be converted to a Bukkit DamageScaling");
        };
    }

    public static cew damageScalingToNMS(DamageScaling damageScaling) {
        return switch (damageScaling) {
            case DamageScaling.ALWAYS -> cew.c;
            case DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER -> cew.b;
            case DamageScaling.NEVER -> cew.a;
            default -> throw new IllegalArgumentException("Bukkit DamageScaling." + String.valueOf(damageScaling) + " cannot be converted to a NMS DamageScaling");
        };
    }

    public static DamageType minecraftHolderToBukkit(jd<cez> minecraftHolder) {
        return CraftDamageType.minecraftToBukkit(minecraftHolder.a());
    }

    public static jd<cez> bukkitToMinecraftHolder(DamageType bukkitDamageType) {
        Preconditions.checkArgument((bukkitDamageType != null ? 1 : 0) != 0);
        jq registry = CraftRegistry.getMinecraftRegistry(mj.ba);
        jd<cez> jd2 = registry.e(CraftDamageType.bukkitToMinecraft(bukkitDamageType));
        if (jd2 instanceof jd.c) {
            jd.c holder = (jd.c)jd2;
            return holder;
        }
        throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkitDamageType) + ", this can happen if a plugin creates its own damage type with out properly registering it.");
    }

    public static cez bukkitToMinecraft(DamageType bukkitDamageType) {
        return (cez)CraftRegistry.bukkitToMinecraft(bukkitDamageType);
    }

    public static DamageType minecraftToBukkit(cez minecraftDamageType) {
        return (DamageType)CraftRegistry.minecraftToBukkit(minecraftDamageType, mj.ba, Registry.DAMAGE_TYPE);
    }
}

