/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntityType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;

public class CraftEntitySnapshot
implements EntitySnapshot {
    private final uz data;
    private final EntityType type;

    private CraftEntitySnapshot(uz data, EntityType type) {
        this.data = data;
        this.type = type;
    }

    public EntityType getEntityType() {
        return this.type;
    }

    public Entity createEntity(World world) {
        cgk internal = this.createInternal(world);
        return internal.getBukkitEntity();
    }

    public Entity createEntity(Location location) {
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location has no world");
        cgk internal = this.createInternal(location.getWorld());
        internal.a_(location.getX(), location.getY(), location.getZ());
        return location.getWorld().addEntity((Entity)internal.getBukkitEntity());
    }

    public String getAsString() {
        return this.data.toString();
    }

    private cgk createInternal(World world) {
        axf nms = ((CraftWorld)world).getHandle();
        cgk internal = cgu.a(this.data, (dwo)nms, cgt.r, cgq.a);
        if (internal == null) {
            internal = CraftEntityType.bukkitToMinecraft(this.type).a(nms, cgt.r);
        }
        Preconditions.checkArgument((internal != null ? 1 : 0) != 0, (Object)"Error creating new entity.");
        fnq val = fno.a(bgp.a, (jf.a)nms.J_(), this.data);
        internal.d(val);
        return internal;
    }

    public uz getData() {
        return this.data;
    }

    public dpf<cgu<?>> getEntityTag() {
        return dpf.a(CraftEntityType.bukkitToMinecraft(this.type), this.data);
    }

    public static CraftEntitySnapshot create(CraftEntity entity) {
        fnp tag = fnp.a(bgp.a, entity.getHandle().eo());
        if (!entity.getHandle().saveAsPassenger(tag, false)) {
            return null;
        }
        return new CraftEntitySnapshot(tag.b(), entity.getType());
    }

    public static CraftEntitySnapshot create(uz tag, EntityType type) {
        if (tag == null || tag.j() || type == null) {
            return null;
        }
        return new CraftEntitySnapshot(tag, type);
    }

    public static CraftEntitySnapshot create(uz tag) {
        EntityType type = tag.a("id", cgu.a).map(CraftEntityType::minecraftToBukkit).orElse(null);
        return CraftEntitySnapshot.create(tag, type);
    }

    public static CraftEntitySnapshot create(dpf<cgu<?>> tag) {
        return CraftEntitySnapshot.create(tag.c(), CraftEntityType.minecraftToBukkit(tag.a()));
    }
}

