/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.bukkit.Sound;
import org.bukkit.craftbukkit.v1_21_R7.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.CraftSound;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftLivingEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.loot.LootTable;

public abstract class CraftMob
extends CraftLivingEntity
implements Mob {
    public CraftMob(CraftServer server, chn entity) {
        super(server, entity);
    }

    public void setTarget(LivingEntity target) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot set target during world generation");
        chn entity = this.getHandle();
        if (target == null) {
            entity.setTarget(null, null, false);
        } else if (target instanceof CraftLivingEntity) {
            entity.setTarget(((CraftLivingEntity)target).getHandle(), null, false);
        }
    }

    public CraftLivingEntity getTarget() {
        if (this.getHandle().ag_() == null) {
            return null;
        }
        return (CraftLivingEntity)this.getHandle().ag_().getBukkitEntity();
    }

    public void setAware(boolean aware) {
        this.getHandle().aware = aware;
    }

    public boolean isAware() {
        return this.getHandle().aware;
    }

    public Sound getAmbientSound() {
        bcz sound = this.getHandle().getAmbientSound0();
        return sound != null ? CraftSound.minecraftToBukkit(sound) : null;
    }

    @Override
    public chn getHandle() {
        return (chn)this.entity;
    }

    @Override
    public String toString() {
        return "CraftMob";
    }

    public void setLootTable(LootTable table) {
        this.getHandle().cH = Optional.ofNullable(CraftLootTable.bukkitToMinecraft(table));
    }

    public LootTable getLootTable() {
        return CraftLootTable.minecraftToBukkit(this.getHandle().er().orElse(null));
    }

    public void setSeed(long seed) {
        this.getHandle().cI = seed;
    }

    public long getSeed() {
        return this.getHandle().cI;
    }
}

