/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_21_R7.registry.CraftRegistryItem;
import org.bukkit.entity.Pig;

public class CraftPig
extends CraftAnimals
implements Pig {
    public CraftPig(CraftServer server, cxb entity) {
        super(server, entity);
    }

    public boolean hasSaddle() {
        return this.getHandle().al();
    }

    public void setSaddle(boolean saddled) {
        this.getHandle().a(cgv.h, saddled ? new dlt(dlx.oR) : dlt.l);
    }

    public int getBoostTicks() {
        return this.getHandle().cx.e ? this.getHandle().cx.d() : 0;
    }

    public void setBoostTicks(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks must be >= 0");
        this.getHandle().cx.setBoostTicks(ticks);
    }

    public int getCurrentBoostTicks() {
        return this.getHandle().cx.e ? this.getHandle().cx.f : 0;
    }

    public void setCurrentBoostTicks(int ticks) {
        if (!this.getHandle().cx.e) {
            return;
        }
        int max = this.getHandle().cx.d();
        Preconditions.checkArgument((ticks >= 0 && ticks <= max ? 1 : 0) != 0, (String)"boost ticks must not exceed 0 or %d (inclusive)", (int)max);
        this.getHandle().cx.f = ticks;
    }

    public Material getSteerMaterial() {
        return Material.CARROT_ON_A_STICK;
    }

    public Pig.Variant getVariant() {
        return CraftVariant.minecraftHolderToBukkit(this.getHandle().gP());
    }

    public void setVariant(Pig.Variant variant) {
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"variant");
        this.getHandle().b(CraftVariant.bukkitToMinecraftHolder(variant));
    }

    @Override
    public cxb getHandle() {
        return (cxb)this.entity;
    }

    @Override
    public String toString() {
        return "CraftPig";
    }

    public static class CraftVariant
    extends CraftRegistryItem<cxc>
    implements Pig.Variant {
        public static Pig.Variant minecraftToBukkit(cxc minecraft) {
            return (Pig.Variant)CraftRegistry.minecraftToBukkit(minecraft, mj.bo, Registry.PIG_VARIANT);
        }

        public static Pig.Variant minecraftHolderToBukkit(jd<cxc> minecraft) {
            return CraftVariant.minecraftToBukkit(minecraft.a());
        }

        public static cxc bukkitToMinecraft(Pig.Variant bukkit) {
            return (cxc)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static jd<cxc> bukkitToMinecraftHolder(Pig.Variant bukkit) {
            return CraftRegistry.bukkitToMinecraftHolder(bukkit, mj.bo);
        }

        public CraftVariant(NamespacedKey key, jd<cxc> handle) {
            super(key, handle);
        }

        public NamespacedKey getKey() {
            return this.getKeyOrThrow();
        }
    }
}

