/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R7.entity;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.entity.Sniffer;

public class CraftSniffer
extends CraftAnimals
implements Sniffer {
    public CraftSniffer(CraftServer server, cxm entity) {
        super(server, entity);
    }

    @Override
    public cxm getHandle() {
        return (cxm)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftSniffer";
    }

    public Collection<Location> getExploredLocations() {
        return this.getHandle().hj().map(blockPosition -> CraftLocation.toBukkit(blockPosition.b(), this.server.getServer().a(blockPosition.a()))).collect(Collectors.toList());
    }

    public void removeExploredLocation(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location cannot be null");
        if (location.getWorld() != this.getWorld()) {
            return;
        }
        is blockPosition = CraftLocation.toBlockPosition(location);
        this.getHandle().ev().a(cqw.bb, this.getHandle().hj().filter(blockPositionExplored -> !blockPositionExplored.equals(blockPosition)).collect(Collectors.toList()));
    }

    public void addExploredLocation(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location cannot be null");
        if (location.getWorld() != this.getWorld()) {
            return;
        }
        this.getHandle().i(CraftLocation.toBlockPosition(location));
    }

    public Sniffer.State getState() {
        return this.stateToBukkit(this.getHandle().he());
    }

    public void setState(Sniffer.State state) {
        Preconditions.checkArgument((state != null ? 1 : 0) != 0, (Object)"state cannot be null");
        this.getHandle().a(this.stateToNMS(state));
    }

    public Location findPossibleDigLocation() {
        return this.getHandle().gT().map(blockPosition -> CraftLocation.toBukkit(blockPosition, this.getLocation().getWorld())).orElse(null);
    }

    public boolean canDig() {
        return this.getHandle().gU();
    }

    private cxm.a stateToNMS(Sniffer.State state) {
        return switch (state) {
            default -> throw new MatchException(null, null);
            case Sniffer.State.IDLING -> cxm.a.a;
            case Sniffer.State.FEELING_HAPPY -> cxm.a.b;
            case Sniffer.State.SCENTING -> cxm.a.c;
            case Sniffer.State.SNIFFING -> cxm.a.d;
            case Sniffer.State.SEARCHING -> cxm.a.e;
            case Sniffer.State.DIGGING -> cxm.a.f;
            case Sniffer.State.RISING -> cxm.a.g;
        };
    }

    private Sniffer.State stateToBukkit(cxm.a state) {
        return switch (state) {
            default -> throw new MatchException(null, null);
            case cxm.a.a -> Sniffer.State.IDLING;
            case cxm.a.b -> Sniffer.State.FEELING_HAPPY;
            case cxm.a.c -> Sniffer.State.SCENTING;
            case cxm.a.d -> Sniffer.State.SNIFFING;
            case cxm.a.e -> Sniffer.State.SEARCHING;
            case cxm.a.f -> Sniffer.State.DIGGING;
            case cxm.a.g -> Sniffer.State.RISING;
        };
    }
}

